/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.frontend.js.loader.modules.extender.npm;

/**
 * Represents an NPM package dependency (i.e., another NPM package).
 *
 * @author Iván Zaera
 */
public class JSPackageDependency {

	/**
	 * Constructs a <code>JSPackageDependency</code> with the JS package,
	 * package name, and version constraints.
	 *
	 * @param jsPackage the package declaring the dependency
	 * @param packageName the dependency's package name
	 * @param versionConstraints the NPM semantic version expression defining
	 *        the suitable versions for the dependency
	 */
	public JSPackageDependency(
		JSPackage jsPackage, String packageName, String versionConstraints) {

		_jsPackage = jsPackage;
		_packageName = packageName;
		_versionConstraints = versionConstraints;
	}

	/**
	 * Returns the NPM package declaring the dependency.
	 *
	 * @return the NPM package
	 */
	public JSPackage getJSPackage() {
		return _jsPackage;
	}

	/**
	 * Returns the dependency's package name.
	 *
	 * @return the dependency's package name
	 */
	public String getPackageName() {
		return _packageName;
	}

	/**
	 * Returns the NPM semantic version expression defining the suitable
	 * versions for the dependency.
	 *
	 * @return the NPM semantic version expression
	 */
	public String getVersionConstraints() {
		return _versionConstraints;
	}

	private final JSPackage _jsPackage;
	private final String _packageName;
	private final String _versionConstraints;

}