/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.frontend.js.loader.modules.extender.npm;

/**
 * @author Iván Zaera
 */
public class JSModuleAlias {

	public JSModuleAlias(JSPackage jsPackage, String moduleName, String alias) {
		_jsPackage = jsPackage;
		_moduleName = moduleName;
		_alias = alias;
	}

	public String getAlias() {
		return _alias;
	}

	public JSPackage getJsPackage() {
		return _jsPackage;
	}

	public String getModuleName() {
		return _moduleName;
	}

	private final String _alias;
	private final JSPackage _jsPackage;
	private final String _moduleName;

}