/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.frontend.js.loader.modules.extender.npm;

import org.osgi.framework.Bundle;

/**
 * Processes an OSGi bundle to find NPM packages and modules inside it and make
 * them available for the {@link
 * com.liferay.frontend.js.loader.modules.extender.internal.npm.NPMRegistry} to
 * track them.
 *
 * <p>
 * There can be several {@link JSBundleProcessor}s deployed inside one portal if
 * necessary. This allows the deployment of OSGi bundles with different
 * structures containing the NPM packages.
 * </p>
 *
 * <p>
 * By default, the portal is bundled with a default {@link JSBundleProcessor}
 * implemented by {@link
 * com.liferay.frontend.js.loader.modules.extender.internal.npm.flat.FlatNPMBundleProcessor},
 * which looks for NPM packages inside the
 * <code>META-INF/resources/node_modules</code> folder.
 * </p>
 *
 * @author Iván Zaera
 */
public interface JSBundleProcessor {

	/**
	 * Returns a JS Bundle filled with the description of the NPM packages or
	 * modules found in the given bundle. If the given bundle does not contain
	 * an NPM package or module, this method returns <code>null</code>.
	 *
	 * <p>
	 * This method is invoked by the {@link
	 * com.liferay.frontend.js.loader.modules.extender.internal.npm.NPMRegistry}
	 * whenever a new OSGi bundle is deployed to the portal.
	 * </p>
	 *
	 * @param  bundle the handle to the OSGi bundle being deployed
	 * @return the valid bundle descriptor or <code>null</code> if no NPM
	 *         packages or modules were found
	 */
	public JSBundle process(Bundle bundle);

}