/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.frontend.js.loader.modules.extender.npm;

/**
 * Provides an object related to the NPM description model that can be directly
 * referenced by its unique ID. A {@link JSBundle} contains {@link
 * JSBundleObject}s.
 *
 * @author Iván Zaera
 */
public interface JSBundleObject {

	/**
	 * Returns the model object's unique ID. Since these IDs are guaranteed to
	 * be unique across one portal, they can be used for referencing the object
	 * and lookups.
	 *
	 * @return the unique ID of the model object
	 */
	public String getId();

	/**
	 * Returns the model object's name. Unlike IDs, names can be duplicated and
	 * may be not unique.
	 *
	 * @return the symbolic name of the object
	 */
	public String getName();

}