/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.frontend.js.loader.modules.extender.npm;

import java.io.IOException;
import java.io.InputStream;

/**
 * Provides contents of a <code>JSBundleObject</code>. These contents can be
 * requested from external apps by using a portal URL or {@link InputStream}.
 *
 * @author Iván Zaera
 */
public interface JSBundleAsset extends JSBundleObject {

	/**
	 * Returns the asset's contents.
	 *
	 * @return an {@link InputStream} that allows reading the bytes inside the
	 *         asset
	 * @throws IOException if an IO exception occurred
	 */
	public InputStream getInputStream() throws IOException;

	/**
	 * Returns the asset's public URL. This URL can be used to retrieve the
	 * asset's contents from external apps by making an HTTP request to the
	 * portal.
	 *
	 * @return the asset's public URL
	 */
	public String getURL();

}