/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.frontend.js.loader.modules.extender.npm;

import java.net.URL;

import java.util.Collection;

/**
 * Represents an OSGi bundle containing NPM packages and modules.
 *
 * @author Iván Zaera
 */
public interface JSBundle extends JSBundleObject {

	/**
	 * Returns the NPM packages provided by the OSGi bundle.
	 *
	 * @return the NPM packages
	 */
	public Collection<JSPackage> getJSPackages();

	/**
	 * Returns the {@link URL} of an OSGi bundle's resource.
	 *
	 * @return the URL of an OSGi bundle's resource
	 */
	public URL getResourceURL(String location);

	/**
	 * Returns the bundle's OSGi version.
	 *
	 * @return the bundle's OSGi version
	 */
	public String getVersion();

}