/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.js.loader.modules.extender.internal;

import com.liferay.frontend.js.loader.modules.extender.internal.Details;
import com.liferay.frontend.js.loader.modules.extender.internal.JSLoaderModule;
import com.liferay.frontend.js.loader.modules.extender.internal.JSLoaderModulesPortalWebResources;
import com.liferay.frontend.js.loader.modules.extender.internal.JSLoaderModulesTracker;
import com.liferay.portal.kernel.util.PortalUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashSet;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.utils.log.Logger;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.Designate;

@Component(configurationPid={"com.liferay.frontend.js.loader.modules.extender.internal.Details"}, immediate=true, property={"osgi.http.whiteboard.servlet.name=com.liferay.frontend.js.loader.modules.extender.internal.JSLoaderModulesServlet", "osgi.http.whiteboard.servlet.pattern=/js_loader_modules", "service.ranking:Integer=2147482647"}, service={JSLoaderModulesServlet.class, Servlet.class})
@Designate(ocd=Details.class)
public class JSLoaderModulesServlet
extends HttpServlet {
    private ComponentContext _componentContext;
    private volatile Details _details;
    private JSLoaderModulesTracker _jsLoaderModulesTracker;
    private Logger _logger;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this._componentContext.enableComponent(JSLoaderModulesPortalWebResources.class.getName());
    }

    @Activate
    @Modified
    protected void activate(ComponentContext componentContext, Details details) throws Exception {
        this._details = details;
        this._logger = new Logger(componentContext.getBundleContext());
        this._componentContext = componentContext;
    }

    protected JSLoaderModulesTracker getJSLoaderModulesTracker() {
        return this._jsLoaderModulesTracker;
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType("text/javascript; charset=UTF-8");
        ServletOutputStream servletOutputStream = response.getOutputStream();
        PrintWriter printWriter = new PrintWriter((OutputStream)servletOutputStream, true);
        printWriter.println("(function() {");
        printWriter.println("Liferay.PATHS = {");
        String delimiter = "";
        HashSet<String> processedNames = new HashSet<String>();
        Collection<JSLoaderModule> jsLoaderModules = this._jsLoaderModulesTracker.getJSLoaderModules();
        for (JSLoaderModule jsLoaderModule : jsLoaderModules) {
            printWriter.write(delimiter);
            printWriter.write("'");
            printWriter.write(jsLoaderModule.getName());
            printWriter.write(64);
            printWriter.write(jsLoaderModule.getVersion());
            printWriter.write("': '");
            printWriter.write(PortalUtil.getPathProxy());
            printWriter.write(jsLoaderModule.getContextPath());
            printWriter.write("'");
            if (!processedNames.contains(jsLoaderModule.getName())) {
                processedNames.add(jsLoaderModule.getName());
                printWriter.println(",");
                printWriter.write("'");
                printWriter.write(jsLoaderModule.getName());
                printWriter.write("': '");
                printWriter.write(PortalUtil.getPathProxy());
                printWriter.write(jsLoaderModule.getContextPath());
                printWriter.write("'");
            }
            delimiter = ",\n";
        }
        printWriter.println("\n};");
        printWriter.println("Liferay.MODULES = {");
        delimiter = "";
        processedNames.clear();
        for (JSLoaderModule jsLoaderModule : jsLoaderModules) {
            String versionedConfiguration;
            String unversionedConfiguration = jsLoaderModule.getUnversionedConfiguration();
            if (unversionedConfiguration.length() == 0) continue;
            if (!processedNames.contains(jsLoaderModule.getName())) {
                processedNames.add(jsLoaderModule.getName());
                printWriter.write(delimiter);
                printWriter.write(unversionedConfiguration);
                delimiter = ",\n";
            }
            if ((versionedConfiguration = jsLoaderModule.getVersionedConfiguration()).length() <= 0) continue;
            printWriter.write(delimiter);
            printWriter.write(versionedConfiguration);
            delimiter = ",\n";
        }
        printWriter.println("\n};");
        printWriter.println("Liferay.MAPS = {");
        delimiter = "";
        processedNames.clear();
        for (JSLoaderModule jsLoaderModule : jsLoaderModules) {
            if (processedNames.contains(jsLoaderModule.getName())) continue;
            processedNames.add(jsLoaderModule.getName());
            printWriter.write(delimiter);
            printWriter.write("'");
            printWriter.write(jsLoaderModule.getName());
            printWriter.write("': '");
            printWriter.write(jsLoaderModule.getName());
            printWriter.write(64);
            printWriter.write(jsLoaderModule.getVersion());
            printWriter.write("'");
            delimiter = ",\n";
            String unversionedMapsConfiguration = jsLoaderModule.getUnversionedMapsConfiguration();
            if (unversionedMapsConfiguration.equals("")) continue;
            printWriter.write(delimiter);
            printWriter.write(unversionedMapsConfiguration);
        }
        printWriter.println("\n};");
        printWriter.println("Liferay.EXPOSE_GLOBAL = " + this._details.exposeGlobal() + ";\n");
        printWriter.println("}());");
        printWriter.close();
    }

    protected void setDetails(Details details) {
        this._details = details;
    }

    @Reference(unbind="-")
    protected void setJSLoaderModulesTracker(JSLoaderModulesTracker jsLoaderModulesTracker) {
        this._jsLoaderModulesTracker = jsLoaderModulesTracker;
    }
}

