/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.friendly.url.model.impl;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalServiceUtil;
import com.liferay.friendly.url.model.FriendlyURLEntry;
import com.liferay.friendly.url.model.impl.FriendlyURLEntryBaseImpl;
import com.liferay.friendly.url.service.FriendlyURLEntryLocalServiceUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class FriendlyURLEntryImpl
extends FriendlyURLEntryBaseImpl {
    public String getCategorizedUrlTitle(String languageId) {
        if (!FeatureFlagManagerUtil.isEnabled((long)this.getCompanyId(), (String)"LPD-11147")) {
            return this.getUrlTitle();
        }
        String urlTitle = super.getUrlTitle(languageId, false);
        if (Validator.isNull((String)urlTitle) && Validator.isNull((String)(urlTitle = super.getUrlTitle(languageId, true)))) {
            return "";
        }
        AssetEntry assetEntry = AssetEntryLocalServiceUtil.fetchEntry((String)FriendlyURLEntry.class.getName(), (long)this.getFriendlyURLEntryId());
        if (assetEntry == null) {
            return urlTitle;
        }
        List assetCategories = assetEntry.getCategories();
        if (assetCategories.isEmpty()) {
            return urlTitle;
        }
        StringBundler sb = new StringBundler(assetCategories.size() * 2);
        for (AssetCategory assetCategory : assetCategories) {
            sb.append(assetCategory.getTitle(languageId));
            sb.append("/");
        }
        sb.append(urlTitle);
        return sb.toString();
    }

    @Override
    public String getUrlTitle() {
        String urlTitle = super.getUrlTitle();
        if (!Validator.isBlank((String)urlTitle)) {
            return urlTitle;
        }
        Map<String, String> languageIdToUrlTitleMap = this.getLanguageIdToUrlTitleMap();
        if (languageIdToUrlTitleMap.isEmpty()) {
            return "";
        }
        Collection<String> urlTitles = languageIdToUrlTitleMap.values();
        Iterator<String> iterator = urlTitles.iterator();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return "";
    }

    @Override
    public String getUrlTitleMapAsXML() {
        return LocalizationUtil.getXml(this.getLanguageIdToUrlTitleMap(), (String)this.getDefaultLanguageId(), (String)"UrlTitle", (boolean)true);
    }

    public boolean isMain() throws PortalException {
        FriendlyURLEntry friendlyURLEntry = FriendlyURLEntryLocalServiceUtil.getMainFriendlyURLEntry((long)this.getClassNameId(), (long)this.getClassPK());
        return friendlyURLEntry.getPrimaryKey() == this.getPrimaryKey();
    }
}

