/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.friendly.url.internal.upgrade.v3_4_1;

import com.liferay.friendly.url.model.FriendlyURLEntry;
import com.liferay.friendly.url.model.FriendlyURLEntryLocalization;
import com.liferay.friendly.url.model.FriendlyURLEntryMapping;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.dao.orm.common.SQLTransformer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.permission.ResourceActions;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class LayoutFriendlyURLEntryUpgradeProcess
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(LayoutFriendlyURLEntryUpgradeProcess.class);
    private final ClassNameLocalService _classNameLocalService;
    private final Portal _portal;
    private final ResourceActions _resourceActions;

    public LayoutFriendlyURLEntryUpgradeProcess(ClassNameLocalService classNameLocalService, Portal portal, ResourceActions resourceActions) {
        this._classNameLocalService = classNameLocalService;
        this._portal = portal;
        this._resourceActions = resourceActions;
    }

    /*
     * Exception decompiling
     */
    protected void doUpgrade() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredExpressionStatement.rewriteExpressions(StructuredExpressionStatement.java:70)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long _addFriendlyURLEntryIfAbsentAndGetId(long classNameId, long classPK, long companyId, long ctCollectionId, Map<Long, String> defaultLanguageIds, long groupId) throws Exception {
        long friendlyURLEntryId = this._getMappedFriendlyURLEntryId(classNameId, classPK, ctCollectionId);
        if (friendlyURLEntryId > 0L) {
            return friendlyURLEntryId;
        }
        try (PreparedStatement preparedStatement = this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"select friendlyURLEntryId from FriendlyURLEntry where ", "ctCollectionId = ? and groupId = ? and companyId = ? and ", "classNameId = ? and classPK = ?"}));){
            preparedStatement.setLong(1, ctCollectionId);
            preparedStatement.setLong(2, groupId);
            preparedStatement.setLong(3, companyId);
            preparedStatement.setLong(4, classNameId);
            preparedStatement.setLong(5, classPK);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                if (resultSet.next()) {
                    friendlyURLEntryId = resultSet.getLong("friendlyURLEntryId");
                }
            }
        }
        if (friendlyURLEntryId > 0L) {
            this._addFriendlyURLEntryMapping(classNameId, classPK, ctCollectionId, companyId, friendlyURLEntryId);
            return friendlyURLEntryId;
        }
        try {
            preparedStatement = this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"insert into FriendlyURLEntry (mvccVersion, ", "ctCollectionId, uuid_, defaultLanguageId, ", "friendlyURLEntryId, groupId, companyId, createDate, ", "modifiedDate, classNameId, classPK) values (?, ?, ?, ?, ", "?, ?, ?, ?, ?, ?, ?)"}));
            throwable = null;
            try {
                preparedStatement.setLong(1, 0L);
                preparedStatement.setLong(2, ctCollectionId);
                preparedStatement.setString(3, PortalUUIDUtil.generate());
                String defaultLanguageId = defaultLanguageIds.computeIfAbsent(groupId, curGroupId -> this._getSiteDefaultLocale((long)curGroupId));
                preparedStatement.setString(4, defaultLanguageId);
                friendlyURLEntryId = this.increment(FriendlyURLEntry.class.getName());
                preparedStatement.setLong(5, friendlyURLEntryId);
                preparedStatement.setLong(6, groupId);
                preparedStatement.setLong(7, companyId);
                Timestamp timestamp = new Timestamp(System.currentTimeMillis());
                preparedStatement.setTimestamp(8, timestamp);
                preparedStatement.setTimestamp(9, timestamp);
                preparedStatement.setLong(10, classNameId);
                preparedStatement.setLong(11, classPK);
                preparedStatement.executeUpdate();
                this._addFriendlyURLEntryMapping(classNameId, classPK, ctCollectionId, companyId, friendlyURLEntryId);
                long l = friendlyURLEntryId;
                return l;
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            finally {
                if (preparedStatement != null) {
                    if (throwable != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    } else {
                        preparedStatement.close();
                    }
                }
            }
        }
        catch (Exception exception) {
            if (!_log.isWarnEnabled()) return 0L;
            _log.warn((Object)"Unable to add friendly URL Entry", (Throwable)exception);
            return 0L;
        }
    }

    private void _addFriendlyURLEntryMapping(long classNameId, long classPK, long ctCollectionId, long companyId, long friendlyURLEntryId) throws Exception {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"insert into FriendlyURLEntryMapping (mvccVersion, ", "ctCollectionId, friendlyURLEntryMappingId, companyId, ", "classNameId, classPK, friendlyURLEntryId) values (?, ?, ", "?, ?, ?, ?, ?)"}));){
            preparedStatement.setLong(1, 0L);
            preparedStatement.setLong(2, ctCollectionId);
            preparedStatement.setLong(3, this.increment(FriendlyURLEntryMapping.class.getName()));
            preparedStatement.setLong(4, companyId);
            preparedStatement.setLong(5, classNameId);
            preparedStatement.setLong(6, classPK);
            preparedStatement.setLong(7, friendlyURLEntryId);
            preparedStatement.executeUpdate();
        }
    }

    private Map<String, String> _getFriendlyURLMap(long companyId, long classNameId, long ctCollectionId, long groupId, long plid, boolean privateLayout) throws Exception {
        HashMap<String, String> friendlyURLMap = new HashMap<String, String>();
        String sql = StringBundler.concat((String[])new String[]{"select LayoutFriendlyURL.friendlyURL, ", "LayoutFriendlyURL.languageId from LayoutFriendlyURL left join ", "FriendlyURLEntryLocalization on ", "(FriendlyURLEntryLocalization.ctCollectionId = ", "LayoutFriendlyURL.ctCollectionId and ", "FriendlyURLEntryLocalization.languageId = ", "LayoutFriendlyURL.languageId and ", "FriendlyURLEntryLocalization.urlTitle = ", "LayoutFriendlyURL.friendlyURL and ", "FriendlyURLEntryLocalization.groupId = LayoutFriendlyURL.groupId ", "and FriendlyURLEntryLocalization.classNameId = ? and ", "FriendlyURLEntryLocalization.classPK = LayoutFriendlyURL.plid) ", "where LayoutFriendlyURL.ctCollectionId = ? and ", "LayoutFriendlyURL.groupId = ? and LayoutFriendlyURL.companyId = ", "? and LayoutFriendlyURL.plid = ? and ", "LayoutFriendlyURL.privateLayout = ? and ", "FriendlyURLEntryLocalization.friendlyURLEntryLocalizationId is ", "null"});
        try (PreparedStatement preparedStatement = this.connection.prepareStatement(SQLTransformer.transform((String)sql));){
            preparedStatement.setLong(1, classNameId);
            preparedStatement.setLong(2, ctCollectionId);
            preparedStatement.setLong(3, groupId);
            preparedStatement.setLong(4, companyId);
            preparedStatement.setLong(5, plid);
            preparedStatement.setBoolean(6, privateLayout);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    friendlyURLMap.put(resultSet.getString("languageId"), resultSet.getString("friendlyURL"));
                }
            }
        }
        return friendlyURLMap;
    }

    private long _getMappedFriendlyURLEntryId(long classNameId, long classPK, long ctCollectionId) throws Exception {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("select friendlyURLEntryId from FriendlyURLEntryMapping where ctCollectionId = ? and classNameId = ? and classPK = ?");){
            preparedStatement.setLong(1, ctCollectionId);
            preparedStatement.setLong(2, classNameId);
            preparedStatement.setLong(3, classPK);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                if (resultSet.next()) {
                    long l = resultSet.getLong("friendlyURLEntryId");
                    return l;
                }
            }
        }
        return 0L;
    }

    private String _getSiteDefaultLocale(long groupId) {
        try {
            return LocaleUtil.toLanguageId((Locale)this._portal.getSiteDefaultLocale(groupId));
        }
        catch (PortalException portalException) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to get default locale group ID " + groupId), (Throwable)portalException);
            }
            throw new RuntimeException(portalException);
        }
    }

    private /* synthetic */ void lambda$doUpgrade$1(Map defaultLanguageIds, Object[] values, PreparedStatement preparedStatement) throws Exception {
        block4: {
            long ctCollectionId = (Long)values[0];
            long groupId = (Long)values[1];
            long companyId = (Long)values[2];
            long plid = (Long)values[3];
            boolean privateLayout = (Boolean)values[4];
            long classNameId = (Long)values[5];
            try {
                long friendlyURLEntryId = this._addFriendlyURLEntryIfAbsentAndGetId(classNameId, plid, companyId, ctCollectionId, defaultLanguageIds, groupId);
                if (friendlyURLEntryId == 0L) {
                    return;
                }
                Map<String, String> friendlyURLMap = this._getFriendlyURLMap(companyId, classNameId, ctCollectionId, groupId, plid, privateLayout);
                for (Map.Entry<String, String> entry : friendlyURLMap.entrySet()) {
                    preparedStatement.setLong(1, 0L);
                    preparedStatement.setLong(2, ctCollectionId);
                    preparedStatement.setLong(3, this.increment(FriendlyURLEntryLocalization.class.getName()));
                    preparedStatement.setLong(4, companyId);
                    preparedStatement.setLong(5, friendlyURLEntryId);
                    preparedStatement.setString(6, entry.getKey());
                    preparedStatement.setString(7, entry.getValue());
                    preparedStatement.setLong(8, groupId);
                    preparedStatement.setLong(9, classNameId);
                    preparedStatement.setLong(10, plid);
                    preparedStatement.executeUpdate();
                }
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block4;
                _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Unable to add friendly URL entry for ", "PLID ", plid, " in group ", groupId}), (Throwable)exception);
            }
        }
    }
}

