/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.friendly.url.internal.servlet;

import com.liferay.friendly.url.configuration.FriendlyURLRedirectionConfiguration;
import com.liferay.friendly.url.configuration.FriendlyURLRedirectionConfigurationProvider;
import com.liferay.petra.lang.HashUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.encryptor.Encryptor;
import com.liferay.portal.kernel.encryptor.EncryptorException;
import com.liferay.portal.kernel.exception.LayoutPermissionException;
import com.liferay.portal.kernel.exception.NoSuchGroupException;
import com.liferay.portal.kernel.exception.NoSuchLayoutException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.login.AuthLoginGroupSettingsUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutFriendlyURL;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.module.service.Snapshot;
import com.liferay.portal.kernel.portlet.LayoutFriendlyURLSeparatorComposite;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.LayoutFriendlyURLLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.LayoutService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.permission.LayoutPermissionUtil;
import com.liferay.portal.kernel.servlet.InactiveRequestHandler;
import com.liferay.portal.kernel.servlet.PortalMessages;
import com.liferay.portal.kernel.servlet.ServletContextPool;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.struts.LastPath;
import com.liferay.portal.kernel.util.FriendlyURLNormalizer;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.HttpComponentsUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.AsyncPortletServletRequest;
import com.liferay.redirect.provider.RedirectProvider;
import com.liferay.redirect.tracker.RedirectNotFoundTracker;
import com.liferay.site.model.SiteFriendlyURL;
import com.liferay.site.service.SiteFriendlyURLLocalService;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.osgi.service.component.annotations.Reference;

public class FriendlyURLServlet
extends HttpServlet {
    @Reference
    protected Encryptor encryptor;
    @Reference
    protected FriendlyURLNormalizer friendlyURLNormalizer;
    @Reference
    protected FriendlyURLRedirectionConfigurationProvider friendlyURLRedirectionConfigurationProvider;
    @Reference
    protected GroupLocalService groupLocalService;
    @Reference
    protected InactiveRequestHandler inactiveRequestHandler;
    @Reference
    protected LayoutFriendlyURLLocalService layoutFriendlyURLLocalService;
    @Reference
    protected LayoutLocalService layoutLocalService;
    @Reference
    protected LayoutService layoutService;
    @Reference
    protected Portal portal;
    @Reference
    protected SiteFriendlyURLLocalService siteFriendlyURLLocalService;
    @Reference
    protected UserLocalService userLocalService;
    private static final Log _log = LogFactoryUtil.getLog(FriendlyURLServlet.class);
    private static final Snapshot<RedirectNotFoundTracker> _redirectNotFoundTrackerSnapshot = new Snapshot(FriendlyURLServlet.class, RedirectNotFoundTracker.class, null, true);
    private static final Snapshot<RedirectProvider> _redirectProviderSnapshot = new Snapshot(FriendlyURLServlet.class, RedirectProvider.class, null, true);
    private String _friendlyURLPathPrefix;
    private int _pathInfoOffset;
    private boolean _private;
    private boolean _user;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Redirect getRedirect(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String path) throws PortalException {
        Layout layout;
        if (path.length() <= 1) {
            return new Redirect();
        }
        String groupFriendlyURL = path;
        int pos = path.indexOf(47, 1);
        if (pos != -1) {
            String friendlyURL = path.substring(pos);
            if (friendlyURL.startsWith("/documents/d/")) {
                String fileEntryFriendlyURL = friendlyURL.substring("/documents/d/".length() - 1);
                groupFriendlyURL = fileEntryFriendlyURL.substring(0, fileEntryFriendlyURL.indexOf(47, 1));
            } else {
                groupFriendlyURL = path.substring(0, pos);
            }
        }
        long companyId = PortalInstances.getCompanyId((HttpServletRequest)httpServletRequest);
        Group group = this._getGroup(path, groupFriendlyURL, companyId);
        Locale locale = this.portal.getLocale(httpServletRequest, null, false);
        SiteFriendlyURL alternativeSiteFriendlyURL = this._getAlternativeSiteFriendlyURL(groupFriendlyURL, companyId, group, locale);
        String layoutFriendlyURL = null;
        Redirect redirectProviderRedirect = null;
        if (pos != -1 && pos + 1 != path.length()) {
            layoutFriendlyURL = path.substring(pos);
            if (StringUtil.endsWith((String)layoutFriendlyURL, (char)'/')) {
                layoutFriendlyURL = layoutFriendlyURL.substring(0, layoutFriendlyURL.length() - 1);
            }
            if ((redirectProviderRedirect = this._getRedirectProviderRedirect(group.getGroupId(), httpServletRequest, layoutFriendlyURL)) != null && !this._isSkipRedirect(httpServletRequest)) {
                return redirectProviderRedirect;
            }
        } else {
            httpServletRequest.setAttribute("REDIRECT_TO_DEFAULT_LAYOUT", (Object)Boolean.TRUE);
        }
        HashMap requestContext = HashMapBuilder.put((Object)"request", (Object)httpServletRequest).build();
        ServiceContextThreadLocal.pushServiceContext((ServiceContext)this._getServiceContext(group, httpServletRequest));
        Layout defaultLayout = null;
        HashMap params = httpServletRequest.getParameterMap();
        try {
            String layoutFriendlyURLSeparatorCompositeFriendlyURL;
            LayoutFriendlyURLSeparatorComposite layoutFriendlyURLSeparatorComposite = this.portal.getLayoutFriendlyURLSeparatorComposite(group.getGroupId(), this._private, layoutFriendlyURL, (Map)params, (Map)requestContext);
            if (layoutFriendlyURLSeparatorComposite.isRedirect() && (pos = path.indexOf(layoutFriendlyURLSeparatorComposite.getURLSeparator())) != 1) {
                String requestURL = this.portal.getCurrentCompleteURL(httpServletRequest);
                int friendlyURLPos = requestURL.indexOf(layoutFriendlyURL);
                String friendlyURL = layoutFriendlyURLSeparatorComposite.getFriendlyURL();
                String redirectURL = null;
                redirectURL = friendlyURLPos > 0 ? requestURL.substring(0, friendlyURLPos) + friendlyURL : StringBundler.concat((String[])new String[]{this.portal.getPathContext(), PropsValues.LAYOUT_FRIENDLY_URL_PUBLIC_SERVLET_MAPPING, path.substring(0, pos), friendlyURL});
                String queryString = HttpComponentsUtil.getQueryString((HttpServletRequest)this.portal.getOriginalServletRequest(httpServletRequest));
                if (Validator.isNotNull((String)queryString)) {
                    redirectURL = redirectURL + "?" + queryString;
                }
                Redirect redirect = new Redirect(redirectURL, true, this._isPermanentRedirect(group.getCompanyId()));
                return redirect;
            }
            Layout layout2 = layoutFriendlyURLSeparatorComposite.getLayout();
            if (layout2 != null) {
                User user = this._getUser(httpServletRequest);
                PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)user);
                if (!LayoutPermissionUtil.contains((PermissionChecker)permissionChecker, (Layout)layout2, (String)"VIEW")) {
                    if (AuthLoginGroupSettingsUtil.isPromptEnabled((long)group.getGroupId())) {
                        String redirect = this.portal.getLayoutActualURL(layout2, "/c");
                        Redirect queryString = new Redirect(redirect);
                        return queryString;
                    }
                    throw new LayoutPermissionException();
                }
                if (user.isGuestUser() && layout2.isSystem() && Objects.equals(layout2.getFriendlyURL(), PropsValues.CONTROL_PANEL_LAYOUT_FRIENDLY_URL)) {
                    throw new NoSuchLayoutException();
                }
                if (redirectProviderRedirect != null && !LayoutPermissionUtil.containsLayoutUpdatePermission((PermissionChecker)permissionChecker, (Layout)layout2)) {
                    Redirect redirect = redirectProviderRedirect;
                    return redirect;
                }
            }
            defaultLayout = layout2;
            httpServletRequest.setAttribute("LAYOUT", (Object)layout2);
            if (Objects.equals(httpServletRequest.getRequestURI(), PropsValues.LAYOUT_FRIENDLY_URL_PAGE_NOT_FOUND)) {
                httpServletRequest.removeAttribute(NoSuchLayoutException.class.getName());
            }
            if (Validator.isNull((String)(layoutFriendlyURLSeparatorCompositeFriendlyURL = layoutFriendlyURLSeparatorComposite.getFriendlyURL()))) {
                layoutFriendlyURLSeparatorCompositeFriendlyURL = layout2.getFriendlyURL(locale);
            }
            if ((pos = layoutFriendlyURLSeparatorCompositeFriendlyURL.indexOf(layoutFriendlyURLSeparatorComposite.getURLSeparator())) != 0) {
                if (pos != -1) {
                    layoutFriendlyURLSeparatorCompositeFriendlyURL = layoutFriendlyURLSeparatorCompositeFriendlyURL.substring(0, pos);
                }
                String i18nLanguageId = (String)httpServletRequest.getAttribute("I18N_LANGUAGE_ID");
                boolean localeUnavailable = false;
                if (!(!Validator.isNotNull((String)i18nLanguageId) || LanguageUtil.isAvailableLocale((long)group.getGroupId(), (String)i18nLanguageId) || this.portal.isGroupControlPanelPath(path) && LanguageUtil.isAvailableLocale((String)i18nLanguageId))) {
                    localeUnavailable = true;
                }
                if (localeUnavailable || alternativeSiteFriendlyURL != null || !this._equalsLayoutFriendlyURL(layoutFriendlyURLSeparatorCompositeFriendlyURL, layout2, locale)) {
                    HttpServletRequest originalHttpServletRequest;
                    String redirect;
                    Locale originalLocale = this._setAlternativeLayoutFriendlyURL(companyId, httpServletRequest, layout2, layoutFriendlyURLSeparatorCompositeFriendlyURL, alternativeSiteFriendlyURL);
                    if (localeUnavailable && PropsValues.LOCALE_USE_DEFAULT_IF_NOT_AVAILABLE) {
                        locale = LocaleUtil.fromLanguageId((String)group.getDefaultLanguageId());
                    }
                    if ((redirect = this._getLocalizedFriendlyURL(httpServletRequest, layout2, locale, originalLocale)).equals((originalHttpServletRequest = this.portal.getOriginalServletRequest(httpServletRequest)).getRequestURI())) {
                        throw new NoSuchLayoutException();
                    }
                    boolean forcePermanentRedirect = true;
                    if (Validator.isNull((String)i18nLanguageId)) {
                        forcePermanentRedirect = this._isPermanentRedirect(group.getCompanyId());
                    }
                    Redirect redirect2 = new Redirect(redirect, true, forcePermanentRedirect);
                    return redirect2;
                }
            }
        }
        catch (LayoutPermissionException | NoSuchLayoutException exception) {
            Layout redirectLayout = null;
            if (!(exception instanceof LayoutPermissionException)) {
                redirectLayout = layoutFriendlyURL == null ? defaultLayout : this._getLayoutFriendlyURLLayout(group, layoutFriendlyURL, httpServletRequest);
            }
            if (redirectLayout != null) {
                String redirect = this.portal.getLayoutActualURL(redirectLayout, "/c");
                Redirect redirect3 = new Redirect(redirect);
                return redirect3;
            }
            RedirectNotFoundTracker currentRedirectNotFoundTracker = (RedirectNotFoundTracker)_redirectNotFoundTrackerSnapshot.get();
            if (currentRedirectNotFoundTracker != null) {
                currentRedirectNotFoundTracker.trackURL(group, this._normalizeFriendlyURL(layoutFriendlyURL));
            }
            if (Validator.isNotNull((String)PropsValues.LAYOUT_FRIENDLY_URL_PAGE_NOT_FOUND)) {
                if (exception instanceof NoSuchLayoutException) {
                    throw exception;
                }
                throw new NoSuchLayoutException(exception);
            }
            httpServletResponse.setStatus(404);
            httpServletRequest.setAttribute(NoSuchLayoutException.class.getName(), (Object)Boolean.TRUE);
            layoutFriendlyURL = null;
        }
        finally {
            ServiceContextThreadLocal.popServiceContext();
        }
        String actualURL = this.portal.getActualURL(group.getGroupId(), this._private, "/c", layoutFriendlyURL, (Map)params, (Map)requestContext);
        String portalURL = this.portal.getPortalURL(httpServletRequest);
        if (actualURL.startsWith(portalURL)) {
            actualURL = StringUtil.removeSubstring((String)actualURL, (String)portalURL);
        }
        long userId = this.portal.getUserId(httpServletRequest);
        boolean impersonated = this._isImpersonated(httpServletRequest, userId);
        if (userId > 0L && impersonated) {
            try {
                Company company = this.portal.getCompany(httpServletRequest);
                String encDoAsUserId = this.encryptor.encrypt(company.getKeyObj(), String.valueOf(userId));
                actualURL = HttpComponentsUtil.setParameter((String)actualURL, (String)"doAsUserId", (String)encDoAsUserId);
                params = new HashMap(params);
                params.remove("doAsUserId");
            }
            catch (EncryptorException encryptorException) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Throwable)encryptorException);
                }
                return new Redirect(actualURL, false, false);
            }
        }
        if ((layout = (Layout)httpServletRequest.getAttribute("LAYOUT")) != null && Objects.equals(layout.getType(), "url")) {
            actualURL = actualURL.concat(HttpComponentsUtil.parameterMapToString((Map)params, (!actualURL.contains("?") ? 1 : 0) != 0));
        }
        return new Redirect(actualURL, false, !impersonated && this._isPermanentRedirect(group.getCompanyId()));
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        ServletContext servletContext = servletConfig.getServletContext();
        if (servletContext != ServletContextPool.get((String)this.portal.getServletContextName())) {
            return;
        }
        super.init(servletConfig);
        this._private = GetterUtil.getBoolean((String)servletConfig.getInitParameter("servlet.init.private"));
        String proxyPath = this.portal.getPathProxy();
        this._user = GetterUtil.getBoolean((String)servletConfig.getInitParameter("servlet.init.user"));
        this._friendlyURLPathPrefix = this._private ? (this._user ? this.portal.getPathFriendlyURLPrivateUser() : this.portal.getPathFriendlyURLPrivateGroup()) : this.portal.getPathFriendlyURLPublic();
        this._pathInfoOffset = this._friendlyURLPathPrefix.length() - proxyPath.length();
    }

    public void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        Redirect redirect;
        block14: {
            String pathInfo = this._getPathInfo(httpServletRequest);
            redirect = null;
            try {
                redirect = this.getRedirect(httpServletRequest, httpServletResponse, pathInfo);
                if (httpServletRequest.getAttribute("LAST_PATH") == null) {
                    httpServletRequest.setAttribute("LAST_PATH", (Object)this._getLastPath(httpServletRequest, pathInfo));
                }
            }
            catch (PortalException portalException) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Throwable)portalException);
                }
                if (!(portalException instanceof NoSuchGroupException) && !(portalException instanceof NoSuchLayoutException)) break block14;
                this.portal.sendError(404, (Exception)((Object)portalException), httpServletRequest, httpServletResponse);
                return;
            }
        }
        if (redirect == null) {
            redirect = new Redirect();
        }
        if (redirect.isValidForward()) {
            AsyncPortletServletRequest asyncPortletServletRequest;
            ServletContext servletContext = this.getServletContext();
            RequestDispatcher requestDispatcher = servletContext.getRequestDispatcher(redirect.getPath());
            if (httpServletRequest.isAsyncSupported() && (asyncPortletServletRequest = AsyncPortletServletRequest.getAsyncPortletServletRequest((HttpServletRequest)httpServletRequest)) != null) {
                asyncPortletServletRequest.update(servletContext.getContextPath(), redirect.getPath());
            }
            if (requestDispatcher != null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)StringBundler.concat((String[])new String[]{"Forward from ", httpServletRequest.getRequestURI(), " to ", redirect.getPath()}));
                }
                requestDispatcher.forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            }
        } else if (redirect.isPermanent()) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((String[])new String[]{"Location moved permanently from ", httpServletRequest.getRequestURI(), " to ", redirect.getPath()}));
            }
            httpServletResponse.setHeader("Location", redirect.getPath());
            httpServletResponse.setStatus(301);
        } else {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((String[])new String[]{"Redirect from ", httpServletRequest.getRequestURI(), " to ", redirect.getPath()}));
            }
            httpServletResponse.sendRedirect(redirect.getPath());
        }
    }

    private boolean _equalsLayoutFriendlyURL(String layoutFriendlyURLSeparatorCompositeFriendlyURL, Layout layout, Locale locale) {
        String layoutFriendlyURL = layout.getFriendlyURL(locale);
        return StringUtil.equalsIgnoreCase((String)layoutFriendlyURLSeparatorCompositeFriendlyURL, (String)layoutFriendlyURL) || StringUtil.equalsIgnoreCase((String)this.friendlyURLNormalizer.normalizeWithEncoding(layoutFriendlyURLSeparatorCompositeFriendlyURL), (String)layoutFriendlyURL);
    }

    private SiteFriendlyURL _getAlternativeSiteFriendlyURL(String friendlyURL, long companyId, Group group, Locale locale) {
        SiteFriendlyURL siteFriendlyURL = this.siteFriendlyURLLocalService.fetchSiteFriendlyURL(companyId, group.getGroupId(), LocaleUtil.toLanguageId((Locale)locale));
        if (siteFriendlyURL == null) {
            siteFriendlyURL = this.siteFriendlyURLLocalService.fetchSiteFriendlyURLByFriendlyURL(companyId, friendlyURL);
        }
        SiteFriendlyURL alternativeSiteFriendlyURL = null;
        if (siteFriendlyURL != null && !StringUtil.equalsIgnoreCase((String)siteFriendlyURL.getFriendlyURL(), (String)friendlyURL)) {
            alternativeSiteFriendlyURL = this.siteFriendlyURLLocalService.fetchSiteFriendlyURLByFriendlyURL(siteFriendlyURL.getCompanyId(), friendlyURL);
        }
        return alternativeSiteFriendlyURL;
    }

    private String _getFriendlyURLRedirectionType(long companyId) {
        FriendlyURLRedirectionConfiguration friendlyURLRedirectionConfiguration = this.friendlyURLRedirectionConfigurationProvider.getCompanyFriendlyURLRedirectionConfiguration(companyId);
        return friendlyURLRedirectionConfiguration.redirectionType();
    }

    private Group _getGroup(String path, String friendlyURL, long companyId) throws NoSuchGroupException {
        Group group = this.groupLocalService.fetchFriendlyURLGroup(companyId, friendlyURL);
        if (group == null) {
            String screenName = friendlyURL.substring(1);
            User user = this.userLocalService.fetchUserByScreenName(companyId, screenName);
            if (user != null) {
                group = user.getGroup();
            } else if (_log.isWarnEnabled()) {
                _log.warn((Object)("No user exists with friendly URL " + screenName));
            }
        }
        if (group == null || !group.isActive() && !this.inactiveRequestHandler.isShowInactiveRequestMessage() && !path.startsWith("/control_panel") && !path.startsWith(friendlyURL + "/~")) {
            throw new NoSuchGroupException(StringBundler.concat((Object[])new Object[]{"{companyId=", companyId, ", friendlyURL=", friendlyURL, "}"}));
        }
        return group;
    }

    private LastPath _getLastPath(HttpServletRequest httpServletRequest, String pathInfo) {
        String lifecycle = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"p_p_lifecycle");
        if (lifecycle.equals("1")) {
            return new LastPath(this._friendlyURLPathPrefix, pathInfo);
        }
        return new LastPath(this._friendlyURLPathPrefix, pathInfo, HttpComponentsUtil.parameterMapToString((Map)httpServletRequest.getParameterMap()));
    }

    private Layout _getLayoutFriendlyURLLayout(Group group, String friendlyURL, HttpServletRequest httpServletRequest) {
        LayoutFriendlyURL layoutFriendlyURL = this.layoutFriendlyURLLocalService.fetchFirstLayoutFriendlyURL(group.getGroupId(), this._private, friendlyURL);
        if (layoutFriendlyURL == null) {
            if (group.isUser()) {
                List layouts = this.layoutLocalService.getLayouts(group.getGroupId(), this._private, 0L);
                for (Layout layout : layouts) {
                    if (!layout.matches(httpServletRequest, friendlyURL)) continue;
                    return layout;
                }
            }
            return null;
        }
        Layout layout = this.layoutLocalService.fetchLayout(layoutFriendlyURL.getPlid());
        if (layout != null && !layout.isSystem()) {
            return layout;
        }
        return null;
    }

    private String _getLocalizedFriendlyURL(HttpServletRequest httpServletRequest, Layout layout, Locale locale, Locale originalLocale) {
        String requestURI = this._getRequestURI(httpServletRequest);
        int[] groupFriendlyURLIndex = this.portal.getGroupFriendlyURLIndex(requestURI);
        if (groupFriendlyURLIndex != null) {
            int pos;
            String originalRequestURI = this._getRequestURI(this.portal.getOriginalServletRequest(httpServletRequest));
            if (httpServletRequest.getAttribute("I18N_PATH") != null && (pos = originalRequestURI.indexOf("/", 1)) != -1) {
                originalRequestURI = originalRequestURI.substring(pos);
            }
            if (this.portal.getGroupFriendlyURLIndex(originalRequestURI) == null) {
                requestURI = requestURI.substring(groupFriendlyURLIndex[1]);
            }
        }
        String layoutFriendlyURL = null;
        if (originalLocale == null) {
            int y;
            String path = httpServletRequest.getPathInfo();
            int x = path.indexOf(47, 1);
            if (x != -1 && x + 1 != path.length()) {
                layoutFriendlyURL = path.substring(x);
            }
            if ((y = layoutFriendlyURL.indexOf("/~")) != -1 && (y = layoutFriendlyURL.indexOf(47, 3)) != -1 && y + 1 != layoutFriendlyURL.length()) {
                layoutFriendlyURL = layoutFriendlyURL.substring(y);
            }
            if ((y = layoutFriendlyURL.indexOf("/-/")) != -1) {
                layoutFriendlyURL = layoutFriendlyURL.substring(0, y);
            }
        } else {
            layoutFriendlyURL = layout.getFriendlyURL(originalLocale);
        }
        if (requestURI.contains(layoutFriendlyURL)) {
            requestURI = StringUtil.replaceFirst((String)requestURI, (String)layoutFriendlyURL, (String)layout.getFriendlyURL(locale));
        }
        boolean appendI18nPath = true;
        int localePrependFriendlyURLStyle = PrefsPropsUtil.getInteger((long)this.portal.getCompanyId(httpServletRequest), (String)"locale.prepend.friendly.url.style");
        if (localePrependFriendlyURLStyle == 0 || localePrependFriendlyURLStyle == 1 && locale.equals(LocaleUtil.getDefault())) {
            appendI18nPath = false;
        }
        String localizedFriendlyURL = this.portal.getPathContext();
        if (appendI18nPath) {
            String i18nPathLanguageId = this.portal.getI18nPathLanguageId(locale, LocaleUtil.toLanguageId((Locale)locale));
            String i18nPath = "/" + i18nPathLanguageId;
            localizedFriendlyURL = localizedFriendlyURL + i18nPath;
        }
        localizedFriendlyURL = localizedFriendlyURL + requestURI;
        String queryString = httpServletRequest.getQueryString();
        if (Validator.isNull((String)queryString)) {
            queryString = (String)httpServletRequest.getAttribute("javax.servlet.forward.query_string");
        }
        if (Validator.isNotNull((String)queryString)) {
            localizedFriendlyURL = localizedFriendlyURL + "?" + queryString;
        }
        return localizedFriendlyURL;
    }

    private String _getPathInfo(HttpServletRequest httpServletRequest) {
        String requestURI = httpServletRequest.getRequestURI();
        int pos = requestURI.indexOf(";jsessionid=");
        if (pos == -1) {
            return requestURI.substring(this._pathInfoOffset);
        }
        return requestURI.substring(this._pathInfoOffset, pos);
    }

    private Redirect _getRedirectProviderRedirect(long groupId, HttpServletRequest httpServletRequest, String layoutFriendlyURL) {
        RedirectProvider redirectProvider = (RedirectProvider)_redirectProviderSnapshot.get();
        if (redirectProvider == null || LiferayWindowState.isExclusive((HttpServletRequest)httpServletRequest) || LiferayWindowState.isPopUp((HttpServletRequest)httpServletRequest)) {
            return null;
        }
        HttpServletRequest originalHttpServletRequest = this.portal.getOriginalServletRequest(httpServletRequest);
        RedirectProvider.Redirect redirect = redirectProvider.getRedirect(groupId, this._normalizeFriendlyURL(layoutFriendlyURL), this._normalizeFriendlyURL(originalHttpServletRequest.getRequestURI()), httpServletRequest.getHeader("User-Agent"));
        if (redirect == null) {
            return null;
        }
        return new Redirect(redirect.getDestinationURL(), true, redirect.isPermanent());
    }

    private String _getRequestURI(HttpServletRequest httpServletRequest) {
        String contextPath = this.portal.getPathContext();
        String requestURI = httpServletRequest.getRequestURI();
        if (Validator.isNotNull((String)contextPath) && requestURI.startsWith(contextPath)) {
            requestURI = requestURI.substring(contextPath.length());
        }
        return StringUtil.replace((String)requestURI, (String)"//", (String)"/");
    }

    private ServiceContext _getServiceContext(Group group, HttpServletRequest httpServletRequest) throws PortalException {
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        if (serviceContext == null) {
            serviceContext = ServiceContextFactory.getInstance((HttpServletRequest)httpServletRequest);
            ServiceContextThreadLocal.pushServiceContext((ServiceContext)serviceContext);
        }
        serviceContext = (ServiceContext)serviceContext.clone();
        serviceContext.setCompanyId(group.getCompanyId());
        serviceContext.setScopeGroupId(group.getGroupId());
        return serviceContext;
    }

    private User _getUser(HttpServletRequest httpServletRequest) throws PortalException {
        User user = this.portal.getUser(httpServletRequest);
        if (user == null) {
            user = this.userLocalService.getGuestUser(this.portal.getCompanyId(httpServletRequest));
        }
        return user;
    }

    private boolean _isImpersonated(HttpServletRequest httpServletRequest, long userId) {
        HttpSession httpSession = httpServletRequest.getSession();
        Long realUserId = (Long)httpSession.getAttribute("USER_ID");
        return realUserId != null && userId != realUserId;
    }

    private boolean _isPermanentRedirect(long companyId) {
        return Objects.equals(this._getFriendlyURLRedirectionType(companyId), "permanent");
    }

    private boolean _isShowAlternativeLayoutFriendlyURLMessage(long companyId) {
        FriendlyURLRedirectionConfiguration friendlyURLRedirectionConfiguration = this.friendlyURLRedirectionConfigurationProvider.getCompanyFriendlyURLRedirectionConfiguration(companyId);
        return friendlyURLRedirectionConfiguration.showAlternativeLayoutFriendlyURLMessage();
    }

    private boolean _isSkipRedirect(HttpServletRequest httpServletRequest) {
        int index;
        String refererURL = httpServletRequest.getHeader("Referer");
        if (Validator.isNotNull((String)refererURL) && (index = refererURL.indexOf(63)) != -1) {
            refererURL = refererURL.substring(0, index);
        }
        if (Validator.isNotNull((String)refererURL)) {
            return refererURL.contains("/~/control_panel");
        }
        return false;
    }

    private String _normalizeFriendlyURL(String friendlyURL) {
        if (Validator.isNull((String)friendlyURL)) {
            return friendlyURL;
        }
        String normalizedFriendlyURL = this.friendlyURLNormalizer.normalizeWithEncoding(HttpComponentsUtil.decodeURL((String)friendlyURL));
        if (normalizedFriendlyURL.startsWith("/")) {
            return normalizedFriendlyURL.substring(1);
        }
        return normalizedFriendlyURL;
    }

    private Locale _setAlternativeLayoutFriendlyURL(long companyId, HttpServletRequest httpServletRequest, Layout layout, String friendlyURL, SiteFriendlyURL siteFriendlyURL) {
        List layoutFriendlyURLs = this.layoutFriendlyURLLocalService.getLayoutFriendlyURLs(layout.getPlid(), friendlyURL, 0, 1);
        if (layoutFriendlyURLs.isEmpty()) {
            return null;
        }
        LayoutFriendlyURL layoutFriendlyURL = (LayoutFriendlyURL)layoutFriendlyURLs.get(0);
        Locale locale = LocaleUtil.fromLanguageId((String)layoutFriendlyURL.getLanguageId());
        if (!LanguageUtil.isAvailableLocale((long)layout.getGroupId(), (Locale)locale)) {
            return LocaleUtil.fromLanguageId((String)((String)httpServletRequest.getAttribute("I18N_LANGUAGE_ID")));
        }
        Locale groupLocale = locale;
        if (siteFriendlyURL != null) {
            groupLocale = LocaleUtil.fromLanguageId((String)siteFriendlyURL.getLanguageId());
        }
        String alternativeLayoutFriendlyURL = this._getLocalizedFriendlyURL(httpServletRequest, layout, groupLocale, locale);
        if (this._isShowAlternativeLayoutFriendlyURLMessage(companyId)) {
            SessionMessages.add((HttpServletRequest)httpServletRequest, (String)"alternativeLayoutFriendlyURL", (Object)alternativeLayoutFriendlyURL);
            PortalMessages.add((HttpServletRequest)httpServletRequest, (String)"jspPath", (Object)"/html/common/themes/layout_friendly_url_redirect.jsp");
        }
        return groupLocale;
    }

    public static class Redirect {
        private final boolean _force;
        private final String _path;
        private final boolean _permanent;

        public Redirect() {
            this("/c");
        }

        public Redirect(String path) {
            this(path, false, false);
        }

        public Redirect(String path, boolean force, boolean permanent) {
            this._path = path;
            this._force = force;
            this._permanent = permanent;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Redirect)) {
                return false;
            }
            Redirect redirect = (Redirect)object;
            return Objects.equals(this.getPath(), redirect.getPath()) && this.isForce() == redirect.isForce() && this.isPermanent() == redirect.isPermanent();
        }

        public String getPath() {
            if (Validator.isNull((String)this._path)) {
                return "/c";
            }
            return this._path;
        }

        public int hashCode() {
            int hash = HashUtil.hash((int)0, (Object)this._path);
            hash = HashUtil.hash((int)hash, (boolean)this._force);
            hash = HashUtil.hash((int)hash, (boolean)this._permanent);
            return hash;
        }

        public boolean isForce() {
            return this._force;
        }

        public boolean isPermanent() {
            return this._permanent;
        }

        public boolean isValidForward() {
            if (this.isForce()) {
                return false;
            }
            String path = this.getPath();
            return path.equals("/c") || path.startsWith("/c/");
        }
    }
}

