/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.friendly.url.model.impl;

import com.liferay.friendly.url.model.FriendlyURLEntry;
import com.liferay.friendly.url.service.FriendlyURLEntryLocalServiceUtil;

/**
 * The extended model base implementation for the FriendlyURLEntry service. Represents a row in the &quot;FriendlyURLEntry&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link FriendlyURLEntryImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see FriendlyURLEntryImpl
 * @see FriendlyURLEntry
 * @generated
 */
public abstract class FriendlyURLEntryBaseImpl
	extends FriendlyURLEntryModelImpl implements FriendlyURLEntry {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a friendly url entry model instance should use the <code>FriendlyURLEntry</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			FriendlyURLEntryLocalServiceUtil.addFriendlyURLEntry(this);
		}
		else {
			FriendlyURLEntryLocalServiceUtil.updateFriendlyURLEntry(this);
		}
	}

}