/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.friendly.url.internal.servlet;

import com.liferay.petra.encryptor.Encryptor;
import com.liferay.petra.encryptor.EncryptorException;
import com.liferay.petra.lang.HashUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.NoSuchGroupException;
import com.liferay.portal.kernel.exception.NoSuchLayoutException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutFriendlyURL;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.LayoutFriendlyURLSeparatorComposite;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.LayoutFriendlyURLLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.servlet.PortalMessages;
import com.liferay.portal.kernel.servlet.ServletContextPool;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.struts.LastPath;
import com.liferay.portal.kernel.util.FriendlyURLNormalizerUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.AsyncPortletServletRequest;
import com.liferay.site.model.SiteFriendlyURL;
import com.liferay.site.service.SiteFriendlyURLLocalService;
import java.io.IOException;
import java.security.Key;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.osgi.service.component.annotations.Reference;

public class FriendlyURLServlet
extends HttpServlet {
    @Reference
    protected GroupLocalService groupLocalService;
    @Reference
    protected LayoutFriendlyURLLocalService layoutFriendlyURLLocalService;
    @Reference
    protected LayoutLocalService layoutLocalService;
    @Reference
    protected Portal portal;
    @Reference
    protected SiteFriendlyURLLocalService siteFriendlyURLLocalService;
    @Reference
    protected UserLocalService userLocalService;
    private static final Log _log = LogFactoryUtil.getLog(FriendlyURLServlet.class);
    private String _friendlyURLPathPrefix;
    private int _pathInfoOffset;
    private boolean _private;
    private boolean _user;

    public Redirect getRedirect(HttpServletRequest httpServletRequest, String path) throws PortalException {
        long userId;
        long companyId;
        Group group;
        if (path.length() <= 1) {
            return new Redirect();
        }
        String friendlyURL = path;
        int pos = path.indexOf(47, 1);
        if (pos != -1) {
            friendlyURL = path.substring(0, pos);
        }
        if ((group = this.groupLocalService.fetchFriendlyURLGroup(companyId = PortalInstances.getCompanyId((HttpServletRequest)httpServletRequest), friendlyURL)) == null) {
            String screenName = friendlyURL.substring(1);
            User user = this.userLocalService.fetchUserByScreenName(companyId, screenName);
            if (user != null) {
                group = user.getGroup();
            } else if (_log.isWarnEnabled()) {
                _log.warn((Object)("No user exists with friendly URL " + screenName));
            }
        }
        if (group == null) {
            StringBundler sb = new StringBundler(5);
            sb.append("{companyId=");
            sb.append(companyId);
            sb.append(", friendlyURL=");
            sb.append(friendlyURL);
            sb.append("}");
            throw new NoSuchGroupException(sb.toString());
        }
        Locale locale = this.portal.getLocale(httpServletRequest, null, false);
        SiteFriendlyURL siteFriendlyURL = this.siteFriendlyURLLocalService.fetchSiteFriendlyURL(companyId, group.getGroupId(), LocaleUtil.toLanguageId((Locale)locale));
        if (siteFriendlyURL == null) {
            siteFriendlyURL = this.siteFriendlyURLLocalService.fetchSiteFriendlyURLByFriendlyURL(companyId, friendlyURL);
        }
        SiteFriendlyURL alternativeSiteFriendlyURL = null;
        if (siteFriendlyURL != null && !StringUtil.equalsIgnoreCase((String)siteFriendlyURL.getFriendlyURL(), (String)friendlyURL)) {
            alternativeSiteFriendlyURL = this.siteFriendlyURLLocalService.fetchSiteFriendlyURLByFriendlyURL(siteFriendlyURL.getCompanyId(), friendlyURL);
        }
        friendlyURL = null;
        if (pos != -1 && pos + 1 != path.length()) {
            friendlyURL = path.substring(pos);
        } else {
            httpServletRequest.setAttribute("REDIRECT_TO_DEFAULT_LAYOUT", (Object)Boolean.TRUE);
        }
        HashMap requestContext = HashMapBuilder.put((Object)"request", (Object)httpServletRequest).build();
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        if (serviceContext == null) {
            serviceContext = ServiceContextFactory.getInstance((HttpServletRequest)httpServletRequest);
            ServiceContextThreadLocal.pushServiceContext((ServiceContext)serviceContext);
        }
        Map params = httpServletRequest.getParameterMap();
        try {
            LayoutFriendlyURLSeparatorComposite layoutFriendlyURLSeparatorComposite = this.portal.getLayoutFriendlyURLSeparatorComposite(group.getGroupId(), this._private, friendlyURL, params, (Map)requestContext);
            Layout layout = layoutFriendlyURLSeparatorComposite.getLayout();
            httpServletRequest.setAttribute("LAYOUT", (Object)layout);
            String layoutFriendlyURLSeparatorCompositeFriendlyURL = layoutFriendlyURLSeparatorComposite.getFriendlyURL();
            if (Validator.isNull((String)layoutFriendlyURLSeparatorCompositeFriendlyURL)) {
                layoutFriendlyURLSeparatorCompositeFriendlyURL = layout.getFriendlyURL(locale);
            }
            if ((pos = layoutFriendlyURLSeparatorCompositeFriendlyURL.indexOf(layoutFriendlyURLSeparatorComposite.getURLSeparator())) != 0) {
                if (pos != -1) {
                    layoutFriendlyURLSeparatorCompositeFriendlyURL = layoutFriendlyURLSeparatorCompositeFriendlyURL.substring(0, pos);
                }
                String i18nLanguageId = (String)httpServletRequest.getAttribute("I18N_LANGUAGE_ID");
                boolean localeUnavailable = false;
                if (Validator.isNotNull((String)i18nLanguageId) && !LanguageUtil.isAvailableLocale((long)group.getGroupId(), (String)i18nLanguageId)) {
                    localeUnavailable = true;
                }
                if (localeUnavailable || alternativeSiteFriendlyURL != null || !this._equalsLayoutFriendlyURL(layoutFriendlyURLSeparatorCompositeFriendlyURL, layout, locale)) {
                    Locale originalLocale = this.setAlternativeLayoutFriendlyURL(httpServletRequest, layout, layoutFriendlyURLSeparatorCompositeFriendlyURL, alternativeSiteFriendlyURL);
                    if (localeUnavailable && PropsValues.LOCALE_USE_DEFAULT_IF_NOT_AVAILABLE) {
                        locale = LocaleUtil.fromLanguageId((String)group.getDefaultLanguageId());
                    }
                    String redirect = this.portal.getLocalizedFriendlyURL(httpServletRequest, layout, locale, originalLocale);
                    boolean forcePermanentRedirect = true;
                    if (Validator.isNull((String)i18nLanguageId)) {
                        forcePermanentRedirect = false;
                    }
                    return new Redirect(redirect, true, forcePermanentRedirect);
                }
            }
        }
        catch (NoSuchLayoutException noSuchLayoutException) {
            List layouts = this.layoutLocalService.getLayouts(group.getGroupId(), this._private, 0L);
            for (Layout layout : layouts) {
                if (!layout.matches(httpServletRequest, friendlyURL)) continue;
                String redirect = this.portal.getLayoutActualURL(layout, "/c");
                return new Redirect(redirect);
            }
            throw noSuchLayoutException;
        }
        String actualURL = this.portal.getActualURL(group.getGroupId(), this._private, "/c", friendlyURL, params, (Map)requestContext);
        String portalURL = this.portal.getPortalURL(httpServletRequest);
        if (actualURL.startsWith(portalURL)) {
            actualURL = StringUtil.removeSubstring((String)actualURL, (String)portalURL);
        }
        if ((userId = this.portal.getUserId(httpServletRequest)) > 0L && this._isImpersonated(httpServletRequest, userId)) {
            try {
                Company company = this.portal.getCompany(httpServletRequest);
                String encDoAsUserId = Encryptor.encrypt((Key)company.getKeyObj(), (String)String.valueOf(userId));
                actualURL = HttpUtil.setParameter((String)actualURL, (String)"doAsUserId", (String)encDoAsUserId);
            }
            catch (EncryptorException encryptorException) {
                return new Redirect(actualURL);
            }
        }
        return new Redirect(actualURL);
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        ServletContext servletContext = servletConfig.getServletContext();
        if (servletContext != ServletContextPool.get((String)this.portal.getServletContextName())) {
            return;
        }
        super.init(servletConfig);
        this._private = GetterUtil.getBoolean((String)servletConfig.getInitParameter("servlet.init.private"));
        String proxyPath = this.portal.getPathProxy();
        this._user = GetterUtil.getBoolean((String)servletConfig.getInitParameter("servlet.init.user"));
        this._friendlyURLPathPrefix = this._private ? (this._user ? this.portal.getPathFriendlyURLPrivateUser() : this.portal.getPathFriendlyURLPrivateGroup()) : this.portal.getPathFriendlyURLPublic();
        this._pathInfoOffset = this._friendlyURLPathPrefix.length() - proxyPath.length();
    }

    public void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        Redirect redirect;
        block14: {
            String pathInfo = this.getPathInfo(httpServletRequest);
            redirect = null;
            try {
                redirect = this.getRedirect(httpServletRequest, pathInfo);
                if (httpServletRequest.getAttribute("LAST_PATH") == null) {
                    httpServletRequest.setAttribute("LAST_PATH", (Object)this.getLastPath(httpServletRequest, pathInfo));
                }
            }
            catch (PortalException portalException) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)portalException, (Throwable)portalException);
                }
                if (!(portalException instanceof NoSuchGroupException) && !(portalException instanceof NoSuchLayoutException)) break block14;
                this.portal.sendError(404, (Exception)((Object)portalException), httpServletRequest, httpServletResponse);
                return;
            }
        }
        if (redirect == null) {
            redirect = new Redirect();
        }
        if (redirect.isValidForward()) {
            AsyncPortletServletRequest asyncPortletServletRequest;
            ServletContext servletContext = this.getServletContext();
            RequestDispatcher requestDispatcher = servletContext.getRequestDispatcher(redirect.getPath());
            if (httpServletRequest.isAsyncSupported() && (asyncPortletServletRequest = AsyncPortletServletRequest.getAsyncPortletServletRequest((HttpServletRequest)httpServletRequest)) != null) {
                asyncPortletServletRequest.update(servletContext.getContextPath(), redirect.getPath());
            }
            if (requestDispatcher != null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)StringBundler.concat((String[])new String[]{"Forward from ", httpServletRequest.getRequestURI(), " to ", redirect.getPath()}));
                }
                requestDispatcher.forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            }
        } else if (redirect.isPermanent()) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((String[])new String[]{"Location moved permanently from ", httpServletRequest.getRequestURI(), " to ", redirect.getPath()}));
            }
            httpServletResponse.setHeader("Location", redirect.getPath());
            httpServletResponse.setStatus(301);
        } else {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((String[])new String[]{"Redirect from ", httpServletRequest.getRequestURI(), " to ", redirect.getPath()}));
            }
            httpServletResponse.sendRedirect(redirect.getPath());
        }
    }

    protected LastPath getLastPath(HttpServletRequest httpServletRequest, String pathInfo) {
        String lifecycle = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"p_p_lifecycle");
        if (lifecycle.equals("1")) {
            return new LastPath(this._friendlyURLPathPrefix, pathInfo);
        }
        return new LastPath(this._friendlyURLPathPrefix, pathInfo, HttpUtil.parameterMapToString((Map)httpServletRequest.getParameterMap()));
    }

    protected String getPathInfo(HttpServletRequest httpServletRequest) {
        String requestURI = httpServletRequest.getRequestURI();
        int pos = requestURI.indexOf(";jsessionid=");
        if (pos == -1) {
            return requestURI.substring(this._pathInfoOffset);
        }
        return requestURI.substring(this._pathInfoOffset, pos);
    }

    protected Locale setAlternativeLayoutFriendlyURL(HttpServletRequest httpServletRequest, Layout layout, String friendlyURL, SiteFriendlyURL siteFriendlyURL) {
        Locale locale;
        List layoutFriendlyURLs = this.layoutFriendlyURLLocalService.getLayoutFriendlyURLs(layout.getPlid(), friendlyURL, 0, 1);
        if (layoutFriendlyURLs.isEmpty()) {
            return null;
        }
        LayoutFriendlyURL layoutFriendlyURL = (LayoutFriendlyURL)layoutFriendlyURLs.get(0);
        Locale groupLocale = locale = LocaleUtil.fromLanguageId((String)layoutFriendlyURL.getLanguageId());
        if (siteFriendlyURL != null) {
            groupLocale = LocaleUtil.fromLanguageId((String)siteFriendlyURL.getLanguageId());
        }
        String alternativeLayoutFriendlyURL = this.portal.getLocalizedFriendlyURL(httpServletRequest, layout, groupLocale, locale);
        SessionMessages.add((HttpServletRequest)httpServletRequest, (String)"alternativeLayoutFriendlyURL", (Object)alternativeLayoutFriendlyURL);
        PortalMessages.add((HttpServletRequest)httpServletRequest, (String)"jspPath", (Object)"/html/common/themes/layout_friendly_url_redirect.jsp");
        if (!locale.equals(groupLocale)) {
            locale = groupLocale;
        }
        return locale;
    }

    private boolean _equalsLayoutFriendlyURL(String layoutFriendlyURLSeparatorCompositeFriendlyURL, Layout layout, Locale locale) {
        String layoutFriendlyURL = layout.getFriendlyURL(locale);
        return StringUtil.equalsIgnoreCase((String)layoutFriendlyURLSeparatorCompositeFriendlyURL, (String)layoutFriendlyURL) || StringUtil.equalsIgnoreCase((String)FriendlyURLNormalizerUtil.normalizeWithEncoding((String)layoutFriendlyURLSeparatorCompositeFriendlyURL), (String)layoutFriendlyURL);
    }

    private boolean _isImpersonated(HttpServletRequest httpServletRequest, long userId) {
        HttpSession session = httpServletRequest.getSession();
        Long realUserId = (Long)session.getAttribute("USER_ID");
        return realUserId != null && userId != realUserId;
    }

    public static class Redirect {
        private final boolean _force;
        private final String _path;
        private final boolean _permanent;

        public Redirect() {
            this("/c");
        }

        public Redirect(String path) {
            this(path, false, false);
        }

        public Redirect(String path, boolean force, boolean permanent) {
            this._path = path;
            this._force = force;
            this._permanent = permanent;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Redirect)) {
                return false;
            }
            Redirect redirect = (Redirect)obj;
            return Objects.equals(this.getPath(), redirect.getPath()) && this.isForce() == redirect.isForce() && this.isPermanent() == redirect.isPermanent();
        }

        public String getPath() {
            if (Validator.isNull((String)this._path)) {
                return "/c";
            }
            return this._path;
        }

        public int hashCode() {
            int hash = HashUtil.hash((int)0, (Object)this._path);
            hash = HashUtil.hash((int)hash, (boolean)this._force);
            hash = HashUtil.hash((int)hash, (boolean)this._permanent);
            return hash;
        }

        public boolean isForce() {
            return this._force;
        }

        public boolean isPermanent() {
            return this._permanent;
        }

        public boolean isValidForward() {
            if (this.isForce()) {
                return false;
            }
            String path = this.getPath();
            return path.equals("/c") || path.startsWith("/c/");
        }
    }
}

