/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.entry.processor.resources.util;

import com.liferay.document.library.util.DLURLHelperUtil;
import com.liferay.fragment.model.FragmentCollection;
import com.liferay.fragment.model.FragmentEntry;
import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.service.FragmentCollectionLocalServiceUtil;
import com.liferay.fragment.service.FragmentEntryLocalServiceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ResourcesFragmentEntryProcessorUtil {
    private static final Pattern _pattern = Pattern.compile("\\[resources:(.+?)\\]");

    public static String processResources(FragmentEntryLink fragmentEntryLink, String code) throws PortalException {
        FragmentEntry fragmentEntry = FragmentEntryLocalServiceUtil.fetchFragmentEntryByExternalReferenceCode((String)fragmentEntryLink.getFragmentEntryERC(), (long)fragmentEntryLink.getFragmentEntryGroupId());
        if (fragmentEntry == null) {
            return code;
        }
        FragmentCollection fragmentCollection = FragmentCollectionLocalServiceUtil.fetchFragmentCollection((long)fragmentEntry.getFragmentCollectionId());
        Matcher matcher = _pattern.matcher(code);
        while (matcher.find()) {
            if (fragmentEntry.getGroupId() <= 0L) continue;
            String fileName = matcher.group(1);
            FileEntry fileEntry = fragmentCollection.getResource(fileName);
            if (fileEntry == null && Validator.isNotNull((String)FileUtil.getExtension((String)fileName))) {
                fileEntry = fragmentCollection.getResource(FileUtil.stripExtension((String)fileName));
            }
            String fileEntryURL = "";
            if (fileEntry != null) {
                fileEntryURL = DLURLHelperUtil.getDownloadURL((FileEntry)fileEntry, (FileVersion)fileEntry.getFileVersion(), null, (String)"", (boolean)false, (boolean)false);
            }
            code = StringUtil.replace((String)code, (String)matcher.group(), (String)fileEntryURL);
        }
        return code;
    }
}

