/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.entry.processor.portlet.internal.model.listener;

import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.processor.PortletRegistry;
import com.liferay.fragment.service.FragmentEntryLinkLocalService;
import com.liferay.layout.service.LayoutClassedModelUsageLocalService;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.service.PortletLocalService;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Portal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ModelListener.class})
public class FragmentEntryLinkModelListener
extends BaseModelListener<FragmentEntryLink> {
    private static final Log _log = LogFactoryUtil.getLog(FragmentEntryLinkModelListener.class);
    @Reference
    private FragmentEntryLinkLocalService _fragmentEntryLinkLocalService;
    @Reference
    private LayoutClassedModelUsageLocalService _layoutClassedModelUsageLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private PortletLocalService _portletLocalService;
    @Reference
    private PortletRegistry _portletRegistry;

    public void onAfterRemove(FragmentEntryLink fragmentEntryLink) throws ModelListenerException {
        List portletIds = this._portletRegistry.getFragmentEntryLinkPortletIds(fragmentEntryLink);
        List<String> usedPortletNames = this._getUsedNoninstanceablePortletNames(fragmentEntryLink, portletIds);
        for (String portletId : portletIds) {
            if (usedPortletNames.contains(PortletIdCodec.decodePortletName((String)portletId))) continue;
            try {
                this._portletLocalService.deletePortlet(fragmentEntryLink.getCompanyId(), portletId, fragmentEntryLink.getPlid());
                this._layoutClassedModelUsageLocalService.deleteLayoutClassedModelUsages(portletId, this._portal.getClassNameId(Portlet.class), fragmentEntryLink.getPlid());
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Throwable)exception);
            }
        }
    }

    private List<String> _getUsedNoninstanceablePortletNames(FragmentEntryLink fragmentEntryLink, List<String> portletIds) throws ModelListenerException {
        List portletNames = TransformUtil.transform(portletIds, portletId -> {
            Portlet portlet = this._portletLocalService.getPortletById(fragmentEntryLink.getCompanyId(), portletId);
            if (portlet.isInstanceable()) {
                return null;
            }
            return PortletIdCodec.decodePortletName((String)portletId);
        });
        if (ListUtil.isEmpty((List)portletNames)) {
            return Collections.emptyList();
        }
        ArrayList<String> usedPortletNames = new ArrayList<String>();
        for (FragmentEntryLink curFragmentEntryLink : this._fragmentEntryLinkLocalService.getFragmentEntryLinksBySegmentsExperienceId(fragmentEntryLink.getGroupId(), fragmentEntryLink.getSegmentsExperienceId(), fragmentEntryLink.getPlid(), false)) {
            if (curFragmentEntryLink.getFragmentEntryLinkId() == fragmentEntryLink.getFragmentEntryLinkId()) continue;
            for (String portletId2 : this._portletRegistry.getFragmentEntryLinkPortletIds(null, curFragmentEntryLink)) {
                String portletName = PortletIdCodec.decodePortletName((String)portletId2);
                if (!portletNames.contains(portletName)) continue;
                usedPortletNames.add(portletName);
            }
        }
        return usedPortletNames;
    }
}

