/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.entry.processor.freemarker;

import com.liferay.fragment.contributor.FragmentCollectionContributorTracker;
import com.liferay.fragment.entry.processor.freemarker.internal.configuration.FreeMarkerFragmentEntryProcessorConfiguration;
import com.liferay.fragment.entry.processor.freemarker.internal.templateparser.InputTemplateNode;
import com.liferay.fragment.exception.FragmentEntryContentException;
import com.liferay.fragment.model.FragmentEntry;
import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.processor.FragmentEntryProcessor;
import com.liferay.fragment.processor.FragmentEntryProcessorContext;
import com.liferay.fragment.renderer.FragmentRenderer;
import com.liferay.fragment.renderer.FragmentRendererTracker;
import com.liferay.fragment.service.FragmentEntryLocalService;
import com.liferay.fragment.util.configuration.FragmentConfigurationField;
import com.liferay.fragment.util.configuration.FragmentEntryConfigurationParser;
import com.liferay.info.exception.InfoFormValidationException;
import com.liferay.info.field.InfoField;
import com.liferay.info.field.type.InfoFieldType;
import com.liferay.info.field.type.NumberInfoFieldType;
import com.liferay.info.field.type.SelectInfoFieldType;
import com.liferay.info.form.InfoForm;
import com.liferay.petra.io.DummyWriter;
import com.liferay.petra.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.servlet.DummyHttpServletResponse;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.template.StringTemplateResource;
import com.liferay.portal.kernel.template.Template;
import com.liferay.portal.kernel.template.TemplateException;
import com.liferay.portal.kernel.template.TemplateManagerUtil;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"fragment.entry.processor.priority:Integer=1"}, service={FragmentEntryProcessor.class})
public class FreeMarkerFragmentEntryProcessor
implements FragmentEntryProcessor {
    private static final Log _log = LogFactoryUtil.getLog(FreeMarkerFragmentEntryProcessor.class);
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private FragmentCollectionContributorTracker _fragmentCollectionContributorTracker;
    @Reference
    private FragmentEntryConfigurationParser _fragmentEntryConfigurationParser;
    @Reference
    private FragmentEntryLocalService _fragmentEntryLocalService;
    @Reference
    private FragmentRendererTracker _fragmentRendererTracker;
    @Reference
    private Portal _portal;

    public JSONObject getDefaultEditableValuesJSONObject(String html, String configuration) {
        return this._fragmentEntryConfigurationParser.getConfigurationDefaultValuesJSONObject(configuration);
    }

    public String processFragmentEntryLinkHTML(FragmentEntryLink fragmentEntryLink, String html, FragmentEntryProcessorContext fragmentEntryProcessorContext) throws PortalException {
        if (Validator.isNull((String)html)) {
            return html;
        }
        FreeMarkerFragmentEntryProcessorConfiguration freeMarkerFragmentEntryProcessorConfiguration = (FreeMarkerFragmentEntryProcessorConfiguration)this._configurationProvider.getCompanyConfiguration(FreeMarkerFragmentEntryProcessorConfiguration.class, fragmentEntryLink.getCompanyId());
        if (!freeMarkerFragmentEntryProcessorConfiguration.enable() && Validator.isNull((String)fragmentEntryLink.getRendererKey()) && !fragmentEntryLink.isSystem()) {
            return html;
        }
        if (fragmentEntryProcessorContext.getHttpServletRequest() == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"HTTP servlet request is not set in the fragment entry processor context");
            }
            return html;
        }
        if (fragmentEntryProcessorContext.getHttpServletResponse() == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"HTTP servlet response is not set in the fragment entry processor context");
            }
            return html;
        }
        UnsyncStringWriter unsyncStringWriter = new UnsyncStringWriter();
        Template template = TemplateManagerUtil.getTemplate((String)"ftl", (TemplateResource)new StringTemplateResource("template_id", "[#ftl] " + html), (boolean)true);
        template.put((Object)"writer", (Object)unsyncStringWriter);
        JSONObject configurationValuesJSONObject = this._fragmentEntryConfigurationParser.getConfigurationJSONObject(fragmentEntryLink.getConfiguration(), fragmentEntryLink.getEditableValues(), fragmentEntryProcessorContext.getLocale());
        template.putAll((Map)HashMapBuilder.put((Object)"configuration", (Object)configurationValuesJSONObject).put((Object)"fragmentElementId", (Object)fragmentEntryProcessorContext.getFragmentElementId()).put((Object)"fragmentEntryLinkNamespace", (Object)fragmentEntryLink.getNamespace()).put((Object)"input", (Object)this._toInputTemplateNode(fragmentEntryLink, fragmentEntryProcessorContext.getHttpServletRequest(), fragmentEntryProcessorContext.getInfoFormOptional(), fragmentEntryProcessorContext.getLocale())).put((Object)"layoutMode", (Object)this._getLayoutMode(fragmentEntryProcessorContext.getHttpServletRequest())).putAll(this._fragmentEntryConfigurationParser.getContextObjects(configurationValuesJSONObject, fragmentEntryLink.getConfiguration(), fragmentEntryProcessorContext.getSegmentsEntryIds())).build());
        template.prepareTaglib(fragmentEntryProcessorContext.getHttpServletRequest(), fragmentEntryProcessorContext.getHttpServletResponse());
        template.prepare(fragmentEntryProcessorContext.getHttpServletRequest());
        try {
            template.processTemplate((Writer)unsyncStringWriter);
        }
        catch (TemplateException templateException) {
            throw new FragmentEntryContentException(this._getMessage(templateException), (Throwable)templateException);
        }
        return unsyncStringWriter.toString();
    }

    public void validateFragmentEntryHTML(String html, String configuration) throws PortalException {
        FreeMarkerFragmentEntryProcessorConfiguration freeMarkerFragmentEntryProcessorConfiguration = (FreeMarkerFragmentEntryProcessorConfiguration)this._configurationProvider.getCompanyConfiguration(FreeMarkerFragmentEntryProcessorConfiguration.class, CompanyThreadLocal.getCompanyId().longValue());
        if (!freeMarkerFragmentEntryProcessorConfiguration.enable() || !this._isFreemarkerTemplate(html)) {
            return;
        }
        Template template = TemplateManagerUtil.getTemplate((String)"ftl", (TemplateResource)new StringTemplateResource("template_id", "[#ftl] " + html), (boolean)true);
        try {
            HttpServletRequest httpServletRequest = null;
            HttpServletResponse httpServletResponse = null;
            ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
            if (serviceContext != null) {
                httpServletRequest = serviceContext.getRequest();
                httpServletResponse = serviceContext.getResponse();
            }
            if (httpServletResponse == null) {
                httpServletResponse = new DummyHttpServletResponse();
            }
            if (httpServletRequest != null && httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY") != null) {
                JSONObject configurationDefaultValuesJSONObject = this._fragmentEntryConfigurationParser.getConfigurationDefaultValuesJSONObject(configuration);
                template.putAll((Map)HashMapBuilder.put((Object)"configuration", (Object)configurationDefaultValuesJSONObject).put((Object)"fragmentElementId", (Object)"").put((Object)"fragmentEntryLinkNamespace", (Object)"").put((Object)"input", (Object)new InputTemplateNode("", "", "", "", "name", false, false, false, "type", "value")).put((Object)"layoutMode", (Object)"view").putAll(this._fragmentEntryConfigurationParser.getContextObjects(configurationDefaultValuesJSONObject, configuration, new long[0])).build());
                template.prepareTaglib(httpServletRequest, httpServletResponse);
                template.prepare(httpServletRequest);
                template.processTemplate((Writer)new DummyWriter());
            }
        }
        catch (TemplateException templateException) {
            throw new FragmentEntryContentException(this._getMessage(templateException), (Throwable)templateException);
        }
    }

    private String _getFragmentEntryName(FragmentEntryLink fragmentEntryLink, Locale locale) {
        FragmentEntry fragmentEntry = this._fragmentEntryLocalService.fetchFragmentEntry(fragmentEntryLink.getFragmentEntryId());
        if (fragmentEntry != null) {
            return fragmentEntry.getName();
        }
        String rendererKey = fragmentEntryLink.getRendererKey();
        if (Validator.isNull((String)rendererKey)) {
            return "";
        }
        Map fragmentEntries = this._fragmentCollectionContributorTracker.getFragmentEntries(locale);
        FragmentEntry contributedFragmentEntry = (FragmentEntry)fragmentEntries.get(rendererKey);
        if (contributedFragmentEntry != null) {
            return contributedFragmentEntry.getName();
        }
        FragmentRenderer fragmentRenderer = this._fragmentRendererTracker.getFragmentRenderer(fragmentEntryLink.getRendererKey());
        if (fragmentRenderer != null) {
            return fragmentRenderer.getLabel(locale);
        }
        return "";
    }

    private String _getLayoutMode(HttpServletRequest httpServletRequest) {
        return ParamUtil.getString((HttpServletRequest)this._portal.getOriginalServletRequest(httpServletRequest), (String)"p_l_mode", (String)"view");
    }

    private String _getMessage(TemplateException templateException) {
        ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", this.getClass());
        String message = LanguageUtil.get((ResourceBundle)resourceBundle, (String)"freemarker-syntax-is-invalid");
        Throwable causeThrowable = templateException.getCause();
        String causeThrowableMessage = causeThrowable.getLocalizedMessage();
        if (Validator.isNotNull((String)causeThrowableMessage)) {
            message = message + "\n\n" + causeThrowableMessage;
        }
        return message;
    }

    private boolean _isFreemarkerTemplate(String html) {
        return html.contains("${") || html.contains("<#") || html.contains("<@");
    }

    private InputTemplateNode _toInputTemplateNode(FragmentEntryLink fragmentEntryLink, HttpServletRequest httpServletRequest, Optional<InfoForm> infoFormOptional, Locale locale) {
        String dataType = "";
        String errorMessage = "";
        InfoField infoField = null;
        InfoForm infoForm = infoFormOptional.orElse(null);
        if (infoForm != null) {
            String fieldName = GetterUtil.getString((Object)this._fragmentEntryConfigurationParser.getFieldValue(fragmentEntryLink.getEditableValues(), new FragmentConfigurationField("inputFieldId", "string", "", false, "text"), locale));
            infoField = infoForm.getInfoField(fieldName);
        }
        if (infoField != null && SessionErrors.contains((HttpServletRequest)httpServletRequest, (String)infoField.getUniqueId())) {
            InfoFormValidationException infoFormValidationException = (InfoFormValidationException)SessionErrors.get((HttpServletRequest)httpServletRequest, (String)infoField.getUniqueId());
            errorMessage = infoFormValidationException.getLocalizedMessage(locale);
        }
        String inputHelpText = GetterUtil.getString((Object)this._fragmentEntryConfigurationParser.getFieldValue(fragmentEntryLink.getEditableValues(), new FragmentConfigurationField("inputHelpText", "string", LanguageUtil.get((Locale)locale, (String)"add-your-help-text-here"), true, "text"), locale));
        String inputLabel = GetterUtil.getString((Object)this._fragmentEntryConfigurationParser.getFieldValue(fragmentEntryLink.getEditableValues(), new FragmentConfigurationField("inputLabel", "string", this._getFragmentEntryName(fragmentEntryLink, locale), true, "text"), locale));
        String name = "name";
        if (infoField != null) {
            name = infoField.getName();
        }
        boolean required = false;
        if (infoField != null && infoField.isRequired() || GetterUtil.getBoolean((Object)this._fragmentEntryConfigurationParser.getFieldValue(fragmentEntryLink.getEditableValues(), new FragmentConfigurationField("inputRequired", "boolean", "false", false, "checkbox"), locale))) {
            required = true;
        }
        boolean inputShowHelpText = GetterUtil.getBoolean((Object)this._fragmentEntryConfigurationParser.getFieldValue(fragmentEntryLink.getEditableValues(), new FragmentConfigurationField("inputShowHelpText", "boolean", "false", false, "checkbox"), locale));
        boolean inputShowLabel = GetterUtil.getBoolean((Object)this._fragmentEntryConfigurationParser.getFieldValue(fragmentEntryLink.getEditableValues(), new FragmentConfigurationField("inputShowLabel", "boolean", "true", false, "checkbox"), locale));
        String type = "type";
        if (infoField != null) {
            InfoFieldType infoFieldType = infoField.getInfoFieldType();
            type = infoFieldType.getName();
            if (infoFieldType instanceof NumberInfoFieldType) {
                dataType = "integer";
                Optional decimalOptional = infoField.getAttributeOptional(NumberInfoFieldType.DECIMAL);
                if (decimalOptional.orElse(false).booleanValue()) {
                    dataType = "decimal";
                }
            }
        }
        InputTemplateNode inputTemplateNode = new InputTemplateNode(dataType, errorMessage, inputHelpText, inputLabel, name, required, inputShowHelpText, inputShowLabel, type, "value");
        if (infoField != null && infoField.getInfoFieldType() instanceof SelectInfoFieldType) {
            Optional optionsOptional = infoField.getAttributeOptional(SelectInfoFieldType.OPTIONS);
            List options = optionsOptional.orElse(new ArrayList());
            for (SelectInfoFieldType.Option option : options) {
                inputTemplateNode.addOption(option.getLabel(locale), option.getValue());
            }
        }
        return inputTemplateNode;
    }
}

