/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.entry.processor.freemarker.internal.templateparser;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

public class InputTemplateNode
extends LinkedHashMap<String, Object> {
    private final String _helpText;
    private final String _label;
    private final String _name;
    private final List<Option> _options = new ArrayList<Option>();
    private final boolean _required;
    private final boolean _showHelpText;
    private final boolean _showLabel;
    private final String _type;
    private final String _value;

    public InputTemplateNode(String helpText, String label, String name, boolean required, boolean showHelpText, boolean showLabel, String type, String value) {
        this._helpText = helpText;
        this._label = label;
        this._name = name;
        this._required = required;
        this._showHelpText = showHelpText;
        this._showLabel = showLabel;
        this._type = type;
        this._value = value;
        this.put("helpText", helpText);
        this.put("label", label);
        this.put("name", name);
        this.put("required", required);
        this.put("showHelpText", showHelpText);
        this.put("showLabel", showLabel);
        this.put("type", type);
        this.put("value", value);
        this.put("options", this._options);
    }

    public void addOption(String label, String value) {
        this._options.add(new Option(label, value));
    }

    public String getHelpText() {
        return this._helpText;
    }

    public String getInputLabel() {
        return this._label;
    }

    public String getInputName() {
        return this._name;
    }

    public String getInputValue() {
        return this._value;
    }

    public List<Option> getOptions() {
        return this._options;
    }

    public String getType() {
        return this._type;
    }

    public boolean isRequired() {
        return this._required;
    }

    public boolean isShowHelpText() {
        return this._showHelpText;
    }

    public boolean isShowLabel() {
        return this._showLabel;
    }

    public static class Option {
        private final String _label;
        private final String _value;

        public Option(String label, String value) {
            this._label = label;
            this._value = value;
        }

        public String getLabel() {
            return this._label;
        }

        public String getValue() {
            return this._value;
        }
    }
}

