/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.entry.processor.editable.internal.parser;

import com.liferay.fragment.entry.processor.editable.internal.parser.BaseEditableElementParser;
import com.liferay.fragment.entry.processor.editable.parser.EditableElementParser;
import com.liferay.fragment.exception.FragmentEntryContentException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Objects;
import java.util.ResourceBundle;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"type=text"}, service={EditableElementParser.class})
public class TextEditableElementParser
extends BaseEditableElementParser {
    private static final String[] _TAGS_BLACKLIST = new String[]{"img", "a"};
    @Reference
    private Language _language;

    public String getValue(Element element) {
        String html = element.html();
        if (Validator.isNull((String)html.trim())) {
            ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", this.getClass());
            return this._language.get(resourceBundle, "example-text");
        }
        return html;
    }

    public void replace(Element element, String value) {
        this.replace(element, value, null);
    }

    public void replace(Element element, String value, JSONObject configJSONObject) {
        String textStyleValue;
        String textColorValue;
        if (configJSONObject == null) {
            element.html(value);
            return;
        }
        String textAlignmentValue = configJSONObject.getString("textAlignment");
        if (Validator.isNotNull((String)textAlignmentValue)) {
            element.addClass("text-" + textAlignmentValue);
        }
        if (Validator.isNotNull((String)(textColorValue = configJSONObject.getString("textColor")))) {
            element.addClass("text-" + textColorValue);
        }
        if (Validator.isNotNull((String)(textStyleValue = configJSONObject.getString("textStyle")))) {
            element.addClass(textStyleValue);
        }
        if (value.indexOf(60) == -1) {
            element.empty();
            element.appendChild((Node)new TextNode(value));
        } else {
            element.html(value);
        }
    }

    @Override
    public void validate(Element element) throws FragmentEntryContentException {
        for (String tag : _TAGS_BLACKLIST) {
            if (!Objects.equals(element.tagName(), tag)) continue;
            ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", this.getClass());
            throw new FragmentEntryContentException(this._language.format(resourceBundle, "an-editable-of-type-x-cannot-be-used-in-a-tag-of-type-x", new Object[]{this.getEditableElementType(), tag}, false));
        }
        super.validate(element);
    }

    protected String getEditableElementType() {
        return "text";
    }
}

