/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.entry.processor.editable.internal.mapper;

import com.liferay.fragment.entry.processor.editable.mapper.EditableElementMapper;
import com.liferay.fragment.entry.processor.helper.FragmentEntryProcessorHelper;
import com.liferay.fragment.processor.FragmentEntryProcessorContext;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.select.Elements;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"type=link"}, service={EditableElementMapper.class})
public class LinkEditableElementMapper
implements EditableElementMapper {
    @Reference
    private FragmentEntryProcessorHelper _fragmentEntryProcessorHelper;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private Portal _portal;

    public void map(Element element, JSONObject configJSONObject, FragmentEntryProcessorContext fragmentEntryProcessorContext) throws PortalException {
        String target;
        boolean nofollow = false;
        Object href = null;
        JSONObject hrefJSONObject = configJSONObject.getJSONObject("href");
        if (this._fragmentEntryProcessorHelper.isMapped(configJSONObject) || this._fragmentEntryProcessorHelper.isMappedCollection(configJSONObject) || this._fragmentEntryProcessorHelper.isMappedDisplayPage(configJSONObject)) {
            Object fieldValue = this._fragmentEntryProcessorHelper.getFieldValue(configJSONObject, new HashMap(), fragmentEntryProcessorContext);
            if (fieldValue instanceof JSONObject) {
                JSONObject jsonObject = (JSONObject)fieldValue;
                nofollow = jsonObject.getBoolean("nofollow");
                href = jsonObject.getString("url");
            } else {
                href = GetterUtil.getString((Object)fieldValue);
            }
        } else if (this._isMappedLayout(configJSONObject)) {
            href = GetterUtil.getString((Object)this._getMappedLayoutValue(configJSONObject, fragmentEntryProcessorContext));
        } else if (hrefJSONObject != null) {
            String languageId = LocaleUtil.toLanguageId((Locale)fragmentEntryProcessorContext.getLocale());
            if (!hrefJSONObject.has(languageId)) {
                languageId = LocaleUtil.toLanguageId((Locale)LocaleUtil.getSiteDefault());
            }
            href = hrefJSONObject.getString(languageId);
        } else {
            href = configJSONObject.getString("href");
        }
        if (Validator.isNull((String)href)) {
            return;
        }
        String prefix = configJSONObject.getString("prefix");
        if (Validator.isNotNull((String)prefix)) {
            href = prefix + (String)href;
        }
        Element linkElement = new Element("a");
        Elements elements = element.children();
        Element firstChildElement = elements.first();
        boolean processEditableTag = false;
        if (StringUtil.equalsIgnoreCase((String)element.tagName(), (String)"a")) {
            linkElement = element;
        } else if (StringUtil.equalsIgnoreCase((String)element.tagName(), (String)"lfr-editable")) {
            processEditableTag = true;
        }
        boolean replaceLink = false;
        if (firstChildElement != null && processEditableTag && StringUtil.equalsIgnoreCase((String)firstChildElement.tagName(), (String)"a")) {
            linkElement = firstChildElement;
            replaceLink = true;
        }
        if (Validator.isNotNull((String)(target = configJSONObject.getString("target")))) {
            if (StringUtil.equalsIgnoreCase((String)target, (String)"_parent") || StringUtil.equalsIgnoreCase((String)target, (String)"_top")) {
                target = "_self";
            }
            linkElement.attr("target", target);
        }
        if (Validator.isNull((String)href)) {
            return;
        }
        boolean empty = false;
        if (element.childNodeSize() == 0) {
            empty = true;
        }
        linkElement.attr("href", (String)href);
        if (nofollow) {
            linkElement.attr("rel", "nofollow");
        }
        this._replaceLinkContent(element, empty, firstChildElement, linkElement, replaceLink);
        if ((linkElement != element || processEditableTag) && !empty && linkElement.parent() != element) {
            element.empty();
            element.appendChild((Node)linkElement);
        } else if (linkElement != element && empty) {
            Element parentElement = element.parent();
            if (element.parent() == parentElement) {
                element.replaceWith((Node)linkElement);
            } else {
                parentElement.appendChild((Node)linkElement);
            }
        }
    }

    private Object _getMappedLayoutValue(JSONObject jsonObject, FragmentEntryProcessorContext fragmentEntryProcessorContext) throws PortalException {
        if (!this._isMappedLayout(jsonObject)) {
            return "";
        }
        HttpServletRequest httpServletRequest = fragmentEntryProcessorContext.getHttpServletRequest();
        if (httpServletRequest == null) {
            return "";
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (themeDisplay == null) {
            return "";
        }
        JSONObject layoutJSONObject = jsonObject.getJSONObject("layout");
        long groupId = layoutJSONObject.getLong("groupId");
        Group group = this._groupLocalService.fetchGroup(groupId);
        if (group == null) {
            return "#";
        }
        Layout layout = this._layoutLocalService.fetchLayout(groupId, layoutJSONObject.getBoolean("privateLayout"), layoutJSONObject.getLong("layoutId"));
        if (layout == null) {
            return "#";
        }
        return this._portal.getLayoutRelativeURL(layout, themeDisplay);
    }

    private boolean _isMappedLayout(JSONObject jsonObject) {
        return jsonObject.has("layout");
    }

    private void _replaceLinkContent(Element element, boolean empty, Element firstChildElement, Element linkElement, boolean replaceLink) {
        if (replaceLink) {
            if (linkElement == firstChildElement) {
                return;
            }
            linkElement.empty();
            if (firstChildElement.childNodeSize() == 0) {
                linkElement.appendChild((Node)firstChildElement);
            } else {
                linkElement.appendChildren((Collection)firstChildElement.childNodes());
            }
        } else {
            if (linkElement == element) {
                return;
            }
            linkElement.empty();
            if (empty) {
                linkElement.appendChild((Node)element);
            } else {
                linkElement.appendChildren((Collection)element.childNodes());
            }
        }
    }
}

