/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.entry.processor.editable;

import com.liferay.fragment.entry.processor.editable.parser.EditableElementParser;
import com.liferay.fragment.entry.processor.util.EditableFragmentEntryProcessorUtil;
import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.processor.FragmentEntryProcessor;
import com.liferay.fragment.processor.FragmentEntryProcessorContext;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(property={"fragment.entry.processor.priority:Integer=2"}, service={FragmentEntryProcessor.class})
public class EditableFragmentEntryProcessor
implements FragmentEntryProcessor {
    private ServiceTrackerMap<String, EditableElementParser> _editableElementParserServiceTrackerMap;
    @Reference
    private JSONFactory _jsonFactory;

    public JSONArray getDataAttributesJSONArray() {
        JSONArray jsonArray = JSONUtil.put((Object)"lfr-editable-id");
        for (String key : this._editableElementParserServiceTrackerMap.keySet()) {
            jsonArray.put("lfr-editable-type:" + key);
        }
        return jsonArray;
    }

    public JSONObject getDefaultEditableValuesJSONObject(String html, String configuration) {
        return this._getDefaultEditableValuesJSONObject(html);
    }

    public String processFragmentEntryLinkHTML(FragmentEntryLink fragmentEntryLink, String html, FragmentEntryProcessorContext fragmentEntryProcessorContext) throws PortalException {
        return html;
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._editableElementParserServiceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, EditableElementParser.class, (String)"type");
    }

    @Deactivate
    protected void deactivate() {
        this._editableElementParserServiceTrackerMap.close();
    }

    private JSONObject _getDefaultEditableValuesJSONObject(String html) {
        JSONObject defaultEditableValuesJSONObject = this._jsonFactory.createJSONObject();
        Document document = this._getDocument(html);
        for (Element element : document.select("lfr-editable,*[data-lfr-editable-id]")) {
            EditableElementParser editableElementParser = this._getEditableElementParser(element);
            if (editableElementParser == null) continue;
            JSONObject defaultValueJSONObject = JSONUtil.put((String)"config", (Object)editableElementParser.getAttributes(element)).put("defaultValue", editableElementParser.getValue(element));
            defaultEditableValuesJSONObject.put(EditableFragmentEntryProcessorUtil.getElementId((Element)element), defaultValueJSONObject);
        }
        return defaultEditableValuesJSONObject;
    }

    private Document _getDocument(String html) {
        Document document = Jsoup.parseBodyFragment((String)html);
        Document.OutputSettings outputSettings = new Document.OutputSettings();
        outputSettings.prettyPrint(false);
        document.outputSettings(outputSettings);
        return document;
    }

    private EditableElementParser _getEditableElementParser(Element element) {
        String type = EditableFragmentEntryProcessorUtil.getElementType((Element)element);
        return (EditableElementParser)this._editableElementParserServiceTrackerMap.getService((Object)type);
    }
}

