/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.entry.processor.editable.internal.parser;

import com.liferay.fragment.entry.processor.editable.parser.EditableElementParser;
import com.liferay.fragment.entry.processor.editable.parser.util.EditableElementParserUtil;
import com.liferay.fragment.exception.FragmentEntryContentException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"type=link"}, service={EditableElementParser.class})
public class LinkEditableElementParser
implements EditableElementParser {
    @Reference
    private Language _language;

    @Override
    public JSONObject getAttributes(Element element) {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        Elements elements = element.getElementsByTag("a");
        if (ListUtil.isEmpty((List)elements)) {
            return jsonObject;
        }
        Element replaceableElement = (Element)elements.get(0);
        String href = replaceableElement.attr("href");
        if (Validator.isNotNull((String)href)) {
            jsonObject.put("href", href);
        }
        return jsonObject;
    }

    @Override
    public String getValue(Element element) {
        Elements elements = element.getElementsByTag("a");
        if (ListUtil.isEmpty((List)elements)) {
            return "";
        }
        Element replaceableElement = (Element)elements.get(0);
        String html = replaceableElement.html();
        if (Validator.isNull((String)html.trim())) {
            ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", this.getClass());
            return this._language.get(resourceBundle, "example-link");
        }
        return html;
    }

    @Override
    public void replace(Element element, String value) {
        this.replace(element, value, null);
    }

    @Override
    public void replace(Element element, String value, JSONObject configJSONObject) {
        Elements elements = element.getElementsByTag("a");
        if (ListUtil.isEmpty((List)elements)) {
            return;
        }
        Element replaceableElement = (Element)elements.get(0);
        Element bodyElement = EditableElementParserUtil.getDocumentBody(value);
        if (configJSONObject == null) {
            replaceableElement.html(bodyElement.html());
            return;
        }
        EditableElementParserUtil.addAttribute(replaceableElement, configJSONObject, "href", "href");
        String target = configJSONObject.getString("target");
        if (StringUtil.equalsIgnoreCase((String)target, (String)"_parent") || StringUtil.equalsIgnoreCase((String)target, (String)"_top")) {
            configJSONObject.put("target", "_self");
        }
        EditableElementParserUtil.addAttribute(replaceableElement, configJSONObject, "target", "target");
        String buttonType = configJSONObject.getString("buttonType");
        if (!buttonType.isEmpty()) {
            for (String className : replaceableElement.classNames()) {
                if (!className.startsWith("btn-") && !Objects.equals(className, "btn")) continue;
                replaceableElement.removeClass(className);
            }
            if (Objects.equals(buttonType, "link")) {
                replaceableElement.addClass("link");
            } else {
                EditableElementParserUtil.addClass(replaceableElement, configJSONObject, "btn btn-", "buttonType");
            }
        }
        replaceableElement.html(bodyElement.html());
    }

    @Override
    public void validate(Element element) throws FragmentEntryContentException {
        Elements elements = element.getElementsByTag("a");
        if (elements.size() != 1) {
            ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", this.getClass());
            throw new FragmentEntryContentException(this._language.format(resourceBundle, "each-editable-image-element-must-contain-an-a-tag", new Object[]{"<em>", "</em>"}, false));
        }
    }
}

