/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.entry.processor.editable.parser.impl;

import com.liferay.fragment.entry.processor.editable.EditableFragmentEntryProcessor;
import com.liferay.fragment.entry.processor.editable.parser.EditableElementParser;
import com.liferay.fragment.exception.FragmentEntryContentException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.ResourceBundle;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, property={"type=image"}, service={EditableElementParser.class})
public class ImageEditableElementParser
implements EditableElementParser {
    private static final String _TMPL_IMAGE_FIELD_TEMPLATE = StringUtil.read(EditableFragmentEntryProcessor.class, (String)"/META-INF/resources/fragment/entry/processor/editable/image_field_template.tmpl");

    @Override
    public String getFieldTemplate() {
        return _TMPL_IMAGE_FIELD_TEMPLATE;
    }

    @Override
    public String getValue(Element element) {
        Elements elements = element.getElementsByTag("img");
        Element replaceableElement = (Element)elements.get(0);
        return replaceableElement.attr("src");
    }

    @Override
    public void replace(Element element, String value) {
        Elements elements = element.getElementsByTag("img");
        Element replaceableElement = (Element)elements.get(0);
        replaceableElement.attr("src", value);
    }

    @Override
    public void validate(Element element) throws FragmentEntryContentException {
        Elements elements = element.getElementsByTag("img");
        if (elements.size() != 1) {
            ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", this.getClass());
            throw new FragmentEntryContentException(LanguageUtil.format((ResourceBundle)resourceBundle, (String)"each-editable-image-element-must-contain-an-img-tag", (Object[])new Object[]{"<em>", "</em>"}, (boolean)false));
        }
    }
}

