/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.fragment.entry.processor.editable.parser;

import com.liferay.fragment.exception.FragmentEntryContentException;

import org.jsoup.nodes.Element;

/**
 * This service provides a utility to replace editable element value.
 *
 * @author Pavel Savinov
 */
public interface EditableElementParser {

	public String getFieldTemplate();

	public String getValue(Element element);

	/**
	 * Replaces editable element value with the provided one.
	 *
	 * @param element Editable element to replace
	 * @param value New element value
	 */
	public void replace(Element element, String value);

	/**
	 * Validates editable element
	 *
	 * @param  element Editable element to validate
	 * @throws FragmentEntryContentException In case of invalid editable element
	 */
	public default void validate(Element element)
		throws FragmentEntryContentException {
	}

}