/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.servlet;

import com.liferay.faces.bridge.annotation.BridgeRequestScoped;
import com.liferay.faces.bridge.cdi.internal.BridgeRequestBeanContext;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.spi.Context;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.AnnotatedConstructor;
import jakarta.enterprise.inject.spi.AnnotatedField;
import jakarta.enterprise.inject.spi.AnnotatedMethod;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.BeforeBeanDiscovery;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessAnnotatedType;
import jakarta.portlet.faces.GenericFacesPortlet;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class BridgeExtension
implements Extension {
    private static final Logger logger = LoggerFactory.getLogger(BridgeExtension.class);

    public void step2AfterBeanDiscovery(@Observes AfterBeanDiscovery afterBeanDiscovery) {
        afterBeanDiscovery.addContext((Context)new BridgeRequestBeanContext());
    }

    private void step1BeforeBeanDiscovery(@Observes BeforeBeanDiscovery beforeBeanDiscovery, BeanManager beanManager) {
        Class[] beanClasses;
        beforeBeanDiscovery.addScope(BridgeRequestScoped.class, true, false);
        for (Class beanClass : beanClasses = new Class[]{GenericFacesPortlet.class}) {
            beforeBeanDiscovery.addAnnotatedType(beanManager.createAnnotatedType(beanClass), null);
        }
    }

    private <T> void step2ProcessAnnotatedType(@Observes ProcessAnnotatedType<T> processAnnotatedType) {
        AnnotatedType annotatedType = processAnnotatedType.getAnnotatedType();
        Class javaClass = annotatedType.getJavaClass();
        if (GenericFacesPortlet.class.isAssignableFrom(javaClass) && !annotatedType.isAnnotationPresent(ApplicationScoped.class)) {
            HashSet<Annotation> annotations = new HashSet<Annotation>(annotatedType.getAnnotations());
            annotations.add(new ApplicationScopedAnnotation());
            if (!annotations.equals(annotatedType.getAnnotations())) {
                processAnnotatedType.setAnnotatedType(new ModifiedAnnotatedType(annotatedType, annotations, annotatedType.getTypeClosure()));
                logger.info("Automatically added @ApplicationScoped annotation to GenericFacesPortlet.");
            }
        }
    }

    private static final class ModifiedAnnotatedType<X>
    implements AnnotatedType<X> {
        private final AnnotatedType<X> annotatedType;
        private final Set<Annotation> annotations;
        private final Set<Type> types;

        public ModifiedAnnotatedType(AnnotatedType<X> annotatedType, Set<Annotation> annotations, Set<Type> types) {
            this.annotatedType = annotatedType;
            this.annotations = Collections.unmodifiableSet(annotations);
            this.types = Collections.unmodifiableSet(types);
        }

        public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
            for (Annotation annotation : this.annotations) {
                Class<? extends Annotation> curAnnotationType = annotation.annotationType();
                if (!curAnnotationType.equals(annotationType)) continue;
                return (T)((Annotation)annotationType.cast(annotation));
            }
            return null;
        }

        public Set<Annotation> getAnnotations() {
            return this.annotations;
        }

        public Type getBaseType() {
            return this.annotatedType.getBaseType();
        }

        public Set<AnnotatedConstructor<X>> getConstructors() {
            return this.annotatedType.getConstructors();
        }

        public Set<AnnotatedField<? super X>> getFields() {
            return this.annotatedType.getFields();
        }

        public Class<X> getJavaClass() {
            return this.annotatedType.getJavaClass();
        }

        public Set<AnnotatedMethod<? super X>> getMethods() {
            return this.annotatedType.getMethods();
        }

        public Set<Type> getTypeClosure() {
            return this.types;
        }

        public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
            for (Annotation annotation : this.annotations) {
                Class<? extends Annotation> curAnnotationType = annotation.annotationType();
                if (!curAnnotationType.equals(annotationType)) continue;
                return true;
            }
            return false;
        }
    }

    private static final class ApplicationScopedAnnotation
    implements Annotation {
        private ApplicationScopedAnnotation() {
        }

        @Override
        public Class<? extends Annotation> annotationType() {
            return ApplicationScoped.class;
        }
    }
}

