/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.scope.internal;

import com.liferay.faces.bridge.BridgeConfig;
import com.liferay.faces.bridge.RequestAttributeInspector;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.portlet.PortalContext;
import jakarta.portlet.PortletConfig;
import jakarta.portlet.PortletContext;
import jakarta.portlet.PortletPreferences;
import jakarta.portlet.PortletRequest;
import jakarta.portlet.PortletResponse;
import jakarta.portlet.PortletSession;
import jakarta.portlet.faces.annotation.ExcludeFromManagedRequestScope;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class RequestAttributeInspectorImpl
implements RequestAttributeInspector,
Serializable {
    private static final long serialVersionUID = 1876589389345663517L;
    private static final Logger logger = LoggerFactory.getLogger(RequestAttributeInspectorImpl.class);
    private static final String EXCLUDED_NAMESPACE_JAVAX_FACES = "jakarta.faces";
    private static final String EXCLUDED_NAMESPACE_JAVAX_PORTLET = "jakarta.portlet";
    private static final String EXCLUDED_NAMESPACE_JAVAX_PORTLET_FACES = "jakarta.portlet.faces";
    private static final String EXCLUCED_NAMESPACE_JAVAX_SERVLET = "jakarta.servlet";
    private static final String EXCLUCED_NAMESPACE_JAVAX_SERVLET_INCLUDE = "javax.servlet.include";
    private List<String> excludedAttributeNames = new ArrayList<String>();
    private Set<String> preExistingAttributeNames;

    public RequestAttributeInspectorImpl(PortletRequest portletRequest, PortletConfig portletConfig, BridgeConfig bridgeConfig) {
        List<String> portletContextExcludedAttributeNames = this.getExcludedRequestAttributes(portletConfig);
        Set facesConfigExcludedAttributeNames = bridgeConfig.getExcludedRequestAttributes();
        if (facesConfigExcludedAttributeNames != null) {
            this.excludedAttributeNames.addAll(facesConfigExcludedAttributeNames);
        }
        if (portletContextExcludedAttributeNames != null) {
            this.excludedAttributeNames.addAll(portletContextExcludedAttributeNames);
        }
        this.preExistingAttributeNames = this.getPreExistingRequestAttributeNames(portletRequest);
    }

    public boolean containsExcludedNamespace(String name) {
        return this.isNamespaceMatch(name, EXCLUDED_NAMESPACE_JAVAX_FACES) || this.isNamespaceMatch(name, EXCLUDED_NAMESPACE_JAVAX_PORTLET) || this.isNamespaceMatch(name, EXCLUDED_NAMESPACE_JAVAX_PORTLET_FACES) || this.isNamespaceMatch(name, EXCLUCED_NAMESPACE_JAVAX_SERVLET) || this.isNamespaceMatch(name, EXCLUCED_NAMESPACE_JAVAX_SERVLET_INCLUDE);
    }

    public List<String> getExcludedRequestAttributes(PortletConfig portletConfig) {
        String initParamName;
        String initParamValue;
        PortletContext portletContext = portletConfig.getPortletContext();
        List<String> excludedRequestAttributes = (List<String>)portletContext.getAttribute("jakarta.portlet.faces." + portletConfig.getPortletName() + "." + "excludedRequestAttributes");
        if (excludedRequestAttributes == null && (initParamValue = portletConfig.getInitParameter(initParamName = "jakarta.portlet.faces.excludedRequestAttributes")) != null) {
            excludedRequestAttributes = Arrays.asList(initParamValue.split("\\s*,\\s*"));
        }
        return excludedRequestAttributes;
    }

    public boolean isExcludedByAnnotation(String name, Object value) {
        boolean excluded = false;
        if (value != null && value.getClass().getAnnotation(ExcludeFromManagedRequestScope.class) != null) {
            excluded = true;
        }
        return excluded;
    }

    public boolean isExcludedByConfig(String name, Object value) {
        boolean excluded = false;
        if (this.excludedAttributeNames != null) {
            for (String excludedAttribute : this.excludedAttributeNames) {
                if (name.equals(excludedAttribute)) {
                    excluded = true;
                    break;
                }
                if (!excludedAttribute.endsWith("*")) continue;
                String wildcardNamespace = excludedAttribute;
                int dotPos = wildcardNamespace.lastIndexOf(".");
                if (dotPos > 0) {
                    wildcardNamespace = wildcardNamespace.substring(0, dotPos);
                }
                if (!this.isNamespaceMatch(name, wildcardNamespace)) continue;
                excluded = true;
                break;
            }
        }
        return excluded;
    }

    public boolean isExcludedByPreExisting(String name, Object value) {
        return this.preExistingAttributeNames.contains(name);
    }

    public boolean isExcludedByType(String name, Object value) {
        return value != null && (value instanceof ExternalContext || value instanceof FacesContext || value instanceof HttpSession || value instanceof PortalContext || value instanceof PortletConfig || value instanceof PortletContext || value instanceof PortletPreferences || value instanceof PortletRequest || value instanceof PortletResponse || value instanceof PortletSession || value instanceof ServletConfig || value instanceof ServletContext || value instanceof ServletRequest || value instanceof ServletResponse);
    }

    protected Set<String> getPreExistingRequestAttributeNames(PortletRequest portletRequest) {
        HashSet<String> attributeNames = null;
        Enumeration requestAttributeNames = portletRequest.getAttributeNames();
        if (requestAttributeNames != null) {
            attributeNames = new HashSet<String>();
            while (requestAttributeNames.hasMoreElements()) {
                String attributeName = (String)requestAttributeNames.nextElement();
                attributeNames.add(attributeName);
                logger.trace("Saving name of pre-existing request attribute [{0}]", new Object[]{attributeName});
            }
        }
        return attributeNames;
    }

    protected boolean isNamespaceMatch(String attributeName, String namespace) {
        boolean match = false;
        String attributeNamespace = attributeName;
        int dotPos = attributeNamespace.lastIndexOf(".");
        if (dotPos > 0) {
            attributeNamespace = attributeNamespace.substring(0, dotPos);
        }
        if (namespace.equals(attributeNamespace)) {
            match = true;
        }
        return match;
    }
}

