/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.scope.internal;

import com.liferay.faces.bridge.scope.internal.BridgeRequestScope;
import com.liferay.faces.bridge.scope.internal.BridgeRequestScopeManager;
import com.liferay.faces.util.cache.Cache;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import jakarta.portlet.PortletConfig;
import jakarta.servlet.http.HttpSession;
import java.util.ArrayList;
import java.util.Set;

public class BridgeRequestScopeManagerImpl
implements BridgeRequestScopeManager {
    private static final Logger logger = LoggerFactory.getLogger(BridgeRequestScopeManagerImpl.class);
    private final Cache<String, BridgeRequestScope> bridgeRequestScopeCache;

    public BridgeRequestScopeManagerImpl(Cache<String, BridgeRequestScope> bridgeRequestScopeCache) {
        this.bridgeRequestScopeCache = bridgeRequestScopeCache;
    }

    @Override
    public Cache<String, BridgeRequestScope> getBridgeRequestScopeCache() {
        return this.bridgeRequestScopeCache;
    }

    @Override
    public void removeBridgeRequestScopesByPortlet(PortletConfig portletConfig) {
        String portletNameToRemove = portletConfig.getPortletName();
        this.removeBridgeRequestScopes(true, portletNameToRemove);
    }

    @Override
    public void removeBridgeRequestScopesBySession(HttpSession httpSession) {
        String sessionId = httpSession.getId();
        this.removeBridgeRequestScopes(false, sessionId);
    }

    private void removeBridgeRequestScopes(boolean removeByPortletId, String portletOrSessionId) {
        ArrayList<String> keysToRemove = new ArrayList<String>();
        Set keySet = this.bridgeRequestScopeCache.getKeys();
        String portletOrSessionIdWithSeparatorSuffix = portletOrSessionId + ":::";
        for (String bridgeRequestScopeId : keySet) {
            if (removeByPortletId) {
                if (!bridgeRequestScopeId.startsWith(portletOrSessionIdWithSeparatorSuffix)) continue;
                keysToRemove.add(bridgeRequestScopeId);
                continue;
            }
            int indexOfSessionIdSection = bridgeRequestScopeId.indexOf(":::") + ":::".length();
            String idWithoutPortletNamePrefix = bridgeRequestScopeId.substring(indexOfSessionIdSection);
            if (!idWithoutPortletNamePrefix.startsWith(portletOrSessionIdWithSeparatorSuffix)) continue;
            keysToRemove.add(bridgeRequestScopeId);
        }
        for (String keyToRemove : keysToRemove) {
            Object bridgeRequestScope = this.bridgeRequestScopeCache.removeValue((Object)keyToRemove);
            if (removeByPortletId) continue;
            logger.debug("Removed bridgeRequestScopeId=[{0}] bridgeRequestScope=[{1}] from cache due to session timeout", new Object[]{keyToRemove, bridgeRequestScope});
        }
    }
}

