/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.scope.internal;

import com.liferay.faces.bridge.BridgeConfig;
import com.liferay.faces.bridge.RequestAttributeInspector;
import com.liferay.faces.bridge.RequestAttributeInspectorFactory;
import com.liferay.faces.bridge.context.internal.IncongruityContext;
import com.liferay.faces.bridge.internal.PortletConfigParam;
import com.liferay.faces.bridge.scope.internal.BridgeRequestScopeCompat_2_2_Impl;
import com.liferay.faces.bridge.scope.internal.IncongruityAttribute;
import com.liferay.faces.bridge.scope.internal.RequestAttribute;
import com.liferay.faces.bridge.util.internal.FacesMessageWrapper;
import com.liferay.faces.util.helper.BooleanHelper;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import jakarta.faces.application.FacesMessage;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.portlet.ActionResponse;
import jakarta.portlet.PortalContext;
import jakarta.portlet.PortletConfig;
import jakarta.portlet.PortletMode;
import jakarta.portlet.PortletRequest;
import jakarta.portlet.PortletResponse;
import jakarta.portlet.PortletSession;
import jakarta.portlet.faces.Bridge;
import jakarta.portlet.faces.BridgeUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BridgeRequestScopeImpl
extends BridgeRequestScopeCompat_2_2_Impl
implements Serializable {
    private static final long serialVersionUID = 7113251688518329851L;
    private static final Logger logger = LoggerFactory.getLogger(BridgeRequestScopeImpl.class);
    private static final String BRIDGE_REQ_SCOPE_ATTR_ACTION_PARAMS = "com.liferay.faces.bridge.actionParams";
    private static final String BRIDGE_REQ_SCOPE_ATTR_FACES_MESSAGES = "com.liferay.faces.bridge.faces.messages";
    private static final String BRIDGE_REQ_SCOPE_ATTR_FACES_VIEW_ROOT = "com.liferay.faces.bridge.faces.view.root";
    private static final String BRIDGE_REQ_SCOPE_ATTR_INCONGRUITY_CONTEXT_ATTRIBUTES = "com.liferay.faces.bridge.incongruitycontext.attributes";
    private static final String BRIDGE_REQ_SCOPE_ATTR_REQUEST_ATTRIBUTES = "com.liferay.faces.bridge.faces.request.attributes";
    private static final String JAVAX_FACES_ENCODED_URL_PARAM = "jakarta.faces.encodedURL";
    private Bridge.PortletPhase beganInPhase;
    private boolean facesLifecycleExecuted;
    private String id;
    private boolean navigationOccurred;
    private Set<String> nonExcludedAttributeNames;
    private PortletMode portletMode;
    private boolean portletModeChanged;
    private boolean postRedirectGetSupported;
    private boolean preserveActionParams;
    private boolean redirectOcurred;
    private RequestAttributeInspector requestAttributeInspector;

    public BridgeRequestScopeImpl(PortletRequest portletRequest, PortletConfig portletConfig, BridgeConfig bridgeConfig) {
        String portletName = portletConfig.getPortletName();
        PortletSession portletSession = portletRequest.getPortletSession();
        String sessionId = portletSession.getId();
        GregorianCalendar calendar = new GregorianCalendar();
        this.id = portletName + ":::" + sessionId + ":::" + calendar.getTimeInMillis();
        this.portletMode = PortletMode.VIEW;
        this.beganInPhase = (Bridge.PortletPhase)portletRequest.getAttribute("jakarta.portlet.faces.phase");
        this.preserveActionParams = PortletConfigParam.PreserveActionParams.getBooleanValue(portletConfig);
        this.requestAttributeInspector = RequestAttributeInspectorFactory.getRequestAttributeInspectorInstance((PortletRequest)portletRequest, (PortletConfig)portletConfig, (BridgeConfig)bridgeConfig);
        PortalContext portalContext = portletRequest.getPortalContext();
        String postRedirectGetSupport = portalContext.getProperty("com.liferay.faces.bridge.post.redirect.get.support");
        this.postRedirectGetSupported = BooleanHelper.isTrueToken((String)postRedirectGetSupport);
    }

    @Override
    public Bridge.PortletPhase getBeganInPhase() {
        return this.beganInPhase;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public PortletMode getPortletMode() {
        return this.portletMode;
    }

    @Override
    public Map<String, String> getPreservedActionParameterMap() {
        return (Map)this.getAttribute(BRIDGE_REQ_SCOPE_ATTR_ACTION_PARAMS);
    }

    @Override
    public String getPreservedViewStateParam() {
        return (String)this.getAttribute("jakarta.faces.ViewState");
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public boolean isFacesLifecycleExecuted() {
        return this.facesLifecycleExecuted;
    }

    @Override
    public boolean isNavigationOccurred() {
        return this.navigationOccurred;
    }

    @Override
    public boolean isPortletModeChanged() {
        return this.portletModeChanged;
    }

    @Override
    public boolean isRedirectOccurred() {
        return this.redirectOcurred;
    }

    @Override
    public void release(FacesContext facesContext) {
        Bridge.PortletPhase portletRequestPhase = BridgeUtil.getPortletRequestPhase((FacesContext)facesContext);
        if (!(this.postRedirectGetSupported || portletRequestPhase != Bridge.PortletPhase.ACTION_PHASE && portletRequestPhase != Bridge.PortletPhase.EVENT_PHASE)) {
            ExternalContext externalContext = facesContext.getExternalContext();
            Set<String> nonExcludedAttributeNames = this.getNonExcludedRequestAttributes(externalContext.getRequestMap());
            PortletRequest portletRequest = (PortletRequest)externalContext.getRequest();
            this.simulatePostRedirectGet(portletRequest, nonExcludedAttributeNames);
        }
    }

    @Override
    public void restoreState(FacesContext facesContext) {
        List savedIncongruityAttributes;
        Object value;
        ExternalContext externalContext;
        PortletRequest portletRequest;
        logger.debug("restoreState(facesContext)");
        boolean restoreNonExcludedRequestAttributes = this.beganInPhase == Bridge.PortletPhase.ACTION_PHASE || this.beganInPhase == Bridge.PortletPhase.EVENT_PHASE || this.beganInPhase == Bridge.PortletPhase.RESOURCE_PHASE;
        Bridge.PortletPhase portletRequestPhase = BridgeUtil.getPortletRequestPhase((FacesContext)facesContext);
        if (portletRequestPhase == Bridge.PortletPhase.RENDER_PHASE && !this.portletMode.equals((Object)(portletRequest = (PortletRequest)(externalContext = facesContext.getExternalContext()).getRequest()).getPortletMode())) {
            if (!this.portletModeChanged) {
                this.portletModeChanged = true;
            }
            restoreNonExcludedRequestAttributes = false;
        }
        if (this.beganInPhase == Bridge.PortletPhase.ACTION_PHASE || this.beganInPhase == Bridge.PortletPhase.EVENT_PHASE || this.beganInPhase == Bridge.PortletPhase.RESOURCE_PHASE) {
            UIViewRoot uiViewRoot = (UIViewRoot)this.getAttribute(BRIDGE_REQ_SCOPE_ATTR_FACES_VIEW_ROOT);
            if (uiViewRoot != null) {
                facesContext.setViewRoot(uiViewRoot);
                logger.debug("Restored viewId=[{0}] uiViewRoot=[{1}]", new Object[]{uiViewRoot.getViewId(), uiViewRoot});
            } else {
                logger.debug("Did not restore uiViewRoot");
            }
            if (!this.redirectOcurred) {
                List facesMessages = (List)this.getAttribute(BRIDGE_REQ_SCOPE_ATTR_FACES_MESSAGES);
                boolean restoredFacesMessages = false;
                if (facesMessages != null) {
                    for (FacesMessageWrapper facesMessageWrapper : facesMessages) {
                        String clientId = facesMessageWrapper.getClientId();
                        FacesMessage facesMessage = facesMessageWrapper.getFacesMessage();
                        facesContext.addMessage(clientId, facesMessage);
                        logger.trace("Restored facesMessage=[{0}]", new Object[]{facesMessage.getSummary()});
                        restoredFacesMessages = true;
                    }
                }
                if (restoredFacesMessages) {
                    logger.debug("Restored facesMessages");
                } else {
                    logger.debug("Did not restore any facesMessages");
                }
                this.restoreJSF2FacesContextAttributes(facesContext);
            }
        }
        if (restoreNonExcludedRequestAttributes) {
            List savedRequestAttributes = (List)this.getAttribute(BRIDGE_REQ_SCOPE_ATTR_REQUEST_ATTRIBUTES);
            boolean restoredNonExcludedRequestAttributes = false;
            if (savedRequestAttributes != null) {
                ExternalContext externalContext2 = facesContext.getExternalContext();
                Map currentRequestAttributes = externalContext2.getRequestMap();
                if (!this.redirectOcurred) {
                    for (RequestAttribute requestAttribute : savedRequestAttributes) {
                        String name = (String)requestAttribute.getName();
                        value = requestAttribute.getValue();
                        logger.trace("Restoring non-excluded request attribute name=[{0}] value=[{1}]", new Object[]{name, value});
                        currentRequestAttributes.put(name, value);
                        restoredNonExcludedRequestAttributes = true;
                    }
                }
            }
            if (restoredNonExcludedRequestAttributes) {
                logger.debug("Restored non-excluded request attributes");
            } else {
                logger.debug("Did not restore any non-excluded request attributes");
            }
        }
        if (portletRequestPhase == Bridge.PortletPhase.EVENT_PHASE || portletRequestPhase == Bridge.PortletPhase.RENDER_PHASE) {
            this.restoreClientWindow(facesContext.getExternalContext());
        }
        if (portletRequestPhase == Bridge.PortletPhase.RENDER_PHASE) {
            externalContext = facesContext.getExternalContext();
            this.restoreFlashState(externalContext);
        }
        if ((this.beganInPhase == Bridge.PortletPhase.ACTION_PHASE || this.beganInPhase == Bridge.PortletPhase.EVENT_PHASE) && portletRequestPhase == Bridge.PortletPhase.RENDER_PHASE && (savedIncongruityAttributes = (List)this.getAttribute(BRIDGE_REQ_SCOPE_ATTR_INCONGRUITY_CONTEXT_ATTRIBUTES)) != null) {
            ExternalContext externalContext3 = facesContext.getExternalContext();
            IncongruityContext incongruityContext = (IncongruityContext)((Object)externalContext3.getRequestMap().get(IncongruityContext.class.getName()));
            Map<String, Object> incongruityContextAttributes = incongruityContext.getAttributes();
            for (IncongruityAttribute incongruityAttribute : savedIncongruityAttributes) {
                String key = (String)incongruityAttribute.getName();
                value = incongruityAttribute.getValue();
                incongruityContextAttributes.put(key, value);
            }
        }
    }

    @Override
    public void saveState(FacesContext facesContext) {
        Bridge.PortletPhase portletRequestPhase;
        logger.debug("saveState(facesContext)");
        ExternalContext externalContext = facesContext.getExternalContext();
        PortletResponse portletResponse = (PortletResponse)externalContext.getResponse();
        if (this.beganInPhase == Bridge.PortletPhase.ACTION_PHASE || this.beganInPhase == Bridge.PortletPhase.EVENT_PHASE || this.beganInPhase == Bridge.PortletPhase.RESOURCE_PHASE) {
            String viewState;
            this.setAttribute(BRIDGE_REQ_SCOPE_ATTR_FACES_VIEW_ROOT, facesContext.getViewRoot());
            if (!this.portletModeChanged && portletResponse instanceof ActionResponse && (viewState = (String)externalContext.getRequestParameterMap().get("jakarta.faces.ViewState")) != null) {
                this.setAttribute("jakarta.faces.ViewState", viewState);
            }
            if (this.preserveActionParams) {
                HashMap actionRequestParameterMap = new HashMap(externalContext.getRequestParameterMap());
                actionRequestParameterMap.remove("jakarta.faces.ViewState");
                actionRequestParameterMap.remove(JAVAX_FACES_ENCODED_URL_PARAM);
                this.setAttribute(BRIDGE_REQ_SCOPE_ATTR_ACTION_PARAMS, actionRequestParameterMap);
            }
            ArrayList<FacesMessageWrapper> facesMessageWrappers = new ArrayList<FacesMessageWrapper>();
            Iterator clientIds = facesContext.getClientIdsWithMessages();
            while (clientIds.hasNext()) {
                String clientId = (String)clientIds.next();
                Iterator facesMessages = facesContext.getMessages(clientId);
                while (facesMessages.hasNext()) {
                    FacesMessage facesMessage = (FacesMessage)facesMessages.next();
                    FacesMessageWrapper facesMessageWrapper = new FacesMessageWrapper(clientId, facesMessage);
                    facesMessageWrappers.add(facesMessageWrapper);
                }
            }
            if (facesMessageWrappers.size() > 0) {
                this.setAttribute(BRIDGE_REQ_SCOPE_ATTR_FACES_MESSAGES, facesMessageWrappers);
            } else {
                logger.trace("Not saving any faces messages");
            }
            this.saveJSF2FacesContextAttributes(facesContext);
            boolean saveNonExcludedAttributes = true;
            if (this.redirectOcurred) {
                logger.trace("Due to redirect, not saving any non-excluded request attributes");
                saveNonExcludedAttributes = false;
            } else if (this.portletModeChanged) {
                logger.trace("Due to PortletMode change, not saving any non-excluded request attributes");
                saveNonExcludedAttributes = false;
            }
            Bridge.PortletPhase portletRequestPhase2 = BridgeUtil.getPortletRequestPhase((FacesContext)facesContext);
            if (portletRequestPhase2 == Bridge.PortletPhase.ACTION_PHASE || portletRequestPhase2 == Bridge.PortletPhase.EVENT_PHASE) {
                this.saveClientWindow(externalContext);
            }
            if (saveNonExcludedAttributes) {
                Map requestMap = externalContext.getRequestMap();
                Set<String> nonExcludedAttributeNames = this.getNonExcludedRequestAttributes(requestMap);
                ArrayList<RequestAttribute> savedRequestAttributes = new ArrayList<RequestAttribute>();
                for (Map.Entry mapEntry : requestMap.entrySet()) {
                    String attributeName = (String)mapEntry.getKey();
                    if (!nonExcludedAttributeNames.contains(attributeName)) continue;
                    Object attributeValue = mapEntry.getValue();
                    logger.trace("SAVING non-excluded request attribute name=[{0}] value=[{1}]", new Object[]{attributeName, attributeValue});
                    savedRequestAttributes.add(new RequestAttribute(attributeName, attributeValue));
                }
                if (savedRequestAttributes.size() > 0) {
                    this.setAttribute(BRIDGE_REQ_SCOPE_ATTR_REQUEST_ATTRIBUTES, savedRequestAttributes);
                } else {
                    logger.trace("Not saving any non-excluded request attributes");
                }
            }
        }
        if ((portletRequestPhase = BridgeUtil.getPortletRequestPhase((FacesContext)facesContext)) == Bridge.PortletPhase.ACTION_PHASE || portletRequestPhase == Bridge.PortletPhase.EVENT_PHASE) {
            this.saveFlashState(externalContext);
        }
        if (portletRequestPhase == Bridge.PortletPhase.ACTION_PHASE || portletRequestPhase == Bridge.PortletPhase.EVENT_PHASE) {
            IncongruityContext incongruityContext = (IncongruityContext)((Object)externalContext.getRequestMap().get(IncongruityContext.class.getName()));
            Map<String, Object> incongruityAttributeMap = incongruityContext.getAttributes();
            int mapSize = incongruityAttributeMap.size();
            ArrayList<IncongruityAttribute> savedIncongruityAttributes = new ArrayList<IncongruityAttribute>(mapSize);
            for (Map.Entry<String, Object> mapEntry : incongruityAttributeMap.entrySet()) {
                String name = mapEntry.getKey();
                Object value = mapEntry.getValue();
                logger.trace("Saving IncongruityContext attribute name=[{0}] value=[{1}]", new Object[]{name, value});
                savedIncongruityAttributes.add(new IncongruityAttribute(name, value));
            }
            this.setAttribute(BRIDGE_REQ_SCOPE_ATTR_INCONGRUITY_CONTEXT_ATTRIBUTES, savedIncongruityAttributes);
        }
        if (!(this.postRedirectGetSupported || portletRequestPhase != Bridge.PortletPhase.ACTION_PHASE && portletRequestPhase != Bridge.PortletPhase.EVENT_PHASE)) {
            Map requestMap = externalContext.getRequestMap();
            Set<String> nonExcludedAttributeNames = this.getNonExcludedRequestAttributes(requestMap);
            PortletRequest portletRequest = (PortletRequest)externalContext.getRequest();
            this.simulatePostRedirectGet(portletRequest, nonExcludedAttributeNames);
        }
    }

    @Override
    public void setFacesLifecycleExecuted(boolean facesLifecycleExecuted) {
        this.facesLifecycleExecuted = facesLifecycleExecuted;
    }

    @Override
    public void setNavigationOccurred(boolean navigationOccurred) {
        this.navigationOccurred = navigationOccurred;
    }

    @Override
    public void setPortletMode(PortletMode portletMode) {
        this.portletMode = portletMode;
    }

    @Override
    public void setPortletModeChanged(boolean portletModeChanged) {
        this.portletModeChanged = portletModeChanged;
    }

    @Override
    public void setRedirectOccurred(boolean redirectOcurred) {
        this.redirectOcurred = redirectOcurred;
    }

    public String toString() {
        return this.getClass().getName().concat("@").concat(Integer.toHexString(this.hashCode()));
    }

    private Set<String> getNonExcludedRequestAttributes(Map<String, Object> requestMap) {
        if (this.nonExcludedAttributeNames == null) {
            this.nonExcludedAttributeNames = new HashSet<String>();
            for (Map.Entry<String, Object> mapEntry : requestMap.entrySet()) {
                Object attributeValue;
                String attributeName = mapEntry.getKey();
                boolean excluded = this.requestAttributeInspector.isExcludedByConfig(attributeName, attributeValue = mapEntry.getValue()) || this.requestAttributeInspector.isExcludedByAnnotation(attributeName, attributeValue) || this.requestAttributeInspector.containsExcludedNamespace(attributeName) || this.requestAttributeInspector.isExcludedByType(attributeName, attributeValue) || this.requestAttributeInspector.isExcludedByPreExisting(attributeName, attributeValue);
                if (excluded) continue;
                this.nonExcludedAttributeNames.add(attributeName);
            }
        }
        return this.nonExcludedAttributeNames;
    }

    private void simulatePostRedirectGet(PortletRequest portletRequest, Set<String> nonExcludedAttributeNames) {
        for (String nonExcludedAttributeName : nonExcludedAttributeNames) {
            portletRequest.removeAttribute(nonExcludedAttributeName);
            if (!logger.isTraceEnabled()) continue;
            if (this.redirectOcurred) {
                logger.trace("Due to redirect, removed request attribute name=[{0}] that had been preserved in the ACTION_PHASE or EVENT_PHASE", new Object[]{nonExcludedAttributeName});
                continue;
            }
            logger.trace("Due to PortletMode change, removed request attribute name=[{0}] that had been preserved in the ACTION_PHASE or EVENT_PHASE", new Object[]{nonExcludedAttributeName});
        }
        Enumeration attributeNames = portletRequest.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            Object attributeValue;
            String attributeName = (String)attributeNames.nextElement();
            if (this.requestAttributeInspector.isExcludedByPreExisting(attributeName, attributeValue = portletRequest.getAttribute(attributeName))) {
                if (this.requestAttributeInspector.isExcludedByConfig(attributeName, attributeValue)) {
                    portletRequest.removeAttribute(attributeName);
                    logger.debug("Removed request attribute name=[{0}] since it was specified for removal.", new Object[]{attributeName});
                    continue;
                }
                logger.debug("Kept request attribute name=[{0}] since it existed prior to the FacesContext being created.", new Object[]{attributeName});
                continue;
            }
            if (!this.requestAttributeInspector.isExcludedByConfig(attributeName, attributeValue) && !this.requestAttributeInspector.isExcludedByAnnotation(attributeName, attributeValue) && !this.requestAttributeInspector.isExcludedByType(attributeName, attributeValue) && !this.requestAttributeInspector.containsExcludedNamespace(attributeName)) continue;
            portletRequest.removeAttribute(attributeName);
            logger.debug("Removed request attribute name=[{0}] that had been preserved in the ACTION_PHASE or EVENT_PHASE", new Object[]{attributeName});
        }
    }
}

