/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.renderkit.html_basic.internal;

import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.ResponseWriter;
import jakarta.faces.context.ResponseWriterWrapper;
import java.io.IOException;

public class ResponseWriterBridgeBodyImpl
extends ResponseWriterWrapper {
    private static final Logger logger = LoggerFactory.getLogger(ResponseWriterBridgeBodyImpl.class);
    private String currentElement;
    private ResponseWriter wrapppedResponseWriter;

    public ResponseWriterBridgeBodyImpl(ResponseWriter wrapppedResponseWriter) {
        this.wrapppedResponseWriter = wrapppedResponseWriter;
    }

    public void endElement(String name) throws IOException {
        this.currentElement = null;
        if ("title".equals(name) || "base".equals(name) || "meta".equals(name)) {
            logger.warn("Suppressed writing of illegal element <{0}> in the document <body>.", new Object[]{name});
        } else {
            if ("body".equals(name)) {
                name = "div";
            }
            super.endElement(name);
        }
    }

    public ResponseWriter getWrapped() {
        return this.wrapppedResponseWriter;
    }

    public void startElement(String name, UIComponent component) throws IOException {
        this.currentElement = name;
        if ("title".equals(name) || "base".equals(name) || "meta".equals(name)) {
            logger.warn("Suppressed writing of illegal element <{0}> in the document <body>.", new Object[]{name});
        } else {
            if ("body".equals(name)) {
                name = "div";
            }
            super.startElement(name, component);
        }
    }

    public void writeAttribute(String name, Object value, String property) throws IOException {
        if ("body".equals(this.currentElement) && ("onload".equals(name) || "onunload".equals(name) || "role".equals(name) || "xmlns".equals(name))) {
            logger.warn("Suppressed writing of illegal attribute \"{0}\" on portlet body <div>.", new Object[]{name});
        } else if ("title".equals(this.currentElement) || "base".equals(this.currentElement) || "meta".equals(this.currentElement)) {
            logger.warn("Suppressed writing of illegal element <{0}> in the document <body>.", new Object[]{this.currentElement});
        } else {
            if ("body".equals(this.currentElement) && "class".equals(name)) {
                String valueAsString = "";
                if (value != null) {
                    valueAsString = value.toString();
                }
                if (!valueAsString.contains("liferay-faces-bridge-body")) {
                    valueAsString = valueAsString.concat(" ").concat("liferay-faces-bridge-body");
                }
                value = valueAsString;
            }
            super.writeAttribute(name, value, property);
        }
    }
}

