/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.renderkit.html_basic.internal;

import com.liferay.faces.bridge.renderkit.html_basic.internal.RenderKitUtil;
import com.liferay.faces.bridge.renderkit.html_basic.internal.ResponseWriterResourceImpl;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import com.liferay.faces.util.product.Product;
import com.liferay.faces.util.product.ProductFactory;
import jakarta.faces.component.StateHolder;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import jakarta.faces.event.AbortProcessingException;
import jakarta.faces.event.ComponentSystemEvent;
import jakarta.faces.event.ComponentSystemEventListener;
import jakarta.faces.event.ListenerFor;
import jakarta.faces.event.PostAddToViewEvent;
import jakarta.faces.render.Renderer;
import jakarta.faces.render.RendererWrapper;
import java.io.IOException;

@ListenerFor(systemEventClass=PostAddToViewEvent.class)
public class ResourceRendererBridgeImpl
extends RendererWrapper
implements ComponentSystemEventListener,
StateHolder {
    private static final Logger logger = LoggerFactory.getLogger(ResourceRendererBridgeImpl.class);
    private boolean transientFlag;
    private Renderer wrappedRenderer;

    public ResourceRendererBridgeImpl() {
    }

    public ResourceRendererBridgeImpl(Renderer renderer) {
        this.wrappedRenderer = renderer;
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponentResource) throws IOException {
        ResponseWriter responseWriter = null;
        boolean ajaxRequest = facesContext.getPartialViewContext().isAjaxRequest();
        ExternalContext externalContext = facesContext.getExternalContext();
        Product BOOTSFACES = ProductFactory.getProductInstance((ExternalContext)externalContext, (Product.Name)Product.Name.BOOTSFACES);
        boolean BOOTSFACES_DETECTED = BOOTSFACES.isDetected();
        if (ajaxRequest && (RenderKitUtil.isScriptResource(uiComponentResource, BOOTSFACES_DETECTED) || RenderKitUtil.isStyleSheetResource(uiComponentResource, BOOTSFACES_DETECTED))) {
            responseWriter = facesContext.getResponseWriter();
            facesContext.setResponseWriter((ResponseWriter)new ResponseWriterResourceImpl(facesContext, responseWriter));
        }
        super.encodeEnd(facesContext, uiComponentResource);
        if (responseWriter != null) {
            facesContext.setResponseWriter(responseWriter);
        }
    }

    public Renderer getWrapped() {
        return this.wrappedRenderer;
    }

    public boolean isTransient() {
        return this.transientFlag;
    }

    public void processEvent(ComponentSystemEvent event) throws AbortProcessingException {
        if (this.wrappedRenderer instanceof ComponentSystemEventListener) {
            ComponentSystemEventListener wrappedListener = (ComponentSystemEventListener)this.wrappedRenderer;
            wrappedListener.processEvent(event);
        } else {
            logger.debug("Wrapped renderer=[{0}] does not implement ComponentSystemEventListener", new Object[]{this.wrappedRenderer});
        }
    }

    public void restoreState(FacesContext facesContext, Object state) {
        if (this.wrappedRenderer == null) {
            try {
                Class wrappedRendererClass = (Class)state;
                this.wrappedRenderer = (Renderer)wrappedRendererClass.newInstance();
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
        }
    }

    public Object saveState(FacesContext facesContext) {
        return this.wrappedRenderer.getClass();
    }

    public void setTransient(boolean newTransientValue) {
        this.transientFlag = newTransientValue;
    }
}

