/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.renderkit.html_basic.internal;

import com.liferay.faces.bridge.renderkit.html_basic.internal.HeadManagedBean;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

final class RenderKitUtil {
    static final String HEAD_RESOURCES_TO_RENDER_IN_BODY = "headResourcesToRenderInBody";
    static final String SCRIPT_RENDERER_TYPE = "jakarta.faces.resource.Script";
    static final String STYLE_CLASS_PORTLET_BODY = "liferay-faces-bridge-body";
    static final String STYLESHEET_RENDERER_TYPE = "jakarta.faces.resource.Stylesheet";

    private RenderKitUtil() {
        throw new AssertionError();
    }

    static Set<String> getHeadResourceIds(FacesContext facesContext) {
        HeadManagedBean headManagedBean = HeadManagedBean.getInstance(facesContext);
        Set<String> headResourceIds = headManagedBean == null ? new HashSet<String>() : headManagedBean.getHeadResourceIds();
        return headResourceIds;
    }

    static boolean isScriptResource(UIComponent componentResource, boolean BOOTSFACES_DETECTED) {
        Map componentResourceAttributes = componentResource.getAttributes();
        String resourceName = (String)componentResourceAttributes.get("name");
        String resourceLibrary = (String)componentResourceAttributes.get("library");
        return resourceName != null && (resourceName.endsWith("js") || resourceName.contains(".js?")) || RenderKitUtil.isRichFacesReslibResource(resourceName, resourceLibrary) || RenderKitUtil.isBootsFacesNonJSFResource(resourceName, componentResourceAttributes, "js", BOOTSFACES_DETECTED);
    }

    static boolean isStyleSheetResource(UIComponent componentResource, boolean BOOTSFACES_DETECTED) {
        Map componentResourceAttributes = componentResource.getAttributes();
        String resourceName = (String)componentResourceAttributes.get("name");
        return resourceName != null && (resourceName.endsWith("css") || resourceName.contains(".css?")) || RenderKitUtil.isBootsFacesNonJSFResource(resourceName, componentResourceAttributes, "css", BOOTSFACES_DETECTED);
    }

    private static boolean isBootsFacesNonJSFResource(String resourceName, Map<String, Object> componentResourceAttributes, String resourceExtension, boolean BOOTSFACES_DETECTED) {
        String url;
        boolean bootsFacesResource = false;
        if (resourceName == null && BOOTSFACES_DETECTED && (url = (String)componentResourceAttributes.get("url")) != null) {
            int indexOfQuerySection = url.indexOf("?");
            if (indexOfQuerySection > -1) {
                url = url.substring(0, indexOfQuerySection);
            }
            bootsFacesResource = url.endsWith(resourceExtension);
        }
        return bootsFacesResource;
    }

    private static boolean isRichFacesReslibResource(String resourceName, String resourceLibrary) {
        return resourceName != null && resourceName.endsWith("reslib") && resourceLibrary != null && resourceLibrary.startsWith("org.richfaces");
    }
}

