/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.renderkit.html_basic.internal;

import com.liferay.faces.bridge.renderkit.html_basic.internal.HeadResponseWriterBase;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.ResponseWriter;
import jakarta.portlet.RenderResponse;
import java.io.IOException;
import java.io.Writer;
import java.util.Locale;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class HeadResponseWriterCompatImpl
extends HeadResponseWriterBase {
    private static final Logger logger = LoggerFactory.getLogger(HeadResponseWriterCompatImpl.class);
    private RenderResponse renderResponse;

    public HeadResponseWriterCompatImpl(ResponseWriter wrappedResponseWriter, RenderResponse renderResponse) {
        super(wrappedResponseWriter);
        this.renderResponse = renderResponse;
    }

    public Writer append(CharSequence csq) throws IOException {
        if (csq != null) {
            String text = csq.toString();
            if ("<![CDATA[".equalsIgnoreCase(text.toUpperCase(Locale.ENGLISH))) {
                this.startCDATA();
            } else if ("]]>".equalsIgnoreCase(text)) {
                this.endCDATA();
            } else {
                Node currentNode = this.getCurrentNode();
                if (!currentNode.hasChildNodes()) {
                    String textContent = currentNode.getTextContent();
                    textContent = textContent == null ? text : textContent + text;
                    currentNode.setTextContent(textContent);
                } else {
                    logger.warn("Element text removed because adding both children and text to an element in the <head> section is not supported in Portlet 2.0.");
                }
            }
        }
        return this;
    }

    public void endCDATA() throws IOException {
        logger.warn("CDATA end tag removed because adding a CDATA tag to the <head> section is not supported in Portlet 2.0.");
    }

    public void startCDATA() throws IOException {
        logger.warn("CDATA start tag removed because adding a CDATA tag to the <head> section is not supported in Portlet 2.0.");
    }

    public void writeComment(Object comment) throws IOException {
        logger.warn("Comment removed because adding a comment to the <head> section is not supported in Portlet 2.0.");
    }

    @Override
    protected Node createElement(String nodeName) {
        return this.renderResponse.createElement(nodeName);
    }

    @Override
    protected void writeNodeToHeadSection(Node node, UIComponent componentResource) throws IOException {
        if (!this.isElement(node)) {
            throw new IllegalArgumentException("Only elements may be added to the <head> section in Portlet 2.0");
        }
        this.renderResponse.addProperty("javax.portlet.markup.head.element", (Element)node);
        if (logger.isDebugEnabled()) {
            logger.debug("Added resource to Liferay's <head>...</head> section, node=[{0}]", new Object[]{this.getNodeInfo(node)});
        }
    }
}

