/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.renderkit.bridge.internal;

import com.liferay.faces.bridge.renderkit.bridge.internal.ResponseWriterBridgeCompat_2_2_Impl;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import java.io.Writer;

public class ResponseWriterBridgeImpl
extends ResponseWriterBridgeCompat_2_2_Impl {
    private static final Logger logger = LoggerFactory.getLogger(ResponseWriterBridgeImpl.class);
    private static final String ELEMENT_CHANGES = "changes";
    private static final String ELEMENT_FORM = "form";
    private static final String ELEMENT_PARTIAL_RESPONSE = "partial-response";
    private static final String ELEMENT_UPDATE = "update";
    private String currentElementName;
    private boolean insidePartialResponse;
    private boolean insideChanges;
    private boolean insideCData;
    private boolean insideInput;
    private boolean insideUpdate;
    private boolean viewStateWritten;
    private ResponseWriter wrappedResponseWriter;

    public ResponseWriterBridgeImpl(ResponseWriter wrappedResponseWriter) {
        this.wrappedResponseWriter = wrappedResponseWriter;
    }

    public ResponseWriter cloneWithWriter(Writer writer) {
        return new ResponseWriterBridgeImpl(this.wrappedResponseWriter.cloneWithWriter(writer));
    }

    public void endCDATA() throws IOException {
        this.insideCData = false;
        logger.trace("insideCData=[false]");
        super.endCDATA();
    }

    public void endElement(String elementName) throws IOException {
        logger.trace("elementName=[{0}]", new Object[]{elementName});
        this.currentElementName = null;
        if (ELEMENT_PARTIAL_RESPONSE.equals(elementName)) {
            this.insidePartialResponse = false;
        } else if (ELEMENT_CHANGES.equals(elementName)) {
            this.insideChanges = false;
        } else if (ELEMENT_UPDATE.equals(elementName)) {
            this.insideUpdate = false;
        } else if ("input".equals(elementName)) {
            this.insideInput = false;
        } else if (ELEMENT_FORM.equals(elementName) && this.insidePartialResponse && this.insideChanges && this.insideUpdate && this.insideCData && !this.viewStateWritten) {
            this.writeViewStateHiddenField();
            this.viewStateWritten = true;
        }
        super.endElement(elementName);
    }

    public ResponseWriter getWrapped() {
        return this.wrappedResponseWriter;
    }

    public void startCDATA() throws IOException {
        this.insideCData = true;
        logger.trace("insideCData=[true]");
        super.startCDATA();
    }

    public void startElement(String elementName, UIComponent uiComponent) throws IOException {
        logger.trace("elementName=[{0}]", new Object[]{elementName});
        this.currentElementName = elementName;
        if (ELEMENT_PARTIAL_RESPONSE.equals(elementName)) {
            this.insidePartialResponse = true;
        } else if (ELEMENT_CHANGES.equals(elementName)) {
            this.insideChanges = true;
        } else if (ELEMENT_UPDATE.equals(elementName)) {
            this.insideUpdate = true;
        } else if ("input".equals(elementName)) {
            this.insideInput = true;
        } else if (ELEMENT_FORM.equals(elementName)) {
            this.viewStateWritten = false;
        }
        super.startElement(elementName, uiComponent);
    }

    public void writeAttribute(String attributeName, Object attributeValue, String property) throws IOException {
        logger.trace("attributeName=[{0}] attributeValue=[{1}]", new Object[]{attributeName, attributeValue});
        if (attributeName != null && attributeName.equals("id")) {
            if (this.insidePartialResponse && this.insideChanges && this.insideUpdate && ELEMENT_UPDATE.equals(this.currentElementName) && "jakarta.faces.ViewRoot".equals(attributeValue)) {
                FacesContext facesContext = FacesContext.getCurrentInstance();
                attributeValue = facesContext.getViewRoot().getContainerClientId(facesContext);
            } else if (this.insideInput && "jakarta.faces.ViewState".equals(attributeValue)) {
                this.viewStateWritten = true;
            }
        }
        super.writeAttribute(attributeName, attributeValue, property);
    }
}

