/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.renderkit.bridge.internal;

import com.liferay.faces.bridge.util.internal.FacesRuntimeUtil;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriterWrapper;
import jakarta.portlet.PortalContext;
import jakarta.portlet.PortletRequest;
import java.io.IOException;

public abstract class ResponseWriterBridgeCompat_2_0_Impl
extends ResponseWriterWrapper {
    private static final Logger logger = LoggerFactory.getLogger(ResponseWriterBridgeCompat_2_0_Impl.class);
    protected static final String ATTRIBUTE_AUTOCOMPLETE = "autocomplete";
    protected static final String DOCTYPE_MARKER = "<!DOCTYPE";
    protected static final String VALUE_OFF = "off";
    protected static final String VIEW_STATE_MARKER = "jakarta.faces.ViewState";
    protected static final String XML_MARKER = "<?xml";
    protected final boolean namespaceViewState;

    public ResponseWriterBridgeCompat_2_0_Impl() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ExternalContext externalContext = facesContext.getExternalContext();
        PortletRequest portletRequest = (PortletRequest)externalContext.getRequest();
        PortalContext portalContext = portletRequest.getPortalContext();
        this.namespaceViewState = FacesRuntimeUtil.isAbleToNamespaceViewState(portalContext, externalContext);
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        if (len > 0) {
            String data = new String(cbuf, off, len);
            if (data.startsWith(XML_MARKER) || data.startsWith(DOCTYPE_MARKER)) {
                logger.trace("filtering marker");
                int greaterThanPos = data.indexOf(">");
                if (greaterThanPos > 0) {
                    len -= greaterThanPos + 1;
                    off += greaterThanPos + 1;
                }
            }
            if (len > 0) {
                if (logger.isTraceEnabled()) {
                    String value = new String(cbuf, off, len);
                    logger.trace("writing value=[{0}]", new Object[]{value});
                }
                this.getWrapped().write(cbuf, off, len);
            }
        }
    }

    protected void writeViewStateHiddenField() throws IOException {
        FacesContext facesContext;
        this.startElement("input", null);
        this.writeAttribute("type", "hidden", null);
        String viewStateName = VIEW_STATE_MARKER;
        if (this.namespaceViewState) {
            facesContext = FacesContext.getCurrentInstance();
            String namingContainerId = facesContext.getViewRoot().getContainerClientId(facesContext);
            viewStateName = namingContainerId + viewStateName;
        }
        this.writeAttribute("name", viewStateName, null);
        this.writeAttribute("id", viewStateName, null);
        facesContext = FacesContext.getCurrentInstance();
        String viewState = facesContext.getApplication().getStateManager().getViewState(facesContext);
        this.writeAttribute("value", viewState, null);
        this.writeAttribute(ATTRIBUTE_AUTOCOMPLETE, VALUE_OFF, null);
        this.endElement("input");
    }
}

