/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.renderkit.bridge.internal;

import com.liferay.faces.bridge.model.UploadedFile;
import com.liferay.faces.bridge.renderkit.bridge.internal.PartFileUploadAdapterImpl;
import com.liferay.faces.bridge.renderkit.bridge.internal.ServletContextFileUploadAdapterImpl;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import jakarta.faces.context.ExternalContext;
import jakarta.portlet.ClientDataRequest;
import jakarta.portlet.PortletContext;
import jakarta.portlet.PortletRequest;
import jakarta.portlet.filter.PortletRequestWrapper;
import jakarta.servlet.AsyncContext;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.Part;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class HttpServletRequestFileUploadAdapter
extends PortletRequestWrapper
implements HttpServletRequest,
ClientDataRequest {
    private static final Logger logger = LoggerFactory.getLogger(HttpServletRequestFileUploadAdapter.class);
    private static final String CONTENT_LENGTH = "Content-Length";
    private static final String CONTENT_TYPE = "Content-Type";
    private final ExternalContext externalContext;
    private final Map<String, List<UploadedFile>> uploadedFileMap;
    private final ServletContext servletContext;
    private String queryString;
    private Collection<Part> parts;

    public HttpServletRequestFileUploadAdapter(ClientDataRequest clientDataRequest, Map<String, List<UploadedFile>> uploadedFileMap, ExternalContext externalContext) {
        super((PortletRequest)clientDataRequest);
        this.uploadedFileMap = uploadedFileMap;
        PortletContext portletContext = (PortletContext)externalContext.getContext();
        this.servletContext = new ServletContextFileUploadAdapterImpl(portletContext);
        this.externalContext = externalContext;
    }

    private static void addHeader(Map requestHeaderMap, String headerName, Object headerValue, boolean arrayValue) {
        if (arrayValue) {
            headerValue = new String[]{(String)headerValue};
        }
        requestHeaderMap.put(headerName, headerValue);
    }

    private static Map getRequestHeaderMap(ExternalContext externalContext, boolean arrayValue) {
        Map originalRequestHeaderMap = arrayValue ? externalContext.getRequestHeaderValuesMap() : externalContext.getRequestHeaderMap();
        boolean containsContentLength = originalRequestHeaderMap.containsKey(CONTENT_LENGTH);
        boolean containsContentType = originalRequestHeaderMap.containsKey(CONTENT_TYPE);
        if (containsContentLength && containsContentType) {
            return originalRequestHeaderMap;
        }
        HashMap requestHeaderMap = new HashMap(originalRequestHeaderMap);
        if (!containsContentLength) {
            String requestContentLengthValue = Integer.toString(externalContext.getRequestContentLength());
            HttpServletRequestFileUploadAdapter.addHeader(requestHeaderMap, CONTENT_LENGTH, requestContentLengthValue, arrayValue);
        }
        if (!containsContentType) {
            String requestContentTypeValue = externalContext.getRequestContentType();
            HttpServletRequestFileUploadAdapter.addHeader(requestHeaderMap, CONTENT_TYPE, requestContentTypeValue, arrayValue);
        }
        return Collections.unmodifiableMap(requestHeaderMap);
    }

    public boolean authenticate(HttpServletResponse response) throws IOException, ServletException {
        throw new UnsupportedOperationException();
    }

    public AsyncContext getAsyncContext() {
        throw new UnsupportedOperationException();
    }

    public String getCharacterEncoding() {
        return this.getClientDataRequest().getCharacterEncoding();
    }

    public int getContentLength() {
        return this.getClientDataRequest().getContentLength();
    }

    public long getContentLengthLong() {
        return this.getContentLength();
    }

    public String getContentType() {
        return this.getClientDataRequest().getContentType();
    }

    public long getDateHeader(String name) {
        throw new IllegalArgumentException();
    }

    public DispatcherType getDispatcherType() {
        throw new UnsupportedOperationException();
    }

    public String getHeader(String name) {
        Map requestHeaderMap = HttpServletRequestFileUploadAdapter.getRequestHeaderMap(this.externalContext, false);
        return (String)requestHeaderMap.get(name);
    }

    public Enumeration<String> getHeaderNames() {
        Map requestHeaderValuesMap = HttpServletRequestFileUploadAdapter.getRequestHeaderMap(this.externalContext, true);
        return Collections.enumeration(requestHeaderValuesMap.keySet());
    }

    public Enumeration<String> getHeaders(String name) {
        Map requestHeaderValuesMap = HttpServletRequestFileUploadAdapter.getRequestHeaderMap(this.externalContext, true);
        String[] headersArray = (String[])requestHeaderValuesMap.get(name);
        List<Object> headers = headersArray != null ? Arrays.asList(headersArray) : Collections.emptyList();
        return Collections.enumeration(headers);
    }

    public ServletInputStream getInputStream() throws IOException {
        throw new UnsupportedOperationException();
    }

    public int getIntHeader(String name) {
        int intHeader = -1;
        String header = this.getHeader(name);
        if (header != null) {
            intHeader = Integer.parseInt(header);
        }
        return intHeader;
    }

    public String getLocalAddr() {
        throw new UnsupportedOperationException();
    }

    public String getLocalName() {
        throw new UnsupportedOperationException();
    }

    public int getLocalPort() {
        throw new UnsupportedOperationException();
    }

    public String getMethod() {
        return this.getClientDataRequest().getMethod();
    }

    public Part getPart(String name) throws IOException {
        PartFileUploadAdapterImpl part = null;
        List<UploadedFile> uploadedFiles = this.uploadedFileMap.get(name);
        if (uploadedFiles != null && !uploadedFiles.isEmpty()) {
            part = new PartFileUploadAdapterImpl(uploadedFiles.get(0), name);
        }
        return part;
    }

    public Collection<Part> getParts() throws IOException {
        if (this.parts == null) {
            ArrayList<PartFileUploadAdapterImpl> parts = new ArrayList<PartFileUploadAdapterImpl>();
            Set<Map.Entry<String, List<UploadedFile>>> uploadedFileMapEntries = this.uploadedFileMap.entrySet();
            for (Map.Entry<String, List<UploadedFile>> uploadedFileMapEntry : uploadedFileMapEntries) {
                List<UploadedFile> uploadedFilesForName = uploadedFileMapEntry.getValue();
                if (uploadedFilesForName == null || uploadedFilesForName.isEmpty()) continue;
                String partName = uploadedFileMapEntry.getKey();
                for (UploadedFile uploadedFile : uploadedFilesForName) {
                    parts.add(new PartFileUploadAdapterImpl(uploadedFile, partName));
                }
            }
            this.parts = Collections.unmodifiableList(parts);
        }
        return this.parts;
    }

    public String getPathInfo() {
        return null;
    }

    public String getPathTranslated() {
        return null;
    }

    public InputStream getPortletInputStream() throws IOException {
        return this.getClientDataRequest().getPortletInputStream();
    }

    public String getProtocol() {
        throw new UnsupportedOperationException();
    }

    public String getQueryString() {
        if (this.queryString == null) {
            StringBuilder stringBuilder = new StringBuilder();
            Map parameterMap = this.getParameterMap();
            for (Map.Entry parameter : parameterMap.entrySet()) {
                String[] values = (String[])parameter.getValue();
                String name = (String)parameter.getKey();
                if (values.length > 0) {
                    for (String value : values) {
                        if (stringBuilder.length() > 0) {
                            stringBuilder.append("&");
                        }
                        try {
                            stringBuilder.append(URLEncoder.encode(name, "UTF-8"));
                            stringBuilder.append("=");
                            stringBuilder.append(URLEncoder.encode(value, "UTF-8"));
                        }
                        catch (UnsupportedEncodingException e) {
                            logger.error("Unable to url encode name=[{0}], value=[{1}] pair with UTF-8 encoding:", new Object[]{name, value});
                            logger.error((Throwable)e);
                        }
                    }
                    continue;
                }
                if (stringBuilder.length() > 0) {
                    stringBuilder.append("&");
                }
                stringBuilder.append(name);
            }
            this.queryString = stringBuilder.toString();
        }
        return this.queryString;
    }

    public BufferedReader getReader() throws IOException {
        throw new UnsupportedOperationException();
    }

    public String getRealPath(String path) {
        throw new UnsupportedOperationException();
    }

    public String getRemoteAddr() {
        throw new UnsupportedOperationException();
    }

    public String getRemoteHost() {
        throw new UnsupportedOperationException();
    }

    public int getRemotePort() {
        throw new UnsupportedOperationException();
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        throw new UnsupportedOperationException();
    }

    public String getRequestURI() {
        return this.getContextPath();
    }

    public StringBuffer getRequestURL() {
        throw new UnsupportedOperationException();
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public String getServletPath() {
        return "";
    }

    public HttpSession getSession() {
        throw new UnsupportedOperationException();
    }

    public HttpSession getSession(boolean create) {
        throw new UnsupportedOperationException();
    }

    public boolean isAsyncStarted() {
        throw new UnsupportedOperationException();
    }

    public boolean isAsyncSupported() {
        throw new UnsupportedOperationException();
    }

    public boolean isRequestedSessionIdFromCookie() {
        throw new UnsupportedOperationException();
    }

    public boolean isRequestedSessionIdFromURL() {
        throw new UnsupportedOperationException();
    }

    public boolean isRequestedSessionIdFromUrl() {
        throw new UnsupportedOperationException();
    }

    public void login(String username, String password) throws ServletException {
        throw new UnsupportedOperationException();
    }

    public void logout() throws ServletException {
        throw new UnsupportedOperationException();
    }

    public void setCharacterEncoding(String characterEncoding) throws UnsupportedEncodingException {
        this.getClientDataRequest().setCharacterEncoding(characterEncoding);
    }

    public AsyncContext startAsync() throws IllegalStateException {
        throw new UnsupportedOperationException();
    }

    public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) throws IllegalStateException {
        throw new UnsupportedOperationException();
    }

    private ClientDataRequest getClientDataRequest() {
        return (ClientDataRequest)this.getRequest();
    }
}

