/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.internal;

import com.liferay.faces.bridge.internal.PortletConfigParam;
import com.liferay.faces.util.helper.BooleanHelper;
import com.liferay.faces.util.helper.IntegerHelper;
import com.liferay.faces.util.helper.LongHelper;
import jakarta.faces.context.ExternalContext;
import jakarta.portlet.PortletConfig;
import jakarta.portlet.PortletContext;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

public final class PortletConfigParamUtil {
    static final String[] ALTERNATE_NAMES_EMPTY_ARRAY = new String[0];

    private PortletConfigParamUtil() {
        throw new AssertionError();
    }

    public static boolean getBooleanValue(PortletConfig portletConfig, PortletConfigParam portletConfigParam) {
        String configuredValue;
        String portletName;
        boolean booleanValue = portletConfigParam.getDefaultBooleanValue();
        String name = portletConfigParam.getName();
        if (name.startsWith("jakarta.portlet.faces.") && (portletName = portletConfig.getPortletName()) != null) {
            String namespacedContextAttributeName = "jakarta.portlet.faces." + portletName + "." + name.substring("jakarta.portlet.faces.".length());
            PortletContext portletContext = portletConfig.getPortletContext();
            Object namespacedContextAttributeValue = portletContext.getAttribute(namespacedContextAttributeName);
            if (namespacedContextAttributeValue != null) {
                booleanValue = namespacedContextAttributeValue instanceof Boolean ? (Boolean)namespacedContextAttributeValue : BooleanHelper.isTrueToken((String)namespacedContextAttributeValue.toString());
                return booleanValue;
            }
        }
        if ((configuredValue = PortletConfigParamUtil.getConfiguredValue(portletConfig, portletConfigParam)) != null) {
            booleanValue = BooleanHelper.isTrueToken((String)configuredValue);
        }
        return booleanValue;
    }

    public static String getConfiguredValue(PortletConfig portletConfig, PortletConfigParam portletConfigParam) {
        return PortletConfigParamUtil.getConfiguredValue((Object)portletConfig, portletConfigParam);
    }

    public static int getIntegerValue(PortletConfig portletConfig, PortletConfigParam portletConfigParam) {
        int integerValue = portletConfigParam.getDefaultIntegerValue();
        String configuredValue = PortletConfigParamUtil.getConfiguredValue(portletConfig, portletConfigParam);
        if (configuredValue != null) {
            integerValue = IntegerHelper.toInteger((String)configuredValue);
        }
        return integerValue;
    }

    public static long getLongValue(PortletConfig portletConfig, PortletConfigParam portletConfigParam) {
        long longValue = portletConfigParam.getDefaultLongValue();
        String configuredValue = PortletConfigParamUtil.getConfiguredValue(portletConfig, portletConfigParam);
        if (configuredValue != null) {
            longValue = LongHelper.toLong((String)configuredValue);
        }
        return longValue;
    }

    public static String getStringValue(ExternalContext externalContext, PortletConfigParam portletConfigParam) {
        return PortletConfigParamUtil.getStringValue((Object)externalContext, portletConfigParam);
    }

    public static String getStringValue(PortletConfig portletConfig, PortletConfigParam portletConfigParam) {
        return PortletConfigParamUtil.getStringValue((Object)portletConfig, portletConfigParam);
    }

    public static boolean isSpecified(PortletConfig portletConfig, PortletConfigParam portletConfigParam) {
        return PortletConfigParamUtil.getConfiguredValue(portletConfig, portletConfigParam) != null;
    }

    static Set<String> asInsertionOrderedSet(String ... names) {
        return Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList(names)));
    }

    static String getAlternateName(String ... names) {
        if (names.length > 1) {
            return names[1];
        }
        return null;
    }

    private static String getConfiguredValue(Object initParamContainer, PortletConfigParam portletConfigParam) {
        ExternalContext externalContext = null;
        PortletConfig portletConfig = null;
        PortletContext portletContext = null;
        if (initParamContainer instanceof ExternalContext) {
            externalContext = (ExternalContext)initParamContainer;
        } else if (initParamContainer instanceof PortletConfig) {
            portletConfig = (PortletConfig)initParamContainer;
            portletContext = portletConfig.getPortletContext();
        } else {
            throw new UnsupportedOperationException("This method only supports ExternalContext and PortletConfig init params.");
        }
        String configuredValue = null;
        Set<String> names = portletConfigParam.getNames();
        Iterator<String> iterator = names.iterator();
        while (iterator.hasNext() && configuredValue == null) {
            String name = iterator.next();
            if (externalContext != null) {
                configuredValue = externalContext.getInitParameter(name);
                continue;
            }
            configuredValue = portletConfig.getInitParameter(name);
            if (configuredValue != null) continue;
            configuredValue = portletContext.getInitParameter(name);
        }
        return configuredValue;
    }

    private static String getStringValue(Object initParamContainer, PortletConfigParam portletConfigParam) {
        String stringValue = portletConfigParam.getDefaultStringValue();
        String configuredValue = PortletConfigParamUtil.getConfiguredValue(initParamContainer, portletConfigParam);
        if (configuredValue != null) {
            stringValue = configuredValue;
        }
        return stringValue;
    }
}

