/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.internal;

import com.liferay.faces.bridge.BridgeConfig;
import com.liferay.faces.bridge.internal.BaseURLBridgeURIAdapterImpl;
import com.liferay.faces.bridge.internal.BaseURLNonEncodedImpl;
import com.liferay.faces.bridge.internal.BaseURLPortletResponseEncodedImpl;
import com.liferay.faces.bridge.internal.BaseURLRelativeImpl;
import com.liferay.faces.bridge.internal.BridgeURLBase;
import com.liferay.faces.bridge.internal.PortletURLHelper;
import com.liferay.faces.bridge.util.internal.PortletResourceUtilCompat;
import com.liferay.faces.util.helper.BooleanHelper;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import com.liferay.faces.util.render.FacesURLEncoder;
import jakarta.faces.application.Application;
import jakarta.faces.application.ViewHandler;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.portlet.BaseURL;
import jakarta.portlet.PortletConfig;
import jakarta.portlet.PortletRequest;
import jakarta.portlet.PortletResponse;
import jakarta.portlet.PortletURL;
import jakarta.portlet.ResourceURL;
import jakarta.portlet.faces.Bridge;
import jakarta.portlet.faces.BridgeUtil;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;

public class BridgeURLResourceImpl
extends BridgeURLBase {
    private static final Logger logger = LoggerFactory.getLogger(BridgeURLResourceImpl.class);
    private final String encoding;
    private boolean inProtocol;
    private boolean viewLink;

    public BridgeURLResourceImpl(FacesContext facesContext, String uri, String contextPath, String namespace, String encoding, FacesURLEncoder facesURLEncoder, String currentViewId, PortletConfig portletConfig, BridgeConfig bridgeConfig) throws URISyntaxException, UnsupportedEncodingException {
        super(uri, contextPath, namespace, encoding, facesURLEncoder, currentViewId, portletConfig, bridgeConfig);
        String newParamName;
        this.encoding = encoding;
        this.inProtocol = this.bridgeURI.getParameter("jakarta.portlet.faces.InProtocolResourceLink") != null;
        this.viewLink = BooleanHelper.isTrueToken((String)this.bridgeURI.getParameter("jakarta.portlet.faces.ViewLink"));
        String viewLinkParam = this.bridgeURI.getParameter("jakarta.portlet.faces.ViewLink");
        if (BooleanHelper.isTrueToken((String)viewLinkParam)) {
            this.bridgeURI.removeParameter("jakarta.portlet.faces.ViewLink");
            if (this.bridgeURI.getParameter("jakarta.portlet.faces.BackLink") != null) {
                newParamName = this.bridgeURI.removeParameter("jakarta.portlet.faces.BackLink");
                this.bridgeURI.setParameter(newParamName, this.getBackLinkURL(facesContext));
            }
        }
        if (this.bridgeURI.isOpaque()) {
            if (this.bridgeURI.isPortletScheme()) {
                String facesViewPathParameter;
                String facesViewIdParameter = this.bridgeURI.getParameter("_jsfBridgeViewId");
                if ("_jsfBridgeCurrentView".equals(facesViewIdParameter)) {
                    this.selfReferencing = true;
                    this.bridgeURI.removeParameter("_jsfBridgeViewId");
                }
                if ("_jsfBridgeCurrentView".equals(facesViewPathParameter = this.bridgeURI.getParameter("_jsfBridgeViewPath"))) {
                    this.selfReferencing = true;
                    this.bridgeURI.removeParameter("_jsfBridgeViewPath");
                }
            }
        } else if (this.bridgeURI.isHierarchical() && this.bridgeURI.isExternal(contextPath)) {
            if (this.bridgeURI.getParameter("jakarta.portlet.faces.BackLink") != null) {
                newParamName = this.bridgeURI.removeParameter("jakarta.portlet.faces.BackLink");
                this.bridgeURI.setParameter(newParamName, this.getBackLinkURL(facesContext));
            }
        } else if (this.bridgeURI.isHierarchical() && !this.bridgeURI.isExternal(contextPath)) {
            if (this.bridgeURI.getParameter("jakarta.portlet.faces.BackLink") != null) {
                newParamName = this.bridgeURI.removeParameter("jakarta.portlet.faces.BackLink");
                this.bridgeURI.setParameter(newParamName, this.getBackLinkURL(facesContext));
            }
            if (this.bridgeURI.getParameter("jakarta.portlet.faces.InProtocolResourceLink") != null) {
                this.bridgeURI.removeParameter("jakarta.portlet.faces.PortletMode");
                this.bridgeURI.removeParameter("jakarta.portlet.faces.WindowState");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public BaseURL toBaseURL(FacesContext facesContext) throws MalformedURLException {
        Object baseURL;
        String uri = this.bridgeURI.toString();
        if (this.bridgeURI.isOpaque()) {
            if (!this.bridgeURI.isPortletScheme()) return new BaseURLNonEncodedImpl(this.bridgeURI, this.encoding);
            String portletMode = this.getParameter("jakarta.portlet.faces.PortletMode");
            boolean modeChanged = portletMode != null && portletMode.length() > 0;
            Bridge.PortletPhase urlPortletPhase = this.bridgeURI.getPortletPhase();
            baseURL = urlPortletPhase == Bridge.PortletPhase.ACTION_PHASE ? this.createActionURL(facesContext, modeChanged) : (urlPortletPhase == Bridge.PortletPhase.RENDER_PHASE ? this.createRenderURL(facesContext, modeChanged) : this.createResourceURL(facesContext, modeChanged));
            if (this.selfReferencing) {
                ExternalContext externalContext = facesContext.getExternalContext();
                PortletRequest portletRequest = (PortletRequest)externalContext.getRequest();
                this.copyRenderParameters(portletRequest, (BaseURL)baseURL);
            }
            if (baseURL instanceof PortletURL) {
                PortletURL portletURL = (PortletURL)baseURL;
                ExternalContext externalContext = facesContext.getExternalContext();
                PortletRequest portletRequest = (PortletRequest)externalContext.getRequest();
                PortletURLHelper.setPortletMode(portletURL, portletMode, portletRequest);
                String windowState = this.getParameter("jakarta.portlet.faces.WindowState");
                PortletURLHelper.setWindowState(portletURL, windowState, portletRequest);
            }
        } else {
            if (PortletResourceUtilCompat.isPortletResourceURL(uri)) {
                return new BaseURLBridgeURIAdapterImpl(this.bridgeURI);
            }
            if (uri != null && uri.contains("jakarta.faces.resource")) {
                return this.createResourceURL(facesContext, this.bridgeURI.getParameterMap());
            }
            if (this.bridgeURI.isPathRelative()) {
                ExternalContext externalContext = facesContext.getExternalContext();
                String contextPath = externalContext.getRequestContextPath();
                return new BaseURLRelativeImpl(this.bridgeURI, contextPath);
            }
            if (this.bridgeURI.isExternal(this.contextPath)) {
                ExternalContext externalContext = facesContext.getExternalContext();
                PortletResponse portletResponse = (PortletResponse)externalContext.getResponse();
                return new BaseURLPortletResponseEncodedImpl(this.bridgeURI, portletResponse);
            }
            if (this.viewLink) {
                String portletMode = this.getParameter("jakarta.portlet.faces.PortletMode");
                String windowState = this.getParameter("jakarta.portlet.faces.WindowState");
                boolean secure = BooleanHelper.toBoolean((String)this.getParameter("jakarta.portlet.faces.Secure"));
                if (this.getViewId() != null) {
                    ExternalContext externalContext = facesContext.getExternalContext();
                    PortletRequest portletRequest = (PortletRequest)externalContext.getRequest();
                    PortletURL actionURL = this.createActionURL(facesContext, PortletURLHelper.EXCLUDED_PARAMETER_NAMES);
                    PortletURLHelper.setPortletMode(actionURL, portletMode, portletRequest);
                    PortletURLHelper.setWindowState(actionURL, windowState, portletRequest);
                    PortletURLHelper.setSecure((BaseURL)actionURL, secure);
                    actionURL.setParameter("jakarta.portlet.faces.Secure", (String)null);
                    return actionURL;
                }
                Bridge.PortletPhase portletRequestPhase = BridgeUtil.getPortletRequestPhase((FacesContext)facesContext);
                if (!BridgeURLResourceImpl.isHeaderOrRenderOrResourcePhase(portletRequestPhase)) throw new IllegalStateException("Unable to encode a URL for a non-Faces view in the " + portletRequestPhase + " of the portlet lifecycle.");
                ExternalContext externalContext = facesContext.getExternalContext();
                PortletRequest portletRequest = (PortletRequest)externalContext.getRequest();
                PortletURL renderURL = this.createRenderURL(facesContext, PortletURLHelper.EXCLUDED_PARAMETER_NAMES);
                renderURL.setParameter("_jsfBridgeNonFacesView", this.bridgeURI.getPath());
                PortletURLHelper.setPortletMode(renderURL, portletMode, portletRequest);
                PortletURLHelper.setWindowState(renderURL, windowState, portletRequest);
                PortletURLHelper.setSecure((BaseURL)renderURL, secure);
                renderURL.setParameter("jakarta.portlet.faces.Secure", (String)null);
                return renderURL;
            }
            if (this.getViewId() != null) {
                return this.createResourceURL(facesContext, PortletURLHelper.EXCLUDED_PARAMETER_NAMES);
            }
            if (!this.inProtocol) return new BaseURLBridgeURIAdapterImpl(this.bridgeURI);
            ResourceURL resourceURL = this.createResourceURL(facesContext);
            resourceURL.setResourceID(this.bridgeURI.getContextRelativePath(this.contextPath));
            return resourceURL;
        }
        String secure = this.getParameter("jakarta.portlet.faces.Secure");
        PortletURLHelper.setSecure((BaseURL)baseURL, secure);
        baseURL.setParameter("jakarta.portlet.faces.Secure", (String)null);
        return baseURL;
    }

    private String getBackLinkURL(FacesContext facesContext) {
        Application application = facesContext.getApplication();
        ViewHandler viewHandler = application.getViewHandler();
        String backLinkURL = viewHandler.getActionURL(facesContext, this.currentViewId);
        ExternalContext externalContext = facesContext.getExternalContext();
        backLinkURL = externalContext.encodeActionURL(backLinkURL);
        return backLinkURL;
    }
}

