/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.internal;

import com.liferay.faces.bridge.BridgeConfig;
import com.liferay.faces.bridge.BridgeURL;
import com.liferay.faces.bridge.filter.internal.PortletURLWrapper;
import com.liferay.faces.bridge.internal.BridgeURI;
import com.liferay.faces.bridge.internal.BridgeURLBaseCompat;
import com.liferay.faces.bridge.internal.PortletConfigParam;
import com.liferay.faces.util.config.ConfiguredServletMapping;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import com.liferay.faces.util.render.FacesURLEncoder;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.portlet.BaseURL;
import jakarta.portlet.MimeResponse;
import jakarta.portlet.PortletConfig;
import jakarta.portlet.PortletRequest;
import jakarta.portlet.PortletURL;
import jakarta.portlet.ResourceURL;
import jakarta.portlet.faces.Bridge;
import jakarta.portlet.faces.BridgeUtil;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class BridgeURLBase
extends BridgeURLBaseCompat
implements BridgeURL {
    private static final Logger logger = LoggerFactory.getLogger(BridgeURLBase.class);
    protected BridgeURI bridgeURI;
    protected List<ConfiguredServletMapping> configuredFacesServletMappings;
    protected String contextPath;
    protected String currentViewId;
    protected boolean selfReferencing;
    protected String viewIdResourceParameterName;
    protected String viewIdRenderParameterName;
    private PortletConfig portletConfig;
    private String viewId;

    public BridgeURLBase(String uri, String contextPath, String namespace, String encoding, FacesURLEncoder facesURLEncoder, String currentViewId, PortletConfig portletConfig, BridgeConfig bridgeConfig) throws URISyntaxException, UnsupportedEncodingException {
        this.bridgeURI = new BridgeURI(uri, namespace, facesURLEncoder, encoding);
        this.configuredFacesServletMappings = (List)bridgeConfig.getAttributes().get("configuredFacesServletMappings");
        this.contextPath = contextPath;
        this.currentViewId = currentViewId;
        this.portletConfig = portletConfig;
        this.viewIdRenderParameterName = bridgeConfig.getViewIdRenderParameterName();
        this.viewIdResourceParameterName = bridgeConfig.getViewIdResourceParameterName();
    }

    public String getParameter(String name) {
        return this.bridgeURI.getParameter(name);
    }

    public Map<String, String[]> getParameterMap() {
        return this.bridgeURI.getParameterMap();
    }

    public String getViewId() {
        if (this.viewId == null) {
            String contextRelativePath = this.bridgeURI.getContextRelativePath(this.contextPath);
            if (this.currentViewId != null && this.currentViewId.equals(contextRelativePath)) {
                this.viewId = this.currentViewId;
            } else if (this.isViewPathMappedToFacesServlet(contextRelativePath)) {
                this.viewId = contextRelativePath;
            } else {
                String potentialFacesViewId = contextRelativePath == null ? this.currentViewId : contextRelativePath;
                if (this.currentViewId != null && this.matchPathAndExtension(this.currentViewId, potentialFacesViewId)) {
                    this.viewId = potentialFacesViewId;
                    logger.debug("Regarding path=[{0}] as a Faces view since it has the same path and extension as the current viewId=[{1}]", new Object[]{potentialFacesViewId, this.currentViewId});
                }
            }
        }
        return this.viewId;
    }

    public String removeParameter(String name) {
        return this.bridgeURI.removeParameter(name);
    }

    public void setParameter(String name, String[] value) {
        this.bridgeURI.setParameter(name, value);
    }

    public void setParameter(String name, String value) {
        this.bridgeURI.setParameter(name, new String[]{value});
    }

    public String toString() {
        String stringValue = null;
        try {
            FacesViewActionURL facesViewActionURL;
            String viewId;
            FacesContext facesContext = FacesContext.getCurrentInstance();
            BaseURL baseURL = this.toBaseURL(facesContext);
            if (this.bridgeURI.isEscaped()) {
                StringWriter urlWriter = new StringWriter();
                try {
                    baseURL.write((Writer)urlWriter, true);
                    stringValue = urlWriter.toString();
                }
                catch (IOException e) {
                    logger.error((Throwable)e);
                    stringValue = baseURL.toString();
                }
            } else {
                stringValue = baseURL.toString();
            }
            if (baseURL instanceof FacesViewActionURL && (viewId = (facesViewActionURL = (FacesViewActionURL)baseURL).getViewId()) != null) {
                ExternalContext externalContext = facesContext.getExternalContext();
                Map requestMap = externalContext.getRequestMap();
                String requestMapKey = "jakarta.portlet.faces.viewId" + stringValue;
                requestMap.put(requestMapKey, viewId);
            }
        }
        catch (MalformedURLException e) {
            logger.error((Throwable)e);
        }
        return stringValue;
    }

    protected abstract BaseURL toBaseURL(FacesContext var1) throws MalformedURLException;

    protected void copyRenderParameters(PortletRequest portletRequest, BaseURL baseURL) {
        Map privateParameterMap;
        Map publicParameterMap = portletRequest.getPublicParameterMap();
        if (publicParameterMap != null) {
            this.copyParameterMapToBaseURL(publicParameterMap, baseURL);
        }
        if ((privateParameterMap = portletRequest.getPrivateParameterMap()) != null) {
            this.copyParameterMapToBaseURL(privateParameterMap, baseURL);
        }
    }

    protected PortletURL createActionURL(FacesContext facesContext, boolean modeChanged) throws MalformedURLException {
        List<URIParameter> toStringParameters = this.getToStringParameters(modeChanged);
        return this.createActionURL(facesContext, toStringParameters);
    }

    protected PortletURL createActionURL(FacesContext facesContext, Set<String> excludedParameterNames) throws MalformedURLException {
        List<URIParameter> toStringParameters = this.getToStringParameters(false, excludedParameterNames);
        return this.createActionURL(facesContext, toStringParameters);
    }

    protected PortletURL createRenderURL(FacesContext facesContext, Map<String, String[]> parameterMap) throws MalformedURLException {
        List<URIParameter> uriParameters = this.parameterMapToList(parameterMap);
        return this.createRenderURL(facesContext, uriParameters);
    }

    protected PortletURL createRenderURL(FacesContext facesContext, Set<String> excludedParameterNames) throws MalformedURLException {
        List<URIParameter> toStringParameters = this.getToStringParameters(false, excludedParameterNames);
        return this.createRenderURL(facesContext, toStringParameters);
    }

    protected PortletURL createRenderURL(FacesContext facesContext, boolean modeChanged) throws MalformedURLException {
        List<URIParameter> toStringParameters = this.getToStringParameters(modeChanged);
        return this.createRenderURL(facesContext, toStringParameters);
    }

    protected ResourceURL createResourceURL(FacesContext facesContext) throws MalformedURLException {
        return this.createResourceURL(facesContext, (List<URIParameter>)null);
    }

    protected ResourceURL createResourceURL(FacesContext facesContext, Map<String, String[]> parameterMap) throws MalformedURLException {
        List<URIParameter> uriParameters = this.getToStringParameters(false);
        Set<Map.Entry<String, String[]>> entrySet = parameterMap.entrySet();
        for (Map.Entry<String, String[]> mapEntry : entrySet) {
            uriParameters.add(new URIParameter(mapEntry.getKey(), mapEntry.getValue()));
        }
        return this.createResourceURL(facesContext, uriParameters);
    }

    protected ResourceURL createResourceURL(FacesContext facesContext, Set<String> excludedParameterNames) throws MalformedURLException {
        List<URIParameter> toStringParameters = this.getToStringParameters(false, excludedParameterNames);
        return this.createResourceURL(facesContext, toStringParameters);
    }

    protected ResourceURL createResourceURL(FacesContext facesContext, boolean modeChanged) throws MalformedURLException {
        List<URIParameter> toStringParameters = this.getToStringParameters(modeChanged);
        return this.createResourceURL(facesContext, toStringParameters);
    }

    protected String getViewIdParameterName() {
        if (this.bridgeURI.isPortletScheme() && this.bridgeURI.getPortletPhase() == Bridge.PortletPhase.RESOURCE_PHASE) {
            return this.viewIdResourceParameterName;
        }
        return this.viewIdRenderParameterName;
    }

    private void copyParameterMapToBaseURL(Map<String, String[]> parameterMap, BaseURL baseURL) {
        Map<String, String[]> bridgeURLParameterMap = this.bridgeURI.getParameterMap();
        Set<Map.Entry<String, String[]>> parameterMapEntrySet = parameterMap.entrySet();
        for (Map.Entry<String, String[]> mapEntry : parameterMapEntrySet) {
            String parameterName = mapEntry.getKey();
            if ("jakarta.faces.ViewState".equals(parameterName) || bridgeURLParameterMap.containsKey(parameterName)) continue;
            baseURL.setParameter(parameterName, mapEntry.getValue());
        }
    }

    private void copyURIParametersToBaseURL(List<URIParameter> uriParameters, BaseURL baseURL) throws MalformedURLException {
        for (URIParameter uriParameter : uriParameters) {
            String name = uriParameter.getName();
            String[] values = uriParameter.getValues();
            baseURL.setParameter(name, values);
            logger.debug("Copied parameter to baseURL name=[{0}] value=[{1}]", new Object[]{name, values});
        }
    }

    private PortletURL createActionURL(FacesContext facesContext, List<URIParameter> uriParameters) throws MalformedURLException {
        try {
            logger.debug("createActionURL uriParameters=[{0}]", new Object[]{uriParameters});
            ExternalContext externalContext = facesContext.getExternalContext();
            MimeResponse mimeResponse = (MimeResponse)externalContext.getResponse();
            PortletURL actionURL = mimeResponse.createActionURL();
            if (uriParameters != null) {
                this.copyURIParametersToBaseURL(uriParameters, (BaseURL)actionURL);
            }
            for (URIParameter uriParameter : uriParameters) {
                String[] parameterValues;
                if (!this.viewIdRenderParameterName.equalsIgnoreCase(uriParameter.getName()) || (parameterValues = uriParameter.getValues()) == null || parameterValues.length <= 0) continue;
                return new FacesViewActionURL(actionURL, parameterValues[0]);
            }
            return actionURL;
        }
        catch (ClassCastException e) {
            throw new MalformedURLException(e.getMessage());
        }
    }

    private PortletURL createRenderURL(FacesContext facesContext, List<URIParameter> uriParameters) throws MalformedURLException {
        Bridge.PortletPhase portletRequestPhase = BridgeUtil.getPortletRequestPhase((FacesContext)facesContext);
        if (BridgeURLBase.isHeaderOrRenderOrResourcePhase(portletRequestPhase)) {
            try {
                logger.debug("createRenderURL uriParameters=[{0}]", new Object[]{uriParameters});
                ExternalContext externalContext = facesContext.getExternalContext();
                MimeResponse mimeResponse = (MimeResponse)externalContext.getResponse();
                PortletURL renderURL = mimeResponse.createRenderURL();
                if (uriParameters != null) {
                    this.copyURIParametersToBaseURL(uriParameters, (BaseURL)renderURL);
                }
                return renderURL;
            }
            catch (ClassCastException e) {
                throw new MalformedURLException(e.getMessage());
            }
        }
        throw new MalformedURLException("Unable to create a RenderURL during " + portletRequestPhase.toString());
    }

    private ResourceURL createResourceURL(FacesContext facesContext, List<URIParameter> uriParameters) throws MalformedURLException {
        try {
            logger.debug("createResourceURL uriParameters=[{0}]", new Object[]{uriParameters});
            ExternalContext externalContext = facesContext.getExternalContext();
            MimeResponse mimeResponse = (MimeResponse)externalContext.getResponse();
            ResourceURL resourceURL = mimeResponse.createResourceURL();
            String bridgeURIAsString = this.bridgeURI.toString();
            int tokenPos = bridgeURIAsString.indexOf("jakarta.faces.resource");
            if (tokenPos >= 0) {
                int slashPos;
                String resourceId = bridgeURIAsString.substring(tokenPos);
                int queryStringPos = resourceId.indexOf(63);
                String resourceName = resourceId;
                if (queryStringPos > 0) {
                    resourceName = resourceName.substring(0, queryStringPos);
                }
                if ((slashPos = resourceName.indexOf(47)) > 0) {
                    resourceName = resourceName.substring(slashPos + 1);
                } else {
                    logger.debug("There is no slash after the [{0}] token in resourceURL=[{1}]", new Object[]{"jakarta.faces.resource", uriParameters});
                }
                resourceURL.setParameter("jakarta.faces.resource", resourceName);
                logger.debug("Added parameter to portletURL name=[{0}] value=[{1}]", new Object[]{"jakarta.faces.resource", resourceName});
            }
            if (uriParameters != null) {
                this.copyURIParametersToBaseURL(uriParameters, (BaseURL)resourceURL);
            }
            return resourceURL;
        }
        catch (ClassCastException e) {
            throw new MalformedURLException(e.getMessage());
        }
    }

    private List<URIParameter> getToStringParameters(boolean modeChanged) {
        return this.getToStringParameters(modeChanged, null);
    }

    private List<URIParameter> getToStringParameters(boolean modeChanged, Set<String> excludedParameterNames) {
        ArrayList<URIParameter> toStringParameters = new ArrayList<URIParameter>();
        Map<String, String[]> parameterMap = this.bridgeURI.getParameterMap();
        Set<Map.Entry<String, String[]>> entrySet = parameterMap.entrySet();
        boolean foundFacesViewIdParam = false;
        boolean foundFacesViewPathParam = false;
        for (Map.Entry<String, String[]> mapEntry : entrySet) {
            boolean addParameter;
            String parameterName = mapEntry.getKey();
            String[] parameterValues = mapEntry.getValue();
            String firstParameterValue = null;
            if (parameterValues != null && parameterValues.length > 0) {
                firstParameterValue = parameterValues[0];
            }
            if ("jakarta.portlet.faces.PortletMode".equals(parameterName) || "jakarta.portlet.faces.WindowState".equals(parameterName)) {
                addParameter = firstParameterValue != null;
            } else if ("jakarta.portlet.faces.Secure".equals(parameterName)) {
                addParameter = firstParameterValue != null && ("true".equalsIgnoreCase(firstParameterValue) || "false".equalsIgnoreCase(firstParameterValue));
            } else {
                if (!foundFacesViewIdParam) {
                    foundFacesViewIdParam = "_jsfBridgeViewId".equals(parameterName);
                }
                if (!foundFacesViewPathParam) {
                    foundFacesViewPathParam = "_jsfBridgeViewPath".equals(parameterName);
                }
                addParameter = true;
            }
            if (!addParameter || excludedParameterNames != null && excludedParameterNames.contains(parameterName)) continue;
            toStringParameters.add(new URIParameter(parameterName, parameterValues));
        }
        String viewId = this.getViewId();
        if (!foundFacesViewIdParam && !foundFacesViewPathParam && viewId != null) {
            String contextRelativePath;
            if (this.bridgeURI.isPortletScheme()) {
                boolean bridgeRequestScopeActionEnabled = PortletConfigParam.BridgeRequestScopeActionEnabled.getBooleanValue(this.portletConfig);
                if (!bridgeRequestScopeActionEnabled) {
                    toStringParameters.add(new URIParameter(this.getViewIdParameterName(), viewId));
                }
            } else if (!modeChanged && (contextRelativePath = this.bridgeURI.getContextRelativePath(this.contextPath)) != null) {
                toStringParameters.add(new URIParameter(this.getViewIdParameterName(), contextRelativePath));
            }
        }
        return toStringParameters;
    }

    private boolean isViewPathMappedToFacesServlet(String viewPath) {
        for (ConfiguredServletMapping configuredFacesServletMapping : this.configuredFacesServletMappings) {
            logger.debug("Attempting to determine the facesViewId from {0}=[{1}]", new Object[]{"jakarta.portlet.faces.viewPath", viewPath});
            if (!configuredFacesServletMapping.isMatch(viewPath)) continue;
            return true;
        }
        return false;
    }

    private boolean matchPathAndExtension(String file1, String file2) {
        boolean match = false;
        String path1 = null;
        int lastSlashPos = file1.lastIndexOf("/");
        if (lastSlashPos > 0) {
            path1 = file1.substring(0, lastSlashPos);
        }
        String path2 = null;
        lastSlashPos = file2.lastIndexOf("/");
        if (lastSlashPos > 0) {
            path2 = file2.substring(0, lastSlashPos);
        }
        if (path1 == null && path2 == null || path1 != null && path2 != null && path1.equals(path2)) {
            String ext1 = null;
            int lastDotPos = file1.indexOf(".");
            if (lastDotPos > 0) {
                ext1 = file1.substring(lastDotPos);
            }
            String ext2 = null;
            lastDotPos = file2.indexOf(".");
            if (lastDotPos > 0) {
                ext2 = file2.substring(lastDotPos);
            }
            if (ext1 == null && ext2 == null || ext1 != null && ext2 != null && ext1.equals(ext2)) {
                match = true;
            }
        }
        return match;
    }

    private List<URIParameter> parameterMapToList(Map<String, String[]> parameterMap) {
        ArrayList<URIParameter> uriParameters = new ArrayList<URIParameter>();
        Set<Map.Entry<String, String[]>> entrySet = parameterMap.entrySet();
        for (Map.Entry<String, String[]> mapEntry : entrySet) {
            uriParameters.add(new URIParameter(mapEntry.getKey(), mapEntry.getValue()));
        }
        return uriParameters;
    }

    private static final class URIParameter {
        private final String name;
        private final String[] values;

        public URIParameter(String name, String value) {
            this(name, new String[]{value});
        }

        public URIParameter(String name, String[] values) {
            this.name = name;
            this.values = values;
        }

        public String getName() {
            return this.name;
        }

        public String[] getValues() {
            return this.values;
        }
    }

    private static final class FacesViewActionURL
    extends PortletURLWrapper {
        private final PortletURL portletURL;
        private final String viewId;

        public FacesViewActionURL(PortletURL portletURL, String viewId) {
            this.portletURL = portletURL;
            this.viewId = viewId;
        }

        public String getViewId() {
            return this.viewId;
        }

        @Override
        public PortletURL getWrapped() {
            return this.portletURL;
        }
    }
}

