/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.internal;

import com.liferay.faces.bridge.BridgeConfig;
import com.liferay.faces.bridge.internal.BaseURLBridgeURIAdapterImpl;
import com.liferay.faces.bridge.internal.BaseURLDirectImpl;
import com.liferay.faces.bridge.internal.BridgeURLBase;
import com.liferay.faces.bridge.internal.PortletURLHelper;
import com.liferay.faces.util.helper.BooleanHelper;
import com.liferay.faces.util.render.FacesURLEncoder;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.portlet.BaseURL;
import jakarta.portlet.PortletConfig;
import jakarta.portlet.PortletRequest;
import jakarta.portlet.PortletURL;
import jakarta.portlet.faces.Bridge;
import jakarta.portlet.faces.BridgeUtil;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.Map;

public class BridgeURLActionImpl
extends BridgeURLBase {
    private boolean directLink;
    private boolean bookmarkable;
    private boolean redirect;

    public BridgeURLActionImpl(String uri, String contextPath, String namespace, String encoding, FacesURLEncoder facesURLEncoder, String currentViewId, boolean clientWindowEnabled, String clientWindowId, Map<String, String> clientWindowParameters, PortletConfig portletConfig, BridgeConfig bridgeConfig) throws URISyntaxException, UnsupportedEncodingException {
        super(uri, contextPath, namespace, encoding, facesURLEncoder, currentViewId, portletConfig, bridgeConfig);
        if (this.bridgeURI.isPortletScheme()) {
            String facesViewPathParameter;
            String facesViewIdParameter = this.bridgeURI.getParameter("_jsfBridgeViewId");
            if ("_jsfBridgeCurrentView".equals(facesViewIdParameter)) {
                this.selfReferencing = true;
                this.bridgeURI.removeParameter("_jsfBridgeViewId");
            }
            if ("_jsfBridgeCurrentView".equals(facesViewPathParameter = this.bridgeURI.getParameter("_jsfBridgeViewPath"))) {
                this.selfReferencing = true;
                this.bridgeURI.removeParameter("_jsfBridgeViewPath");
            }
        } else {
            String redirectParam;
            String bookmarkableParam;
            String directLinkParam = this.bridgeURI.getParameter("jakarta.portlet.faces.DirectLink");
            if (directLinkParam != null) {
                if (BooleanHelper.isTrueToken((String)directLinkParam)) {
                    this.directLink = true;
                } else {
                    this.bridgeURI.removeParameter("jakarta.portlet.faces.DirectLink");
                }
            }
            if (BooleanHelper.isTrueToken((String)(bookmarkableParam = this.bridgeURI.getParameter("_jsfBridgeBookmarkable")))) {
                this.bookmarkable = true;
                this.bridgeURI.removeParameter("_jsfBridgeBookmarkable");
            }
            if (BooleanHelper.isTrueToken((String)(redirectParam = this.bridgeURI.getParameter("_jsfBridgeRedirect")))) {
                this.redirect = true;
                this.bridgeURI.removeParameter("_jsfBridgeRedirect");
            }
            if (clientWindowEnabled && clientWindowId != null && uri != null && !uri.contains("jfwid")) {
                this.bridgeURI.setParameter("jfwid", clientWindowId);
                if (clientWindowParameters != null) {
                    this.bridgeURI.addParameters(clientWindowParameters);
                }
            }
        }
    }

    @Override
    public BaseURL toBaseURL(FacesContext facesContext) throws MalformedURLException {
        Object baseURL;
        Bridge.PortletPhase portletRequestPhase = BridgeUtil.getPortletRequestPhase((FacesContext)facesContext);
        if (portletRequestPhase == Bridge.PortletPhase.ACTION_PHASE) {
            baseURL = new BaseURLBridgeURIAdapterImpl(this.bridgeURI);
        } else {
            String uri = this.bridgeURI.toString();
            if (uri.startsWith("#") || this.bridgeURI.isAbsolute() && this.bridgeURI.isExternal(this.contextPath)) {
                baseURL = new BaseURLBridgeURIAdapterImpl(this.bridgeURI);
            } else if (this.directLink || this.bridgeURI.isExternal(this.contextPath)) {
                ExternalContext externalContext = facesContext.getExternalContext();
                PortletRequest portletRequest = (PortletRequest)externalContext.getRequest();
                baseURL = new BaseURLDirectImpl(this.bridgeURI, portletRequest.getScheme(), portletRequest.getServerName(), portletRequest.getServerPort());
            } else {
                Bridge.PortletPhase urlPortletPhase;
                boolean modeChanged = false;
                String portletMode = this.getParameter("jakarta.portlet.faces.PortletMode");
                if (portletMode != null && portletMode.length() > 0) {
                    modeChanged = true;
                }
                baseURL = this.bridgeURI.isPortletScheme() ? ((urlPortletPhase = this.bridgeURI.getPortletPhase()) == Bridge.PortletPhase.ACTION_PHASE ? this.createActionURL(facesContext, modeChanged) : (urlPortletPhase == Bridge.PortletPhase.RENDER_PHASE ? this.createRenderURL(facesContext, modeChanged) : this.createResourceURL(facesContext, modeChanged))) : (portletRequestPhase == Bridge.PortletPhase.EVENT_PHASE ? new BaseURLBridgeURIAdapterImpl(this.bridgeURI) : (this.bookmarkable || this.redirect && portletRequestPhase == Bridge.PortletPhase.RESOURCE_PHASE ? this.createRenderURL(facesContext, modeChanged) : this.createActionURL(facesContext, modeChanged)));
                if (this.selfReferencing) {
                    ExternalContext externalContext = facesContext.getExternalContext();
                    PortletRequest portletRequest = (PortletRequest)externalContext.getRequest();
                    this.copyRenderParameters(portletRequest, (BaseURL)baseURL);
                }
                if (baseURL instanceof PortletURL) {
                    PortletURL portletURL = (PortletURL)baseURL;
                    ExternalContext externalContext = facesContext.getExternalContext();
                    PortletRequest portletRequest = (PortletRequest)externalContext.getRequest();
                    PortletURLHelper.setPortletMode(portletURL, portletMode, portletRequest);
                    portletURL.setParameter("jakarta.portlet.faces.PortletMode", (String)null);
                    String windowState = this.getParameter("jakarta.portlet.faces.WindowState");
                    PortletURLHelper.setWindowState(portletURL, windowState, portletRequest);
                    portletURL.setParameter("jakarta.portlet.faces.WindowState", (String)null);
                }
                String secure = this.getParameter("jakarta.portlet.faces.Secure");
                PortletURLHelper.setSecure((BaseURL)baseURL, secure);
                baseURL.setParameter("jakarta.portlet.faces.Secure", (String)null);
            }
        }
        return baseURL;
    }
}

