/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.internal;

import com.liferay.faces.bridge.BridgeConfig;
import com.liferay.faces.bridge.BridgeEventHandlerFactory;
import com.liferay.faces.bridge.event.EventPayloadWrapper;
import com.liferay.faces.bridge.event.internal.IPCPhaseListener;
import com.liferay.faces.bridge.filter.BridgePortletRequestFactory;
import com.liferay.faces.bridge.filter.BridgePortletResponseFactory;
import com.liferay.faces.bridge.internal.BridgePhaseCompat_2_2_Impl;
import com.liferay.faces.bridge.scope.internal.BridgeRequestScope;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import jakarta.faces.application.NavigationHandler;
import jakarta.faces.event.PhaseListener;
import jakarta.faces.lifecycle.Lifecycle;
import jakarta.portlet.Event;
import jakarta.portlet.EventRequest;
import jakarta.portlet.EventResponse;
import jakarta.portlet.PortletConfig;
import jakarta.portlet.PortletRequest;
import jakarta.portlet.PortletResponse;
import jakarta.portlet.faces.Bridge;
import jakarta.portlet.faces.BridgeDefaultViewNotSpecifiedException;
import jakarta.portlet.faces.BridgeEventHandler;
import jakarta.portlet.faces.BridgeException;
import jakarta.portlet.faces.event.EventNavigationResult;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;

public class BridgePhaseEventImpl
extends BridgePhaseCompat_2_2_Impl {
    private static final Logger logger = LoggerFactory.getLogger(BridgePhaseEventImpl.class);
    private EventRequest eventRequest;
    private EventResponse eventResponse;

    public BridgePhaseEventImpl(EventRequest eventRequest, EventResponse eventResponse, PortletConfig portletConfig, BridgeConfig bridgeConfig) {
        super(portletConfig, bridgeConfig);
        this.eventRequest = BridgePortletRequestFactory.getEventRequestInstance((EventRequest)eventRequest, (EventResponse)eventResponse, (PortletConfig)portletConfig, (BridgeConfig)bridgeConfig);
        this.eventResponse = BridgePortletResponseFactory.getEventResponseInstance((EventRequest)eventRequest, (EventResponse)eventResponse, (PortletConfig)portletConfig, (BridgeConfig)bridgeConfig);
    }

    @Override
    public void execute() throws BridgeDefaultViewNotSpecifiedException, BridgeException {
        logger.debug("----------------------------------------------------------------------");
        logger.debug("execute(EventRequest, EventResponse) portletName=[{0}]", new Object[]{this.portletName});
        String bridgeEventHandlerAttributeName = "jakarta.portlet.faces." + this.portletName + "." + "bridgeEventHandler";
        BridgeEventHandler bridgeEventHandler = (BridgeEventHandler)this.portletContext.getAttribute(bridgeEventHandlerAttributeName);
        if (bridgeEventHandler == null) {
            bridgeEventHandler = BridgeEventHandlerFactory.getBridgeEventHandlerInstance((PortletConfig)this.portletConfig);
        }
        try {
            if (bridgeEventHandler != null) {
                EventPayloadWrapper eventPayloadWrapper;
                this.init((PortletRequest)this.eventRequest, (PortletResponse)this.eventResponse, Bridge.PortletPhase.EVENT_PHASE);
                this.bridgeRequestScope.restoreState(this.facesContext);
                this.bridgeRequestScope.setPortletMode(this.eventRequest.getPortletMode());
                this.facesLifecycle.execute(this.facesContext);
                this.throwQueuedExceptionIfNecessary(this.facesContext);
                this.bridgeRequestScope.setFacesLifecycleExecuted(true);
                logger.debug("Invoking {0} for class=[{1}]", new Object[]{bridgeEventHandlerAttributeName, bridgeEventHandler.getClass()});
                Event event = this.eventRequest.getEvent();
                EventNavigationResult eventNavigationResult = bridgeEventHandler.handleEvent(this.facesContext, event);
                if (eventNavigationResult != null) {
                    String oldViewId = this.facesContext.getViewRoot().getViewId();
                    String fromAction = eventNavigationResult.getFromAction();
                    String outcome = eventNavigationResult.getOutcome();
                    logger.debug("Invoking navigationHandler fromAction=[{0}] outcome=[{1}]", new Object[]{fromAction, outcome});
                    NavigationHandler navigationHandler = this.facesContext.getApplication().getNavigationHandler();
                    navigationHandler.handleNavigation(this.facesContext, fromAction, outcome);
                    String newViewId = this.facesContext.getViewRoot().getViewId();
                    this.bridgeRequestScope.setNavigationOccurred(!oldViewId.equals(newViewId));
                }
                this.processOutgoingPublicRenderParameters(this.facesLifecycle);
                this.bridgeRequestScope.saveState(this.facesContext);
                BridgeRequestScope.Transport bridgeRequestScopeTransport = BridgeRequestScope.Transport.RENDER_PARAMETER;
                Serializable eventPayload = event.getValue();
                if (eventPayload != null && eventPayload instanceof EventPayloadWrapper && (eventPayloadWrapper = (EventPayloadWrapper)eventPayload).isRedirect()) {
                    bridgeRequestScopeTransport = BridgeRequestScope.Transport.PORTLET_SESSION_ATTRIBUTE;
                }
                this.maintainBridgeRequestScope((PortletRequest)this.eventRequest, (PortletResponse)this.eventResponse, bridgeRequestScopeTransport);
            }
            this.maintainRenderParameters(this.eventRequest, this.eventResponse);
            if (bridgeEventHandler != null) {
                this.indicateNamespacingToConsumers(this.facesContext.getViewRoot(), (PortletResponse)this.eventResponse);
            }
        }
        catch (Throwable t) {
            throw new BridgeException(t);
        }
        finally {
            if (bridgeEventHandler != null) {
                this.cleanup((PortletRequest)this.eventRequest);
            }
        }
    }

    protected void maintainRenderParameters(EventRequest eventRequest, EventResponse eventResponse) {
        Map privateParameterMap;
        Map existingResponseRenderParameterMap = eventResponse.getRenderParameterMap();
        Map publicParameterMap = eventRequest.getPublicParameterMap();
        if (publicParameterMap != null) {
            Set entrySet = publicParameterMap.entrySet();
            for (Map.Entry mapEntry : entrySet) {
                String key = (String)mapEntry.getKey();
                boolean alreadyExists = false;
                if (existingResponseRenderParameterMap != null) {
                    alreadyExists = existingResponseRenderParameterMap.containsKey(key);
                }
                if (alreadyExists) {
                    if (!logger.isTraceEnabled()) continue;
                    String[] existingValues = (String[])existingResponseRenderParameterMap.get(key);
                    logger.trace("Not maintaining public render parameter name=[{0}] values=[{1}] because it already exists", new Object[]{key, existingValues});
                    continue;
                }
                String[] values = (String[])mapEntry.getValue();
                eventResponse.setRenderParameter(key, values);
                logger.trace("Maintaining public render parameter name=[{0}] values=[{1}]", new Object[]{key, values});
            }
        }
        if ((privateParameterMap = eventRequest.getPrivateParameterMap()) != null) {
            Set entrySet = privateParameterMap.entrySet();
            for (Map.Entry mapEntry : entrySet) {
                String key = (String)mapEntry.getKey();
                boolean alreadyExists = false;
                if (existingResponseRenderParameterMap != null) {
                    alreadyExists = existingResponseRenderParameterMap.containsKey(key);
                }
                if (alreadyExists) {
                    if (!logger.isTraceEnabled()) continue;
                    String[] existingValues = (String[])existingResponseRenderParameterMap.get(key);
                    logger.trace("Not maintaining private render parameter name=[{0}] values=[{1}] because it already exists", new Object[]{key, existingValues});
                    continue;
                }
                String[] values = (String[])mapEntry.getValue();
                eventResponse.setRenderParameter(key, values);
                logger.trace("Maintaining private render parameter name=[{0}] values=[{1}]", new Object[]{key, values});
            }
        }
    }

    protected void processOutgoingPublicRenderParameters(Lifecycle lifecycle) {
        PhaseListener[] phaseListeners;
        for (PhaseListener phaseListener : phaseListeners = lifecycle.getPhaseListeners()) {
            if (!(phaseListener instanceof IPCPhaseListener)) continue;
            IPCPhaseListener ipcPhaseListener = (IPCPhaseListener)phaseListener;
            ipcPhaseListener.processOutgoingPublicRenderParameters(this.facesContext);
            break;
        }
    }
}

