/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.internal;

import com.liferay.faces.bridge.BridgeConfig;
import com.liferay.faces.bridge.context.internal.IncongruityContext;
import com.liferay.faces.bridge.context.internal.IncongruityContextFactory;
import com.liferay.faces.bridge.helper.internal.PortletModeHelper;
import com.liferay.faces.bridge.internal.BridgePhase;
import com.liferay.faces.bridge.internal.PortletConfigParam;
import com.liferay.faces.bridge.scope.internal.BridgeRequestScope;
import com.liferay.faces.bridge.scope.internal.BridgeRequestScopeFactory;
import com.liferay.faces.bridge.scope.internal.BridgeRequestScopeManager;
import com.liferay.faces.bridge.scope.internal.BridgeRequestScopeManagerFactory;
import com.liferay.faces.bridge.util.internal.ViewUtil;
import com.liferay.faces.util.cache.Cache;
import com.liferay.faces.util.helper.BooleanHelper;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import jakarta.el.ELContext;
import jakarta.faces.FactoryFinder;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.FacesContextFactory;
import jakarta.faces.lifecycle.Lifecycle;
import jakarta.faces.lifecycle.LifecycleFactory;
import jakarta.portlet.PortletConfig;
import jakarta.portlet.PortletContext;
import jakarta.portlet.PortletRequest;
import jakarta.portlet.PortletResponse;
import jakarta.portlet.PortletSession;
import jakarta.portlet.StateAwareResponse;
import jakarta.portlet.faces.Bridge;
import jakarta.portlet.faces.annotation.PortletNamingContainer;
import java.util.Map;

public abstract class BridgePhaseBaseImpl
implements BridgePhase {
    private static final Logger logger = LoggerFactory.getLogger(BridgePhaseBaseImpl.class);
    private static final String PARAM_BRIDGE_REQUEST_SCOPE_ID = "com.liferay.faces.bridge.bridgeRequestScopeId";
    protected BridgeConfig bridgeConfig;
    protected BridgeRequestScope bridgeRequestScope;
    protected Cache<String, BridgeRequestScope> bridgeRequestScopeCache;
    protected boolean bridgeRequestScopeActionEnabled;
    protected FacesContext facesContext;
    protected IncongruityContext incongruityContext;
    protected Lifecycle facesLifecycle;
    protected PortletConfig portletConfig;
    protected PortletContext portletContext;
    protected String portletName;
    private FacesContextFactory facesContextFactory;

    public BridgePhaseBaseImpl(PortletConfig portletConfig, BridgeConfig bridgeConfig) {
        this.portletConfig = portletConfig;
        this.portletContext = portletConfig.getPortletContext();
        this.portletName = portletConfig.getPortletName();
        this.bridgeConfig = bridgeConfig;
        this.bridgeRequestScopeActionEnabled = PortletConfigParam.BridgeRequestScopeActionEnabled.getBooleanValue(portletConfig);
        this.incongruityContext = IncongruityContextFactory.getIncongruityContextInstance(this.portletContext);
        BridgeRequestScopeManager bridgeRequestScopeManager = BridgeRequestScopeManagerFactory.getBridgeRequestScopeManagerInstance(this.portletContext);
        this.bridgeRequestScopeCache = bridgeRequestScopeManager.getBridgeRequestScopeCache();
        LifecycleFactory lifecycleFactory = (LifecycleFactory)FactoryFinder.getFactory((String)"jakarta.faces.lifecycle.LifecycleFactory");
        String lifecycleId = this.portletContext.getInitParameter("jakarta.faces.LIFECYCLE_ID");
        if (lifecycleId == null) {
            lifecycleId = "DEFAULT";
        }
        this.facesLifecycle = lifecycleFactory.getLifecycle(lifecycleId);
    }

    protected abstract void queueHandleableException(PortletRequest var1, FacesContext var2, Exception var3);

    protected abstract void removeBridgeContextAttribute(PortletRequest var1);

    protected abstract void setBridgeContextAttribute(PortletRequest var1);

    protected void cleanup(PortletRequest portletRequest) {
        if (this.facesContext != null) {
            this.facesContext.release();
        }
        if (portletRequest != null) {
            this.removeBridgeContextAttribute(portletRequest);
            portletRequest.removeAttribute("jakarta.portlet.faces.phase");
            portletRequest.removeAttribute(PortletConfig.class.getName());
            portletRequest.removeAttribute(BridgeConfig.class.getName());
            portletRequest.removeAttribute(BridgeRequestScope.class.getName());
            portletRequest.removeAttribute(IncongruityContext.class.getName());
        }
    }

    protected FacesContext getFacesContext(PortletRequest portletRequest, PortletResponse portletResponse, Lifecycle lifecycle) {
        FacesContext newFacesContext = this.getFacesContextFactory().getFacesContext((Object)this.portletContext, (Object)portletRequest, (Object)portletResponse, lifecycle);
        ELContext elContext = newFacesContext.getELContext();
        elContext.putContext(FacesContext.class, (Object)newFacesContext);
        return newFacesContext;
    }

    protected FacesContextFactory getFacesContextFactory() {
        if (this.facesContextFactory == null) {
            this.facesContextFactory = (FacesContextFactory)FactoryFinder.getFactory((String)"jakarta.faces.context.FacesContextFactory");
        }
        return this.facesContextFactory;
    }

    protected String getFacesViewId(ExternalContext externalContext) {
        String viewId = externalContext.getRequestPathInfo();
        if (viewId == null) {
            viewId = externalContext.getRequestServletPath();
        }
        return viewId;
    }

    protected void indicateNamespacingToConsumers(UIViewRoot uiViewRoot, PortletResponse portletResponse) {
        if (uiViewRoot != null) {
            if (uiViewRoot.getClass().getAnnotation(PortletNamingContainer.class) != null) {
                portletResponse.addProperty("X-JAVAX-PORTLET-FACES-NAMESPACED-RESPONSE", Boolean.TRUE.toString());
            }
        } else {
            logger.debug("UIViewRoot is null -- might be push related");
        }
    }

    protected void init(PortletRequest portletRequest, PortletResponse portletResponse, Bridge.PortletPhase portletPhase) {
        portletRequest.setAttribute("jakarta.portlet.faces.phase", (Object)portletPhase);
        portletRequest.setAttribute(PortletConfig.class.getName(), (Object)this.portletConfig);
        portletRequest.setAttribute(BridgeConfig.class.getName(), (Object)this.bridgeConfig);
        this.initBridgeRequestScope(portletRequest, portletResponse, portletPhase);
        portletRequest.setAttribute(BridgeRequestScope.class.getName(), (Object)this.bridgeRequestScope);
        portletRequest.setAttribute(IncongruityContext.class.getName(), (Object)this.incongruityContext);
        this.setBridgeContextAttribute(portletRequest);
        this.facesContext = this.getFacesContext(portletRequest, portletResponse, this.facesLifecycle);
        for (String portletMode : PortletModeHelper.PORTLET_MODE_NAMES) {
            String attributeName = "jakarta.portlet.faces.viewIdHistory." + portletMode;
            PortletSession portletSession = portletRequest.getPortletSession();
            if (portletSession.getAttribute(attributeName) != null) continue;
            Map<String, String> defaultViewIdMap = ViewUtil.getDefaultViewIdMap(this.portletConfig);
            portletSession.setAttribute(attributeName, (Object)defaultViewIdMap.get(portletMode));
        }
    }

    protected void initBridgeRequestScope(PortletRequest portletRequest, PortletResponse portletResponse, Bridge.PortletPhase portletPhase) {
        boolean bridgeRequestScopeEnabled = true;
        if (portletPhase == Bridge.PortletPhase.RESOURCE_PHASE) {
            String facesAjaxParameter = portletRequest.getParameter("_jsfBridgeAjax");
            if (BooleanHelper.isTrueToken((String)facesAjaxParameter)) {
                bridgeRequestScopeEnabled = PortletConfigParam.BridgeRequestScopeAjaxEnabled.getBooleanValue(this.portletConfig);
            } else {
                String facesExportComponentParameter = portletRequest.getParameter("_jsfExportComponent");
                if (BooleanHelper.isTrueToken((String)facesExportComponentParameter)) {
                    bridgeRequestScopeEnabled = false;
                }
            }
        }
        if (bridgeRequestScopeEnabled) {
            PortletSession portletSession;
            String portletName = this.portletConfig.getPortletName();
            String bridgeRequestScopeKey = portletName + PARAM_BRIDGE_REQUEST_SCOPE_ID;
            String bridgeRequestScopeId = portletRequest.getParameter(bridgeRequestScopeKey);
            if (bridgeRequestScopeId != null) {
                this.bridgeRequestScope = (BridgeRequestScope)this.bridgeRequestScopeCache.getValue((Object)bridgeRequestScopeId);
                if (this.bridgeRequestScope != null) {
                    logger.debug("Found render parameter name=[{0}] value=[{1}] and cached bridgeRequestScope=[{2}]", new Object[]{bridgeRequestScopeKey, bridgeRequestScopeId, this.bridgeRequestScope});
                } else if (this.bridgeRequestScopeActionEnabled) {
                    logger.error("Found render parameter name=[{0}] value=[{1}] BUT bridgeRequestScope is NOT in the cache", new Object[]{bridgeRequestScopeKey, bridgeRequestScopeId});
                }
            }
            if (this.bridgeRequestScope == null && (bridgeRequestScopeId = (String)(portletSession = portletRequest.getPortletSession()).getAttribute(bridgeRequestScopeKey)) != null) {
                portletSession.removeAttribute(bridgeRequestScopeKey);
                this.bridgeRequestScope = (BridgeRequestScope)this.bridgeRequestScopeCache.getValue((Object)bridgeRequestScopeId);
                if (this.bridgeRequestScope != null) {
                    logger.debug("Found (and removed) session-attribute name=[{0}] value=[{1}] and cached bridgeRequestScope=[{2}]", new Object[]{bridgeRequestScopeKey, bridgeRequestScopeId, this.bridgeRequestScope});
                    if (portletResponse instanceof StateAwareResponse) {
                        logger.debug("Setting former session-attribute as render parameter name=[{0}] value=[{1}]", new Object[]{bridgeRequestScopeKey, bridgeRequestScopeId});
                        StateAwareResponse stateAwareResponse = (StateAwareResponse)portletResponse;
                        stateAwareResponse.setRenderParameter(bridgeRequestScopeKey, bridgeRequestScopeId);
                    }
                } else {
                    logger.error("Found session attribute name=[{0}] value=[{1}] but bridgeRequestScope is not in the cache", new Object[]{bridgeRequestScopeKey, bridgeRequestScopeId});
                }
            }
            if (this.bridgeRequestScope == null) {
                this.bridgeRequestScope = BridgeRequestScopeFactory.getBridgeRequestScopeInstance(portletRequest, this.portletConfig, this.bridgeConfig);
            }
        }
    }

    protected void maintainBridgeRequestScope(PortletRequest portletRequest, PortletResponse portletResponse, BridgeRequestScope.Transport bridgeRequestScopeTransport) {
        block5: {
            String bridgeRequestScopeId = this.bridgeRequestScope.getId();
            this.bridgeRequestScope = (BridgeRequestScope)this.bridgeRequestScopeCache.putValueIfAbsent((Object)bridgeRequestScopeId, (Object)this.bridgeRequestScope);
            String bridgeRequestScopeKey = this.portletName + PARAM_BRIDGE_REQUEST_SCOPE_ID;
            if (bridgeRequestScopeTransport == BridgeRequestScope.Transport.PORTLET_SESSION_ATTRIBUTE) {
                PortletSession portletSession = portletRequest.getPortletSession(true);
                portletSession.setAttribute(bridgeRequestScopeKey, (Object)bridgeRequestScopeId);
            } else if (portletResponse instanceof StateAwareResponse) {
                logger.debug("Setting render parameter name=[{0}] value=[{1}]", new Object[]{bridgeRequestScopeKey, bridgeRequestScopeId});
                try {
                    StateAwareResponse stateAwareResponse = (StateAwareResponse)portletResponse;
                    stateAwareResponse.setRenderParameter(bridgeRequestScopeKey, bridgeRequestScopeId);
                }
                catch (IllegalStateException e) {
                    if (this.bridgeRequestScope.isRedirectOccurred()) break block5;
                    this.queueHandleableException(portletRequest, this.facesContext, e);
                }
            }
        }
    }
}

