/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.internal;

import com.liferay.faces.bridge.BridgeConfig;
import com.liferay.faces.bridge.filter.BridgePortletRequestFactory;
import com.liferay.faces.bridge.filter.BridgePortletResponseFactory;
import com.liferay.faces.bridge.internal.BridgePhaseCompat_2_2_Impl;
import com.liferay.faces.bridge.scope.internal.BridgeRequestScope;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import jakarta.portlet.ActionRequest;
import jakarta.portlet.ActionResponse;
import jakarta.portlet.PortletConfig;
import jakarta.portlet.PortletMode;
import jakarta.portlet.PortletModeException;
import jakarta.portlet.PortletRequest;
import jakarta.portlet.PortletResponse;
import jakarta.portlet.faces.Bridge;
import jakarta.portlet.faces.BridgeDefaultViewNotSpecifiedException;
import jakarta.portlet.faces.BridgeException;

public class BridgePhaseActionImpl
extends BridgePhaseCompat_2_2_Impl {
    private static final Logger logger = LoggerFactory.getLogger(BridgePhaseActionImpl.class);
    private ActionRequest actionRequest;
    private ActionResponse actionResponse;

    public BridgePhaseActionImpl(ActionRequest actionRequest, ActionResponse actionResponse, PortletConfig portletConfig, BridgeConfig bridgeConfig) {
        super(portletConfig, bridgeConfig);
        this.actionRequest = BridgePortletRequestFactory.getActionRequestInstance((ActionRequest)actionRequest, (ActionResponse)actionResponse, (PortletConfig)portletConfig, (BridgeConfig)bridgeConfig);
        this.actionResponse = BridgePortletResponseFactory.getActionResponseInstance((ActionRequest)actionRequest, (ActionResponse)actionResponse, (PortletConfig)portletConfig, (BridgeConfig)bridgeConfig);
    }

    @Override
    public void execute() throws BridgeDefaultViewNotSpecifiedException, BridgeException {
        logger.debug("----------------------------------------------------------------------");
        logger.debug("execute(ActionRequest, ActionResponse) portletName=[{0}]", new Object[]{this.portletName});
        try {
            this.init((PortletRequest)this.actionRequest, (PortletResponse)this.actionResponse, Bridge.PortletPhase.ACTION_PHASE);
            this.bridgeRequestScope.setPortletMode(this.actionRequest.getPortletMode());
            String portletModeParam = this.actionRequest.getParameter("jakarta.portlet.faces.PortletMode");
            if (portletModeParam != null) {
                try {
                    this.actionResponse.setPortletMode(new PortletMode(portletModeParam));
                }
                catch (PortletModeException e) {
                    logger.error("Invalid parameter value {0}=[{1}]", new Object[]{"jakarta.portlet.faces.PortletMode", portletModeParam});
                }
            }
            this.attachClientWindowToLifecycle(this.facesContext, this.facesLifecycle);
            this.facesLifecycle.execute(this.facesContext);
            this.throwQueuedExceptionIfNecessary(this.facesContext);
            this.bridgeRequestScope.setFacesLifecycleExecuted(true);
            this.clearHeadManagedBeanResources(this.facesContext);
            if (this.bridgeRequestScope.isRedirectOccurred() || this.bridgeRequestScope.isPortletModeChanged()) {
                this.bridgeRequestScope.release(this.facesContext);
            } else {
                this.bridgeRequestScope.saveState(this.facesContext);
                this.maintainBridgeRequestScope((PortletRequest)this.actionRequest, (PortletResponse)this.actionResponse, BridgeRequestScope.Transport.RENDER_PARAMETER);
            }
            this.indicateNamespacingToConsumers(this.facesContext.getViewRoot(), (PortletResponse)this.actionResponse);
        }
        catch (Throwable t) {
            throw new BridgeException(t);
        }
        finally {
            this.cleanup((PortletRequest)this.actionRequest);
        }
    }
}

