/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.internal;

import com.liferay.faces.util.factory.FactoryExtensionFinder;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import com.liferay.faces.util.product.Product;
import com.liferay.faces.util.product.ProductFactory;
import jakarta.faces.context.ExternalContext;

public final class BridgeDependencyVerifier {
    private static final Logger logger = LoggerFactory.getLogger(BridgeDependencyVerifier.class);

    private BridgeDependencyVerifier() {
        throw new AssertionError();
    }

    public static void verify(ExternalContext externalContext) {
        String lsv485PatchVersion;
        Product LIFERAY_FACES_BRIDGE_EXT;
        Package bridgePackage = BridgeDependencyVerifier.class.getPackage();
        String implementationTitle = bridgePackage.getImplementationTitle();
        String implementationVersion = bridgePackage.getImplementationVersion();
        ProductFactory productFactory = (ProductFactory)FactoryExtensionFinder.getFactory((ExternalContext)externalContext, ProductFactory.class);
        Product LIFERAY_PORTAL = productFactory.getProductInfo(Product.Name.LIFERAY_PORTAL);
        if (LIFERAY_PORTAL.isDetected() && !(LIFERAY_FACES_BRIDGE_EXT = productFactory.getProductInfo(Product.Name.LIFERAY_FACES_BRIDGE_EXT)).isDetected()) {
            logger.error("{0} {1} is running in Liferay Portal {2}.{3} but the com.liferay.faces.bridge.ext.jar dependency is not in the classpath", new Object[]{implementationTitle, implementationVersion, LIFERAY_PORTAL.getMajorVersion(), LIFERAY_PORTAL.getMinorVersion()});
        }
        Product PORTLET_API = productFactory.getProductInfo(Product.Name.PORTLET_API);
        int PORTLET_API_MAJOR_VERSION = PORTLET_API.getMajorVersion();
        int PORTLET_API_MINOR_VERSION = PORTLET_API.getMinorVersion();
        if (PORTLET_API_MAJOR_VERSION <= 2 && (PORTLET_API_MAJOR_VERSION != 2 || PORTLET_API_MINOR_VERSION < 0)) {
            logger.error("{0} {1} is designed to be used with Portlet 2.0+ but detected {2}.{3}", new Object[]{implementationTitle, implementationVersion, PORTLET_API_MAJOR_VERSION, PORTLET_API_MINOR_VERSION});
        }
        Product JSF = productFactory.getProductInfo(Product.Name.JSF);
        int JSF_MAJOR_VERSION = JSF.getMajorVersion();
        int JSF_MINOR_VERSION = JSF.getMinorVersion();
        if (JSF_MAJOR_VERSION != 2 || JSF_MINOR_VERSION != 2) {
            logger.error("{0} {1} is designed to be used with JSF 2.2 but detected {2}.{3}", new Object[]{implementationTitle, implementationVersion, JSF_MAJOR_VERSION, JSF_MINOR_VERSION});
        }
        if ((lsv485PatchVersion = externalContext.getInitParameter("com.liferay.faces.lsv.485.patch.version")) != null && !lsv485PatchVersion.equals("")) {
            logger.error("{0} {1} contains fixes for LSV-485 so it is incompatible with com.liferay.faces.lsv.485.patch.jar. Please remove com.liferay.faces.lsv.485.patch.jar from the classpath.", new Object[]{implementationTitle, implementationVersion});
        }
    }
}

