/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.filter.internal;

import com.liferay.faces.bridge.filter.internal.ActionResponseBridgeCompatImpl;
import com.liferay.faces.bridge.scope.internal.BridgeRequestScope;
import com.liferay.faces.bridge.util.internal.RequestMapUtil;
import jakarta.faces.context.FacesContext;
import jakarta.portlet.ActionResponse;
import jakarta.portlet.PortletMode;
import jakarta.portlet.PortletModeException;
import java.io.IOException;

public class ActionResponseBridgeImpl
extends ActionResponseBridgeCompatImpl {
    private PortletMode initialPortletMode;

    public ActionResponseBridgeImpl(ActionResponse actionResponse) {
        super(actionResponse);
        PortletMode portletMode = actionResponse.getPortletMode();
        this.initialPortletMode = portletMode == null ? PortletMode.VIEW : portletMode;
    }

    public void sendRedirect(String location) throws IOException {
        this.prepareForRedirect();
        super.sendRedirect(location);
    }

    public void sendRedirect(String location, String renderUrlParamName) throws IOException {
        this.prepareForRedirect();
        super.sendRedirect(location, renderUrlParamName);
    }

    public void setPortletMode(PortletMode portletMode) throws PortletModeException {
        super.setPortletMode(portletMode);
        if (!this.initialPortletMode.equals((Object)portletMode)) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            BridgeRequestScope bridgeRequestScope = RequestMapUtil.getBridgeRequestScope(facesContext);
            bridgeRequestScope.setPortletModeChanged(true);
        }
    }

    protected void prepareForRedirect() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        this.partialViewContextRenderAll(facesContext);
        facesContext.responseComplete();
        BridgeRequestScope bridgeRequestScope = RequestMapUtil.getBridgeRequestScope(facesContext);
        bridgeRequestScope.setRedirectOccurred(true);
    }
}

