/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.event.internal;

import com.liferay.faces.bridge.internal.PortletConfigParam;
import com.liferay.faces.bridge.util.internal.RequestMapUtil;
import com.liferay.faces.bridge.util.internal.ViewUtil;
import com.liferay.faces.util.lang.ThreadSafeAccessor;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.PhaseEvent;
import jakarta.faces.event.PhaseId;
import jakarta.faces.event.PhaseListener;
import jakarta.portlet.PortletConfig;
import jakarta.portlet.PortletMode;
import jakarta.portlet.PortletRequest;
import jakarta.portlet.faces.Bridge;
import jakarta.portlet.faces.BridgeException;
import jakarta.portlet.faces.BridgeUtil;
import java.util.Map;

public class RenderRequestPhaseListener
implements PhaseListener {
    private static final long serialVersionUID = 8470095938465172618L;
    private final ViewParametersEnabledAccessor viewParametersEnabledAccessor = new ViewParametersEnabledAccessor();

    public void afterPhase(PhaseEvent phaseEvent) {
        FacesContext facesContext = phaseEvent.getFacesContext();
        if (!((Boolean)this.viewParametersEnabledAccessor.get(facesContext)).booleanValue() && BridgeUtil.getPortletRequestPhase((FacesContext)facesContext) == Bridge.PortletPhase.RENDER_PHASE) {
            facesContext.renderResponse();
        }
    }

    public void beforePhase(PhaseEvent phaseEvent) {
        boolean portletModeAllowed;
        PortletRequest portletRequest;
        PortletConfig portletConfig;
        Map<String, String> defaultViewIdMap;
        FacesContext facesContext = phaseEvent.getFacesContext();
        ExternalContext externalContext = facesContext.getExternalContext();
        String viewId = externalContext.getRequestPathInfo();
        if (viewId == null) {
            viewId = externalContext.getRequestServletPath();
        }
        if (viewId != null && viewId.equals((defaultViewIdMap = ViewUtil.getDefaultViewIdMap(portletConfig = RequestMapUtil.getPortletConfig(portletRequest = (PortletRequest)externalContext.getRequest()))).get(PortletMode.EDIT.toString())) && !(portletModeAllowed = portletRequest.isPortletModeAllowed(PortletMode.EDIT))) {
            throw new BridgeException("Portlet EDIT_MODE is not allowed");
        }
    }

    public PhaseId getPhaseId() {
        return PhaseId.RESTORE_VIEW;
    }

    private static final class ViewParametersEnabledAccessor
    extends ThreadSafeAccessor<Boolean, FacesContext> {
        private ViewParametersEnabledAccessor() {
        }

        protected Boolean computeValue(FacesContext facesContext) {
            PortletConfig portletConfig = RequestMapUtil.getPortletConfig(facesContext);
            return PortletConfigParam.ViewParametersEnabled.getBooleanValue(portletConfig);
        }
    }
}

