/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.context.map.internal;

import com.liferay.faces.bridge.context.map.internal.MultiPartFormDataProcessor;
import com.liferay.faces.bridge.context.map.internal.MultiPartFormDataProcessorCompatImpl;
import com.liferay.faces.bridge.internal.PortletConfigParam;
import com.liferay.faces.util.context.map.FacesRequestParameterMap;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import com.liferay.faces.util.model.UploadedFile;
import jakarta.portlet.ClientDataRequest;
import jakarta.portlet.PortletConfig;
import jakarta.portlet.PortletSession;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class MultiPartFormDataProcessorImpl
extends MultiPartFormDataProcessorCompatImpl
implements MultiPartFormDataProcessor {
    private static final Logger logger = LoggerFactory.getLogger(MultiPartFormDataProcessorImpl.class);

    @Override
    public Map<String, List<UploadedFile>> process(ClientDataRequest clientDataRequest, PortletConfig portletConfig, FacesRequestParameterMap facesRequestParameterMap) {
        PortletSession portletSession = clientDataRequest.getPortletSession();
        String uploadedFilesDir = PortletConfigParam.UploadedFilesDir.getStringValue(portletConfig);
        String sessionId = portletSession.getId();
        File uploadedFilesPath = new File(uploadedFilesDir, sessionId = sessionId.replaceAll("[^A-Za-z0-9]", ""));
        if (!uploadedFilesPath.exists() && !uploadedFilesPath.mkdirs()) {
            logger.warn("Unable to create directory for uploadedFilesPath=[{0}]", new Object[]{uploadedFilesPath});
        }
        return this.iterateOver(clientDataRequest, portletConfig, facesRequestParameterMap, uploadedFilesPath);
    }

    @Override
    protected void addUploadedFile(Map<String, List<UploadedFile>> uploadedFileMap, String fieldName, UploadedFile uploadedFile) {
        List<UploadedFile> uploadedFiles = uploadedFileMap.get(fieldName);
        if (uploadedFiles == null) {
            uploadedFiles = new ArrayList<UploadedFile>();
            uploadedFileMap.put(fieldName, uploadedFiles);
        }
        uploadedFiles.add(uploadedFile);
    }

    @Override
    protected String stripIllegalCharacters(String fileName) {
        String strippedFileName = fileName;
        if (fileName != null) {
            int pos = fileName.lastIndexOf(".");
            strippedFileName = fileName.replaceAll("[\\\\/\\[\\]:|<>+;=.?\"]", "-");
            if (pos > 0) {
                strippedFileName = strippedFileName.substring(0, pos) + "." + strippedFileName.substring(pos + 1);
            }
        }
        return strippedFileName;
    }
}

