/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.context.map.internal;

import com.liferay.faces.bridge.context.map.internal.AbstractImmutablePropertyMap;
import com.liferay.faces.bridge.context.map.internal.InitParameterMapEntry;
import com.liferay.faces.util.map.AbstractPropertyMapEntry;
import jakarta.portlet.PortletConfig;
import jakarta.portlet.PortletContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;

public class InitParameterMap
extends AbstractImmutablePropertyMap<String> {
    private PortletConfig portletConfig;
    private PortletContext portletContext;

    public InitParameterMap(PortletConfig portletConfig) {
        this.portletConfig = portletConfig;
        this.portletContext = portletConfig.getPortletContext();
    }

    protected AbstractPropertyMapEntry<String> createPropertyMapEntry(String name) {
        return new InitParameterMapEntry(this.portletConfig, name);
    }

    @Override
    protected Enumeration<String> getImmutablePropertyNames() {
        Enumeration portletConfigInitParameterNames = this.portletConfig.getInitParameterNames();
        ArrayList propertyNameList = Collections.list(portletConfigInitParameterNames);
        Enumeration portletContextInitParameterNames = this.portletContext.getInitParameterNames();
        while (portletContextInitParameterNames.hasMoreElements()) {
            String portletContextInitParameterName = (String)portletContextInitParameterNames.nextElement();
            if (propertyNameList.contains(portletContextInitParameterName)) continue;
            propertyNameList.add(portletContextInitParameterName);
        }
        return Collections.enumeration(propertyNameList);
    }

    protected String getProperty(String name) {
        String value = this.portletConfig.getInitParameter(name);
        if (value == null) {
            value = this.portletContext.getInitParameter(name);
        }
        return value;
    }
}

