/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.context.map.internal;

import com.liferay.faces.bridge.internal.PortletURLHelper;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import java.util.HashMap;
import java.util.Map;

public class FacesViewParameterMap
extends HashMap<String, String>
implements Map<String, String> {
    private static final long serialVersionUID = 3213871316191406286L;
    private static final Logger logger = LoggerFactory.getLogger(FacesViewParameterMap.class);

    public FacesViewParameterMap(String facesViewQueryString) {
        if (facesViewQueryString != null && facesViewQueryString.length() > 0) {
            String[] queryParameters;
            for (String queryParameter : queryParameters = facesViewQueryString.split("[&]")) {
                String parameterName;
                String[] nameValueArray = queryParameter.split("[=]");
                if (nameValueArray == null) continue;
                if (nameValueArray.length == 1) {
                    parameterName = nameValueArray[0].trim();
                    if (parameterName.length() == 0) {
                        logger.error("Invalid name=value pair=[{0}] in facesViewQueryString=[{1}]: name cannot be empty", new Object[]{nameValueArray, facesViewQueryString});
                        continue;
                    }
                    this.put(parameterName, "");
                    continue;
                }
                if (nameValueArray.length == 2) {
                    parameterName = nameValueArray[0].trim();
                    if (parameterName.length() == 0) {
                        logger.error("Invalid name=value pair=[{0}] in facesViewQueryString=[{1}]: name cannot be empty", new Object[]{nameValueArray, facesViewQueryString});
                        continue;
                    }
                    String parameterValue = nameValueArray[1];
                    if (PortletURLHelper.EXCLUDED_PARAMETER_NAMES.contains(parameterName)) {
                        logger.debug("Excluding parameterName=[{0}]", new Object[]{parameterName});
                        continue;
                    }
                    logger.debug("Adding parameterName=[{0}] parameterValue=[{1}]", new Object[]{parameterName, parameterValue});
                    this.put(parameterName, parameterValue);
                    continue;
                }
                logger.error("Invalid name=value pair=[{0}] in facesViewQueryString=[{1}]", new Object[]{nameValueArray, facesViewQueryString});
            }
        }
    }
}

