/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.context.internal;

import com.liferay.faces.bridge.context.internal.ExternalContextExpirationImpl;
import com.liferay.faces.bridge.context.internal.FacesContextExpirationImpl;
import com.liferay.faces.bridge.context.internal.FacesContextFactoryCompatImpl;
import jakarta.faces.FacesException;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.FacesContextFactory;
import jakarta.faces.lifecycle.Lifecycle;
import jakarta.portlet.PortletContext;
import jakarta.portlet.PortletRequest;
import jakarta.portlet.PortletResponse;
import jakarta.servlet.ServletContext;

public class FacesContextFactoryImpl
extends FacesContextFactoryCompatImpl {
    private FacesContextFactory wrappedFacesContextFactory;

    public FacesContextFactoryImpl(FacesContextFactory facesContextFactory) {
        this.wrappedFacesContextFactory = facesContextFactory;
    }

    public FacesContext getFacesContext(Object context, Object request, Object response, Lifecycle lifecycle) throws FacesException {
        if (context != null && context instanceof PortletContext) {
            return this.getFacesContext((PortletContext)context, (PortletRequest)request, (PortletResponse)response, lifecycle);
        }
        if (context != null && context instanceof ServletContext) {
            String requestFQCN = "";
            if (request != null) {
                requestFQCN = request.getClass().getName().toLowerCase();
            }
            String responseFQCN = "";
            if (response != null) {
                responseFQCN = response.getClass().getName().toLowerCase();
            }
            if (requestFQCN.length() == 0 || responseFQCN.length() == 0 || requestFQCN.contains("expiration") || responseFQCN.contains("expiration")) {
                ExternalContextExpirationImpl externalContext = new ExternalContextExpirationImpl((ServletContext)context);
                return new FacesContextExpirationImpl(externalContext);
            }
            return this.wrappedFacesContextFactory.getFacesContext(context, request, response, lifecycle);
        }
        return this.wrappedFacesContextFactory.getFacesContext(context, request, response, lifecycle);
    }

    @Override
    public FacesContextFactory getWrapped() {
        return this.wrappedFacesContextFactory;
    }
}

