/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.context.internal;

import com.liferay.faces.bridge.context.internal.ExternalContextCompat_2_1_Impl;
import com.liferay.faces.util.config.ApplicationConfig;
import jakarta.faces.lifecycle.ClientWindow;
import jakarta.portlet.PortletContext;
import jakarta.portlet.PortletRequest;
import jakarta.portlet.PortletResponse;
import jakarta.portlet.PortletSession;
import jakarta.servlet.http.Cookie;
import java.util.Map;

public abstract class ExternalContextCompat_2_2_Impl
extends ExternalContextCompat_2_1_Impl {
    private static final String COOKIE_PROPERTY_HTTP_ONLY = "httpOnly";
    private String applicationContextPath;
    private ClientWindow clientWindow;

    public ExternalContextCompat_2_2_Impl(PortletContext portletContext, PortletRequest portletRequest, PortletResponse portletResponse) {
        super(portletContext, portletRequest, portletResponse);
    }

    public String getApplicationContextPath() {
        if (this.applicationContextPath == null) {
            String appConfigAttrName = ApplicationConfig.class.getName();
            ApplicationConfig applicationConfig = (ApplicationConfig)this.getApplicationMap().get(appConfigAttrName);
            this.applicationContextPath = applicationConfig.getContextPath();
        }
        return this.applicationContextPath;
    }

    public ClientWindow getClientWindow() {
        return this.clientWindow;
    }

    public String getSessionId(boolean create) {
        String sessionId = null;
        PortletSession portletSession = (PortletSession)this.getSession(create);
        sessionId = portletSession == null && !create ? "" : portletSession.getId();
        return sessionId;
    }

    public void setClientWindow(ClientWindow clientWindow) {
        this.clientWindow = clientWindow;
    }

    @Override
    protected Cookie createCookie(String name, String value, Map<String, Object> properties) {
        Boolean httpOnly;
        Cookie cookie = super.createCookie(name, value, properties);
        if (properties != null && !properties.isEmpty() && (httpOnly = (Boolean)properties.get(COOKIE_PROPERTY_HTTP_ONLY)) != null) {
            cookie.setHttpOnly(httpOnly.booleanValue());
        }
        return cookie;
    }
}

