/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.context.internal;

import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import jakarta.faces.application.ProjectStage;
import jakarta.faces.context.ExceptionHandler;
import jakarta.faces.context.ExceptionHandlerWrapper;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.ExceptionQueuedEvent;
import jakarta.faces.event.ExceptionQueuedEventContext;
import java.util.Iterator;

public class ExceptionHandlerBridgeImpl
extends ExceptionHandlerWrapper {
    private static final Logger logger = LoggerFactory.getLogger(ExceptionHandlerBridgeImpl.class);
    private ExceptionHandler wrappedExceptionHandler;

    public ExceptionHandlerBridgeImpl(ExceptionHandler exceptionHandler) {
        this.wrappedExceptionHandler = exceptionHandler;
    }

    public ExceptionHandler getWrapped() {
        return this.wrappedExceptionHandler;
    }

    public void handle() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext.getPartialViewContext().isAjaxRequest()) {
            Iterable unhandledExceptionQueuedEvents = this.getUnhandledExceptionQueuedEvents();
            Iterator itr = unhandledExceptionQueuedEvents.iterator();
            boolean isDevelopment = facesContext.isProjectStage(ProjectStage.Development);
            while (itr.hasNext()) {
                ExceptionQueuedEvent exceptionQueuedEvent = (ExceptionQueuedEvent)itr.next();
                ExceptionQueuedEventContext exceptionQueuedEventContext = exceptionQueuedEvent.getContext();
                if (exceptionQueuedEventContext != null) {
                    Throwable throwable = exceptionQueuedEventContext.getException();
                    if (throwable != null) {
                        if (isDevelopment) {
                            logger.error(throwable);
                            continue;
                        }
                        logger.error(throwable.getMessage());
                        continue;
                    }
                    logger.error("Unable to get exception from exceptionQueuedEventContext");
                    continue;
                }
                logger.error("Unable to get exceptionQueuedEventContext from exceptionQueuedEvent");
            }
        }
        super.handle();
    }
}

