/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.component.internal;

import com.liferay.faces.bridge.internal.PortletConfigParam;
import com.liferay.faces.bridge.internal.PortletConfigParamUtil;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import java.util.Map;
import org.icefaces.ace.component.fileentry.FileEntry;

public class FileEntryBridgeImpl
extends FileEntry {
    private static final AttributeGetter<Long> MAX_FILE_SIZE_GETTER = new AttributeGetterMaxFileSizeImpl();
    private static final AttributeGetter<String> ABSOLUTE_PATH_GETTER = new AttributeGetterAbsolutePathImpl();

    public String getAbsolutePath() {
        return ABSOLUTE_PATH_GETTER.getAttribute(this);
    }

    public long getMaxFileSize() {
        return MAX_FILE_SIZE_GETTER.getAttribute(this);
    }

    private String getOriginalAbsolutePath() {
        return super.getAbsolutePath();
    }

    private long getOriginalMaxFileSize() {
        return super.getMaxFileSize();
    }

    private static final class AttributeGetterMaxFileSizeImpl
    extends AttributeGetter<Long> {
        private static final String BRIDGE_MAX_FILE_SIZE_ATTR_NAME = AttributeGetterMaxFileSizeImpl.class.getName() + ".maxFileSize";

        private AttributeGetterMaxFileSizeImpl() {
        }

        @Override
        public Long getAttribute(FileEntryBridgeImpl fileEntryBridgeImpl) {
            return (Long)this.getAttribute(fileEntryBridgeImpl, BRIDGE_MAX_FILE_SIZE_ATTR_NAME, PortletConfigParam.UploadedFileMaxSize);
        }

        @Override
        Long convertInitParamStringValueToAttribute(String initParamValue) {
            return Long.parseLong(initParamValue);
        }

        @Override
        Long getOriginalAttribute(FileEntryBridgeImpl fileEntryBridgeImpl) {
            return fileEntryBridgeImpl.getOriginalMaxFileSize();
        }

        @Override
        boolean useOriginalAttribute(Long attr, FileEntryBridgeImpl fileEntryBridgeImpl) {
            return attr > fileEntryBridgeImpl.getOriginalMaxFileSize();
        }
    }

    private static final class AttributeGetterAbsolutePathImpl
    extends AttributeGetter<String> {
        private static final String BRIDGE_ABSOLUTE_PATH_ATTR_NAME = AttributeGetterMaxFileSizeImpl.class.getName() + ".absolutePath";

        private AttributeGetterAbsolutePathImpl() {
        }

        @Override
        public String getAttribute(FileEntryBridgeImpl fileEntryBridgeImpl) {
            return (String)this.getAttribute(fileEntryBridgeImpl, BRIDGE_ABSOLUTE_PATH_ATTR_NAME, PortletConfigParam.UploadedFilesDir);
        }

        @Override
        String convertInitParamStringValueToAttribute(String initParamValue) {
            return initParamValue;
        }

        @Override
        String getOriginalAttribute(FileEntryBridgeImpl fileEntryBridgeImpl) {
            return fileEntryBridgeImpl.getOriginalAbsolutePath();
        }

        @Override
        boolean useOriginalAttribute(String attr, FileEntryBridgeImpl fileEntryBridgeImpl) {
            return true;
        }
    }

    private static abstract class AttributeGetter<T> {
        private AttributeGetter() {
        }

        public abstract T getAttribute(FileEntryBridgeImpl var1);

        abstract T convertInitParamStringValueToAttribute(String var1);

        abstract T getOriginalAttribute(FileEntryBridgeImpl var1);

        abstract boolean useOriginalAttribute(T var1, FileEntryBridgeImpl var2);

        final T getAttribute(FileEntryBridgeImpl fileEntryBridgeImpl, String bridgeAttrName, PortletConfigParam portletConfigParam) {
            Map attributes = fileEntryBridgeImpl.getAttributes();
            Object attr = attributes.get(bridgeAttrName);
            if (attr == null) {
                FacesContext facesContext = fileEntryBridgeImpl.getFacesContext();
                ExternalContext externalContext = facesContext.getExternalContext();
                String initParamStringValue = PortletConfigParamUtil.getStringValue(externalContext, portletConfigParam);
                if (initParamStringValue == null) {
                    attr = this.getOriginalAttribute(fileEntryBridgeImpl);
                } else {
                    attr = this.convertInitParamStringValueToAttribute(initParamStringValue);
                    if (this.useOriginalAttribute(attr, fileEntryBridgeImpl)) {
                        attr = this.getOriginalAttribute(fileEntryBridgeImpl);
                    }
                }
            }
            return (T)attr;
        }
    }
}

